<?php
    /**
     * @class  laweb_xeView
     * @author XE스쿨 북마크 모듈 만들기 예제를 편집함
     * @brief laweb_xe 모듈의 view class
     **/

    class laweb_xeView extends laweb_xe {

         /**
         * @brief 초기화
         **/
		 function init() {

			 // 목록 수 list_count에 대한 설정
			 if($this->module_info->list_count) $this->list_count = $this->module_info->list_count;

            // module_srl이 있으면 미리 체크하여 존재하는 모듈이면 module_info 세팅
            $module_srl = Context::get('module_srl');
            if(!$module_srl && $this->module_srl) {
                $module_srl = $this->module_srl;
                Context::set('module_srl', $module_srl);
            }
 
            // module model 객체 생성
            $oModuleModel = &getModel('module');
 
            // module_srl이 넘어오면 해당 모듈의 정보를 미리 구해 놓음
            // 모듈의 브라우저 타이틀, 관리자, 레이아웃 등 xe_modules table의 값과 정보
            if($module_srl) {
                $module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
                $this->module_info = $module_info;
                Context::set('module_info',$module_info);
            }
 
            // 스킨 경로를 미리 template_path 라는 변수로 설정함
            // 스킨이 존재하지 않는다면 default로 변경
            $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            if(!is_dir($template_path)||!$this->module_info->skin) {
                $this->module_info->skin = 'default';
                $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
            }
            $this->setTemplatePath($template_path);
        }
		
        /**
         * @brief 목록
         **/
        function dispLaweb_xeList() {

            // module_srl 확인
            $module_srl = Context::get('module_srl');
            $args->module_srl = $module_srl;
            $args->page = Context::get('page');
			$args->list_count = $this->list_count; 

 			// laweb_xe 모델을 이용해 목록을 가져옴 (laweb_xe.model.php 모델파일을 사용하는 경우)
            $oLaweb_xeModel = &getModel('laweb_xe');
            $output = $oLaweb_xeModel->getLaweb_xeList($args);
			if(!$output->data) $output->data = array();

            // $laweb_xe_list 변수에 담는다.
            Context::set('laweb_xe_list', $output->data);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);
 
            // template_file을 list.html로 지정
            $this->setTemplateFile('lawList');

        }

    }
?>