<?php
    /**
     * @class  wiselawebClAdminController
     * @author XE스쿨 북마크 모듈 만들기 예제를 편집함
     * @brief  wiselawebCl 모듈의 admin controller class
     **/

    class laweb_xeAdminController extends laweb_xe {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief laweb_xe 모듈(mid) 추가
         **/
		function procLaweb_xeAdminInsert($args = null) {
           // module 모듈의 model/controller 객체 생성
			$oModuleController = &getController('module');
			$oModuleModel = &getModel('module');

			// request 값을 모두 받음
			$args = Context::getRequestVars();
			$args->module = 'laweb_xe';

			// module_srl이 넘어오면 원 모듈이 있는지 확인
			if($args->module_srl) {
				$module_info = $oModuleModel->getModuleInfoByModuleSrl($args->module_srl);
				if($module_info->module_srl != $args->module_srl) unset($args->module_srl);
			}

			// module_srl 값의 존재여부에 따라 insert/update
			if(!$args->module_srl) {
				$output = $oModuleController->insertModule($args);
				$msg_code = 'success_registed';
			} else {
				$output = $oModuleController->updateModule($args);
				$msg_code = 'success_updated';
			}
			// 오류가 있으면 리턴
			if(!$output->toBool()) return $output;

			// 메시지 등록
			$this->setMessage($msg_code);

			// success_return_url의 존재여부에 따라 URL 재지정
			if (Context::get('success_return_url')){
				$this->setRedirectUrl(Context::get('success_return_url'));
			}else{
				$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispLaweb_xeAdminInfo', 'module_srl', $output->get('module_srl')));
			}

		}
		

        /**
         * @brief laweb_xe 모듈(mid) 삭제
         **/
        function procLaweb_xeAdminDelete() {
			// 삭제를 요청하는 module_srl 확인
            $module_srl = Context::get('module_srl');

            // 원본을 찾아 삭제
            $oModuleController = &getController('module');
            $output = $oModuleController->deleteModule($module_srl);
            if(!$output->toBool()) return $output;

			// 메시지 등록
			$msg_code = 'success_deleted';
  			$this->setMessage($msg_code);

			// success_return_url의 존재여부에 따라 URL 재지정
			if (Context::get('success_return_url')){
				$this->setRedirectUrl(Context::get('success_return_url'));
			}else{
				$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispLaweb_xeAdminList', 'module_srl', ''));
			}
	
		}

	}
?>