<?php
/**
 * @class  imageprocessAdminController
 * @author karma (http://www.wildgreen.co.kr)
 * @brief imageprocess 모듈의 admin controller 클래스
 **/

class imageprocessAdminController extends imageprocess 
{

	/**
	 * @brief 초기화
	 **/
	function init() 
	{
	}

	function procImageprocessAdminSetup() 
	{
		$oModuleController = &getController('module');
		$oModuleModel = &getModel('module');
		$ipConfig = $oModuleModel->getModuleConfig('imageprocess');

		$ipConfig->resize_use = Context::get('resize_use');
		$ipConfig->resize_width = Context::get('resize_width');
		$ipConfig->target_width = Context::get('target_width');
		$ipConfig->resize_quality = Context::get('resize_quality');
		if($ipConfig->resize_quality >100) $ipConfig->resize_quality = 100;
		elseif(!$ipConfig->resize_quality) $ipConfig->resize_quality = 80;
        $ipConfig->target_mid = str_replace('|@|',';', trim(Context::get('target_mid')));
		if($ipConfig->resize_use != 'Y' && $ipConfig->watermark_use != 'Y') $ipConfig->original_store = 'N';       
 
		$oModuleController->insertModuleConfig('imageprocess', $ipConfig);
		
		return new Object(0,"success_updated");
	}


    function procImageprocessAdminWatermarkSetup() 
	{
        $oModuleController = &getController('module');
        $oModuleModel = &getModel('module');
        $ipConfig = $oModuleModel->getModuleConfig('imageprocess');

		$ipConfig->watermark_use = Context::get('watermark_use');
        $ipConfig->minimum_width = Context::get('minimum_width');
        $ipConfig->watermark = Context::get('watermark');
		$ipConfig->xmargin = Context::get('xmargin');
		if($ipConfig->xmargin == '') $ipConfig->xmargin = 10;
		$ipConfig->ymargin = Context::get('ymargin');
        if($ipConfig->ymargin == '') $ipConfig->ymargin = 10;
		$ipConfig->water_quality = Context::get('water_quality');
		if(!$ipConfig->water_quality || $ipConfig->water_quality > 100) $ipConfig->water_quality = 100;
        $ipConfig->water_position = Context::get('water_position');
        $ipConfig->water_mid = str_replace('|@|',';',trim(Context::get('water_mid')));
		$ipConfig->ext = str_replace('|@|',';',trim(Context::get('ext')));
		if(!$ipConfig->ext) $ipConfig->ext = 'jpg';

		if($ipConfig->watermark_use != 'Y') $ipConfig->watermark = '';
		elseif($ipConfig->watermark_use == 'Y') 
		{
			if(!$ipConfig->watermark) $ipConfig->watermark = './modules/imageprocess/stamp/stamp.png';
			if(!file_exists($ipConfig->watermark)) return new Object(-1, 'none_image');
			if(!preg_match("/\.png$/i", $ipConfig->watermark)) return new Object(-1, 'notpng');
		}
		if($ipConfig->resize_use != 'Y' && $ipConfig->watermark_use != 'Y') $ipConfig->original_store = 'N';

        //
		$mids = explode(';',$ipConfig->water_mid);
        if(count($mids))
        {
            $watermark=array();
            $xmargin = array();
            $ymargin = array();
            $water_position = array();
            foreach($mids as $mid)
            {
				$watermark[$mid] =  trim(Context::get('watermark_'.$mid));
                $xmargin[$mid] = Context::get('xmargin_'.$mid);
                $ymargin[$mid] = Context::get('ymargin_'.$mid);
                $water_position[$mid] = Context::get('water_position_'.$mid);
            }
			$ipConfig->each_watermark = $watermark;
            $ipConfig->each_xmargin = $xmargin;
            $ipConfig->each_ymargin = $ymargin;
            $ipConfig->each_position = $water_position;
        }
        else $ipConfig->each_watermark = NULL;
		//

		$oModuleController->insertModuleConfig('imageprocess', $ipConfig);
        return new Object(0,"success_updated");
    }


    function procImageprocessAdminOfileSetup() 
	{
        $oModuleController = &getController('module');
        $oModuleModel = &getModel('module');

		$ofolder = Context::get('store_path');
		if($ofolder && !$this->checkfolder($ofolder)) return new Object(-1, 'checkfolder');

        $ipConfig = $oModuleModel->getModuleConfig('imageprocess');

		$ipConfig->store_path =$ofolder;
        $ipConfig->original_store= Context::get('original_store');
        $ipConfig->store_mid = str_replace('|@|',';',trim(Context::get('store_mid')));
		$ipConfig->down_group = str_replace('|@|',';',trim(Context::get('down_group')));

        $oModuleController->insertModuleConfig('imageprocess', $ipConfig);

        return new Object(0,"success_updated");
    }

	function procImageprocessAdminEtcSetup() 
	{
        $oModuleController = &getController('module');
        $oModuleModel = &getModel('module');
        $ipConfig = $oModuleModel->getModuleConfig('imageprocess');

        $ipConfig->change_kfile= Context::get('change_kfile');
        $ipConfig->magic_use = Context::get('magic_use');
		$ipConfig->rotate_use = Context::get('rotate_use');
		$ipConfig->magic_path = str_replace('\\','/',Context::get('magic_path'));
		$ipConfig->magic_conversion = Context::get('magic_conversion');
		$ipConfig->magic_target = Context::get('magic_target');
		if(ini_get('safe_mode') && $ipConfig->magic_use == 'Y') return new Object(-1, 'ip_safe_mode');
		elseif($ipConfig->magic_use == 'Y' ) 
		{
			if($ipConfig->magic_path && !preg_match('/\/$/',$ipConfig->magic_path)) $ipConfig->magic_path .= '/';
			$command =$ipConfig->magic_path."identify -version";
			if (stripos(PHP_OS, 'WIN') === 0) 
			{ 
				$magic_path = str_replace('/','\\',$ipConfig->magic_path);
				$command = "\"".$magic_path."convert\" -version";
				$ver = shell_exec($command);
			} 
			else 	$ver = shell_exec($command);
			if(!stripos($ver,'imagemagick')) return new Object(-1, 'check_magic_path');
			$ipConfig->magic_conversion = Context::get('magic_conversion');
			$ipConfig->original_format = Context::get('original_format');
			$ipConfig->target_format = Context::get('target_format');
			if(!$ipConfig->target_format) $ipConfig->target_format = 'jpg';
		}

        $oModuleController->insertModuleConfig('imageprocess', $ipConfig);

        return new Object(0,"success_updated");
    }

	function checkfolder($dir) 
	{
		if(!is_dir($dir)) return false;
		// permission 체크
        if(is_writable($dir)) return true;
        else return false;
	}
}
/* End of file imageprocess.admin.controller.php */
/* Location: ./modules/imageprocess/imageprocess.admin.controller.php */
