<?php
class freedownload extends ModuleObject
{
    function moduleInstall()
    {
        //트리거 적용
        $oModuleController = getController('module');

        $oModuleController->deleteTrigger('file.downloadFile', 'point', 'controller', 'triggerBeforeDownloadFile', 'before');
        $oModuleController->deleteTrigger('member.doLogin', 'Point_Pop', 'controller', 'triggerAfterLogin', 'after');

        $oModuleController->insertTrigger('member.doLogin', 'freedownload', 'controller', 'triggerFreeloadAfter', 'after');
        $oModuleController->insertTrigger('member.deleteMember', 'freedownload', 'controller', 'triggerFreeloadDeleteAfter', 'after');
        $oModuleController->insertTrigger('file.downloadFile', 'freedownload', 'controller', 'triggerFreeloadDownloadAfter', 'after');
        $oModuleController->insertTrigger('file.downloadFile', 'freedownload', 'controller', 'triggerFreeloadDownloadBefore', 'before');
        $oModuleController->insertTrigger('display', 'freedownload', 'controller', 'triggerBeforeDisplay', 'before');

        //DB에 값 추가.
        $oMemberAdminModel = getAdminModel("member");
        $oFreeloadModel = getModel('freedownload');
        $oFreeloadController = getController('freedownload');

        $output = $oMemberAdminModel->getMemberList();

        if($output->data)
        {
            foreach($output->data as $member)
            {
                $freeload_info = $oFreeloadModel->getFreedownloadColumn($member->member_srl);

                if(count($freeload_info) == 0)
                    $oFreeloadController->create_registerColumn($member);
            }
        }

        //기본 값 적용. (Config)
        $oModuleModel = getModel('module');
        $oMemberModel = getModel("member");

        $config = $oModuleModel->getModuleConfig('freedownload');
        $MemberGroupList = $oMemberModel->getGroups();  // 그룹 정보를 가져온다.

        $config->time_set = 12;

        foreach($MemberGroupList as $GroupInfo)
        {
            $config->{'today'.$GroupInfo->group_srl} = 10;
        }

        $oModuleController->insertModuleConfig('freedownload', $config);

        return new Object();
    }

    function checkUpdate()
    {
        //트리거 업데이트 체크
        $oModuleModel = getModel('module');

        if(!$oModuleModel->getTrigger('member.doLogin', 'freedownload', 'controller', 'triggerFreeloadAfter', 'after')) return true;
        if(!$oModuleModel->getTrigger('member.deleteMember', 'freedownload', 'controller', 'triggerFreeloadDeleteAfter', 'after')) return true;
        if(!$oModuleModel->getTrigger('file.downloadFile', 'freedownload', 'controller', 'triggerFreeloadDownloadAfter', 'after')) return true;
        if(!$oModuleModel->getTrigger('file.downloadFile', 'freedownload', 'controller', 'triggerFreeloadDownloadBefore', 'before')) return true;
        if(!$oModuleModel->getTrigger('display', 'freedownload', 'controller', 'triggerBeforeDisplay', 'before')) return true;

        if($oModuleModel->getTrigger('member.doLogin', 'Point_Pop', 'controller', 'triggerAfterLogin', 'after')) return true;
        if($oModuleModel->getTrigger('file.downloadFile', 'point', 'controller', 'triggerBeforeDownloadFile', 'before')) return true;

        return false;
    }

    function moduleUpdate()
    {
        // 트리거 업데이트
        $oModuleModel = getModel('module');
        $oModuleController = getController('module');

        if(!$oModuleModel->getTrigger('member.doLogin', 'freedownload', 'controller', 'triggerFreeloadAfter', 'after'))
            $oModuleController->insertTrigger('member.doLogin', 'freedownload', 'controller', 'triggerFreeloadAfter', 'after');

        if(!$oModuleModel->getTrigger('member.deleteMember', 'freedownload', 'controller', 'triggerFreeloadDeleteAfter', 'after'))
            $oModuleController->insertTrigger('member.deleteMember', 'freedownload', 'controller', 'triggerFreeloadDeleteAfter', 'after');

        if(!$oModuleModel->getTrigger('file.downloadFile', 'freedownload', 'controller', 'triggerFreeloadDownloadAfter', 'after'))
            $oModuleController->insertTrigger('file.downloadFile', 'freedownload', 'controller', 'triggerFreeloadDownloadAfter', 'after');

        if(!$oModuleModel->getTrigger('file.downloadFile', 'freedownload', 'controller', 'triggerFreeloadDownloadBefore', 'before'))
            $oModuleController->insertTrigger('file.downloadFile', 'freedownload', 'controller', 'triggerFreeloadDownloadBefore', 'before');

        if(!$oModuleModel->getTrigger('display', 'freedownload', 'controller', 'triggerBeforeDisplay', 'before'))
            $oModuleController->insertTrigger('display', 'freedownload', 'controller', 'triggerBeforeDisplay', 'before');

        if($oModuleModel->getTrigger('member.doLogin', 'Point_Pop', 'controller', 'triggerAfterLogin', 'after'))
            $oModuleController->deleteTrigger('member.doLogin', 'Point_Pop', 'controller', 'triggerAfterLogin', 'after');

        if($oModuleModel->getTrigger('file.downloadFile', 'point', 'controller', 'triggerBeforeDownloadFile', 'before'))
            $oModuleController->deleteTrigger('file.downloadFile', 'point', 'controller', 'triggerBeforeDownloadFile', 'before');

        return new Object(0, 'success_updated');
    }

    function moduleUninstall(){
        $oModuleModel = getModel('module');
        $oModuleController = &getController('module');

        // 내가 만든 Trigger들을 제거해준다.
        $oModuleController->deleteTrigger('member.doLogin', 'freedownload', 'controller', 'triggerFreeloadAfter', 'after');
        $oModuleController->deleteTrigger('member.deleteMember', 'freedownload', 'controller', 'triggerFreeloadDeleteAfter', 'after');
        $oModuleController->deleteTrigger('file.downloadFile', 'freedownload', 'controller', 'triggerFreeloadDownloadAfter', 'after');
        $oModuleController->deleteTrigger('file.downloadFile', 'freedownload', 'controller', 'triggerFreeloadDownloadBefore', 'before');
        $oModuleController->deleteTrigger('display', 'freedownload', 'controller', 'triggerBeforeDisplay', 'before');

        // 원래 있던 Trigger들을 다시 만들어준다.
        if(!$oModuleModel->getTrigger('member.doLogin', 'Point_Pop', 'controller', 'triggerAfterLogin', 'after'))
            $oModuleController->insertTrigger('member.doLogin', 'Point_Pop', 'controller', 'triggerAfterLogin', 'after');

        if(!$oModuleModel->getTrigger('file.downloadFile', 'point', 'controller', 'triggerBeforeDownloadFile', 'before'))
            $oModuleController->insertTrigger('file.downloadFile', 'point', 'controller', 'triggerBeforeDownloadFile', 'before');


        // DB에 접근해서 들어가있는 값을 모두 다 지워준다.
        executeQuery('freedownload.deleteFreeloadAll');

        return new Object();
    }
}
?>