<?php
    class freedownloadAdminView extends freedownload
    {
        public function Init()
        {
            $this->setTemplatePath($this->module_path.'tpl');
        }

        public function dispFreedownloadAdminView()
        {
            $oMemberModel = getModel('member');

            $oFreeloadModel = getModel('freedownload');

            $group_list = $oMemberModel->getGroups();
            Context::set("group_list", $group_list);

            $args = new stdClass();
            $args->list_count = 20;
            $args->page = Context::get('page');

            $output = $oFreeloadModel->getMemberList($args);

            if($output->data)
            {
                foreach($output->data as $key=>$member)
                {
                    $member_freeloadCount =  $oFreeloadModel->check_memberColumn($member->member_srl)->point;

                    if($member_freeloadCount)
                        $output->data[$key]->point = $member_freeloadCount;
                    else
                        $output->data[$key]->point = 0;


                    $output->data[$key]->group_list = $oMemberModel->getMemberGroups($member->member_srl,0);
                }
            }

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);
            Context::set("output_list", $output);
            Context::set("output", $output->data);

            $index_href = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispFreedownloadAdminIndex');
            $view_index = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispFreedownloadAdminView');

            $href = new stdClass();
            $href->index_href = $index_href;
            $href->view_index = $view_index;

            Context::set("href", $href);

            $this->setTemplateFile("view");
        }

        //전역으로 선언할건 전역으로
        public function  dispFreedownloadAdminIndex()
        {
            $oModuleModel = getModel('module');
            $oMemberModel = getModel("member");

            //freeload의 설정값을 가져온다.
            $freeload_config = $oModuleModel->getModuleConfig('freedownload');
            $freeload_config->time_set = abs($freeload_config->time_set);

            Context::set("freeload",$freeload_config);

            $radio_config = new stdClass();

            if($freeload_config->time_way == "player")
            {
                $radio_config->now_time = "";
                $radio_config->player_time = "checked='checked'";
            }

            else
            {
                $radio_config->now_time = "checked='checked'";
                $radio_config->player_time = "";
            }

            Context::set("radio_config", $radio_config);
            //그룹 정보가져온다.
            $MemberGroupList = $oMemberModel->getGroups();

            //정보를 저장한다.
            $GroupConfig = array();

            foreach($MemberGroupList as $Srl => $GroupInfo)
            {
                $GroupConfig[$Srl] = new stdClass;
                $GroupConfig[$Srl]->title = $GroupInfo->title;
                $GroupConfig[$Srl]->name = 'today'.$GroupInfo->group_srl;
                $GroupConfig[$Srl]->value = $freeload_config->{$GroupConfig[$Srl]->name};
            }

            Context::set("GroupConfig", $GroupConfig);

            $index_href = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispFreedownloadAdminIndex');
            $view_index = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispFreedownloadAdminView');

            $href = new stdClass();
            $href->index_href = $index_href;
            $href->view_index = $view_index;

            Context::set("href", $href);


            $this->setTemplateFile("index");
        }
    }
?>
