<?php
    class freedownloadController extends freedownload
    {
        //설치될때 DB를 만든다. & 아직 해당 칼럼이 없을 때 (ok) + Date 보류, 분류(상황)
        function create_newColumn($member_info)
        {
            $oMemberModel = getModel('member');
            $oModuleModel = getModel('module');

            $member_srl = $member_info->member_srl;

            $freeload_config = $oModuleModel->getModuleConfig('freedownload');
            $member_group = $oMemberModel->getMemberGroups($member_srl);

            $charge_point = 0;
            foreach($member_group as $key=>$group_info)
            {
                if($charge_point < $freeload_config->{"today".$key})
                    $charge_point = $freeload_config->{"today".$key};
            }

            $args = new stdClass();
            $args->member_srl = $member_info->member_srl;
            $args->regdate = date('YmdHis');
            $args->point = $charge_point;

            executeQuery("freedownload.InsertFreeloadNum", $args);
        }

        //설치될때 DB를 만든다. & 아직 해당 칼럼이 없을 때 (ok) + Date 보류, 분류(상황)
        function create_registerColumn($member_info)
        {
            $oMemberModel = getModel('member');
            $oModuleModel = getModel('module');

            $member_srl = $member_info->member_srl;
            $freeload_config = $oModuleModel->getModuleConfig('freedownload');
            $member_group = $oMemberModel->getMemberGroups($member_srl);

            $charge_point = 0;
            foreach($member_group as $key=>$group_info)
            {
                if($charge_point < $freeload_config->{"today".$key})
                    $charge_point = $freeload_config->{"today".$key};
            }

            $args = new stdClass();
            $args->member_srl = $member_srl;
            $args->regdate = $member_info->last_login;
            $args->point = $charge_point;

            executeQuery("freedownload.InsertFreeloadNum", $args);
        }

        //로그인할때 상황에 맞게 이벤트를 진행 (ok) + 소스 코드 줄이기
        function set_loginColumn($freeload_info)
        {
            session_start();    //세션을 사용하기 위해.

            $oMemberModel = getModel('member');
            $oModuleModel = getModel('module');

            $member_srl = $freeload_info->member_srl;
            $freeload_config = $oModuleModel->getModuleConfig('freedownload');
            $member_group = $oMemberModel->getMemberGroups($member_srl);

            //srl 가져오기 위한 과정.
            $charge_point = 0;
            foreach($member_group as $key=>$group_info)
            {
                if($charge_point < $freeload_config->{"today".$key})
                    $charge_point = $freeload_config->{"today".$key};
            }

            $config_time = $freeload_config->time_set;
            $config_timeType = $freeload_config->time_way;
            $config_point = $charge_point;

            $nowTime = date('YmdHis');

            //플레이어 시간을 기준. (ok)
            if($config_timeType == "player")
            {
                //$chargeTime 변환 후 +시간하고 다시 변환.
                $chargeTime = strtotime($freeload_info->regdate);
                $chargeTime = strtotime("+".$config_time."hour", $chargeTime);
                $chargeTime = time('YmdHis', $chargeTime);

                if($nowTime >= $chargeTime)
                {
                    $_SESSION['freeload_login'] = "true";

                    $args = new stdClass();
                    $args->member_srl = $member_srl;
                    $args->regdate = $nowTime;
                    $args->point = $config_point;
                    executeQuery('freedownload.updateFreeloadNum', $args);
                }
            }

            // 해당 날의 시간을 기준.
            else
            {
                //설정 시간을 가져온다.
                $dateArray = array(date($config_time),date('m'),date('d'), date('Y') );
                $configTime = mktime($dateArray[0], 0, 0, $dateArray[1], $dateArray[2], $dateArray[3]);
                $configTime = date('YmdHi', $configTime);

                //로그인 시간을 가져온다.
                $login_date = $freeload_info->regdate;
                $login_date = substr($login_date, 0, 12);
                $login_date += ($config_time * 100);    //100을 곱하는 이유 시간 뒤에 분(두자리)

                if($login_date < $configTime)
                {
                    $_SESSION['freeload_login'] = "true";

                    $args = new stdClass();
                    $args->member_srl = $member_srl;
                    $args->regdate = $nowTime;
                    $args->point = $config_point;
                    executeQuery('freedownload.updateFreeloadNum', $args);
                }
            }
        }

        //로그인 시 발생하는 이벤트  (로그인) (ok) => act
        public function triggerFreeloadAfter(&$member_info)
        {
            session_start();

            $this->setRedirectUrl(getNotEncodedUrl(''));

            $oFreeloadModel = getModel('freedownload');

            $member_srl = $member_info->member_srl;

            $freeload_info = $oFreeloadModel->getFreedownloadColumn($member_srl);

            if(count($freeload_info) == 0) {
                $this->create_newColumn($member_info);
                $_SESSION['freeload_login'] = "true";
            }

            else { $this->set_loginColumn($freeload_info); }

            return new Object();
        }

        //member_srl 기준으로 칼럼을 삭제해준다. (ok)
        function delete_srlColumn($member_srl)
        {
            $args = new stdClass();
            $args->member_srl = $member_srl;

            executeQuery('freedownload.deleteFreeloadNum', $args);
        }

        //회원탈퇴 시 해당하는 맴버의 칼럼을 삭제시켜준다. (ok) => act
        public function triggerFreeloadDeleteAfter(&$obj)
        {
            $this->delete_srlColumn($obj->member_srl);
        }

        //! 쿼리 Update쪽 이름 바꾸기. (ok)
        function procFreedownloadSetPoint($member_srl, $point)
        {
            $args = new stdClass();
            $args->member_srl = $member_srl;
            $args->point = $point;

            executeQuery('freedownload.updateFreeloadPoint',$args);
        }

        //다운받을 수 있는 상황인지 검사한다. (ok) + Point 업데이트 내용 안보이게 하기. => act
        public function triggerFreeloadDownloadBefore(&$obj)
        {
            $tpl_file = 'Freeload_Pop';
            $oTemplate = &TemplateHandler::getInstance();
            $oTemplate->compile('./modules/freedownload/tpl', $tpl_file);

            $logged_info = Context::get('logged_info');
            $member_srl = $logged_info->member_srl;
            $module_srl = $obj->module_srl;
            if(!$module_srl) return new Object();
            // Pass if it is your file
            if(abs($obj->member_srl) == abs($member_srl)) return new Object();

            $oModuleModel = getModel('module');
            $config = $oModuleModel->getModuleConfig('point');
            $module_config = $oModuleModel->getModulePartConfig('point', $module_srl);
            // If it is set not to allow downloading for non-logged in users, do not permit

            if(!Context::get('is_logged'))
            {
                if($config->disable_download == 'Y' && strlen($module_config['download_file']) == 0 && !is_int($module_config['download_file'])) return new Object(-1,'msg_not_permitted_download');
                else return new Object();
            }

            // Get the points of the member
            $oPointModel = getModel('point');
            $cur_point = $oPointModel->getPoint($member_srl, true);
            // Get the points
            $point = $module_config['download_file'];
            if(strlen($point) == 0 && !is_int($point)) $point = $config->download_file;
            // If points are less than 0, and if downloading a file is not allowed in this case, give an errors

            /*여기서부터 내가 추가한 쪽.*/

            //freeload point를 가져온다.
            $oFreeloadModel = getModel("freedownload");
            $freeload_info = $oFreeloadModel->getFreedownloadColumn($member_srl);

            $freeload_point = $freeload_info->point;

            if($freeload_point - 1 < 0)
            {
                if($cur_point + $point < 0 && $config->disable_download == 'Y') return new Object(-1,'msg_cannot_download');
            }

            return new object();
        }

        //다운받을 때 필요한 값만큼 감소(point 또는 freeload_count) (ok) + 마지막 return 값 => act
        public function triggerFreeloadDownloadAfter(&$obj)
        {
            $tpl_file = 'Freeload_Pop';
            $oTemplate = &TemplateHandler::getInstance();
            $oTemplate->compile('./modules/freedownload/tpl', $tpl_file);

            $PointController = getController('point');
            $logged_info = Context::get('logged_info');
            if(!$logged_info->member_srl) return new Object();

            $module_srl = $obj->module_srl;
            $member_srl = $logged_info->member_srl;
            if(!$module_srl) return new Object();

            // Pass if it is your file (ㅆㅂ 여기가 문제 였음) => 테스트할떄 내가 하나로만 함. (이 부분을 명심해야함)
            if(abs($obj->member_srl) == abs($member_srl)) return new Object();

            // Get the point module information
            $oModuleModel = getModel('module');
            $config = $oModuleModel->getModuleConfig('point');
            $module_config = $oModuleModel->getModulePartConfig('point', $module_srl);

            // Get the points of the member
            $oPointModel = getModel('point');
            $cur_point = $oPointModel->getPoint($member_srl, true);

            // Get the points
            $point = $module_config['download_file'];
            if(strlen($point) == 0 && !is_int($point)) $point = $config->download_file;

            /*여기서부터 내가 추가한 쪽.*/

            //freeload point를 가져온다.
            $oFreeloadModel = getModel("freedownload");
            $freeload_info = $oFreeloadModel->getFreedownloadColumn($member_srl);

            $freeload_point = $freeload_info->point;

            // Increase the point
            if($freeload_point <= 0)
            {
                $cur_point += $point;
                $PointController->setPoint($member_srl,$cur_point);
            }

            else
            {
                $freeload_point -= 1;
                $this->procFreedownloadSetPoint($member_srl, $freeload_point);
            }

            return new Object(-1, "00");
        }

        //화면에 뿌려주는 부분을 관여.
        public function triggerBeforeDisplay(&$output_disp)
        {
            session_start();

            $login_info = Context::get('logged_info');
            $member_srl = $login_info->member_srl;
            $oDocument = Context::get('oDocument');

            if($login_info != null)
            {
                //로그인 시 화면에 뿌려준다. (포인트가 충전될 때 한정)
                if($_SESSION['freeload_login'] != null)
                {
                    $oFreeloadModel = getModel('freedownload');
                    $freeload_info = $oFreeloadModel->getFreedownloadColumn($member_srl);

                    unset($_SESSION['freeload_login']);
                    $loginScript = "
                    <script>
                        (function($){
                            $(document).ready(function(){
                                alert($freeload_info->point + '무료포인트가 충전되었습니다.');
                            });
                        })(jQuery);
                    </script>";

                    Context::addHtmlHeader($loginScript);
                }

                if($oDocument != null)
                {
                    //포인트 값을 가져오기 위해서.
                    $oFreeloadModel = getModel('freedownload');

                    //무료포인트에 대한 정보를 가져온다.
                    $freeload_info = $oFreeloadModel->getFreedownloadColumn($member_srl);
                    $freeload_point = $freeload_info->point;

                    // 본인이 업로드 한 것.
                    if($member_srl == $oDocument->variables['member_srl']) return;

                    // 포인트가 0이면 출력 안함.
                    if($freeload_point < 0) return;

                    // 파일이 정상적인지 체크하는 과정.
                    $oFileModel = getModel("file");
                    $columnList = array('uploaded_filename');

                    $document_srl = Context::get("document_srl");

                    $files_info = $oFileModel->getFiles($document_srl,$columnList);
                    $file_count = $oFileModel->getFilesCount($document_srl);

                    //파일이 없으면 return
                    if($file_count < 1) return;


                    //$matches = $_SERVER['HTTP_USER_AGENT'];

                    //사용할 다운로드 버튼들을 찾는다.
                    $files_script = array();
                    $count =0;
                    for($i = 0; $i < $file_count; $i++)
                    {
                        $file_uploadName = $files_info[$i]->uploaded_filename;

                        if(file_exists($file_uploadName)) {
                            $files_script[$count] = "function eventFunction".$i."(){
                                    if(freeloadNum - 1 >= 0)
                                    {
                                        freeloadNum -=1;
                                        alert('무료 포인트를 사용하셨습니다. 남은 포인트는' + freeloadNum +'입니다.');
                                    }
                                };

                                if(window.addEventListener){
                                    files_li[".$i."].children[0].addEventListener('click', eventFunction".$i.");
                                }
                                else if(window.attachEvent){
                                    files_li[".$i."].children[0].attachEvent('onclick', eventFunction".$i.");
                                }
                                ";

                            $count += 1;
                        }
                    }

                    //스크립트 처음.
                    $downloadScript_start = "<script>
                    (function($){
                        $(document).ready(function(){
                            var files = $('.files');
                            console.log(files);

                            var files_li = $('.files > li');
                            console.log(files_li[0]);

                            var freeloadNum = $freeload_point;

                    ";

                    //액션 부분.
                    for($i = 0; $i < $file_count; $i++)
                    {
                        $downloadScript_start = $downloadScript_start.$files_script[$i];
                    }

                    //스크립트 끝.
                    $downloadScript_end = "});})(jQuery);</script>";

                    $downloadScript = $downloadScript_start.$downloadScript_end;

                    Context::addHtmlHeader($downloadScript);
                }
            }
        }
    }
?>