<?php
    class freedownloadAdminController extends freedownload
    {
        public function procFreedownloadSetup()
        {
            $oModuleModel = getModel('module');
            $config = $oModuleModel->getModuleConfig('freedownload');

            $config->time_set = 8;
        }

        public function procFreedownloadAdminSaveValue()
        {
            $oModuleModel = getModel('module');
            $config = $oModuleModel->getModuleConfig('freedownload');

            $args = Context::getRequestVars();
            unset($args->error_return_url);
            unset($args->module);
            unset($args->act);


            if($args->time_set < 0)
                $args->time_set = abs($args->time_set);

            $config = $args;

            $oModuleController = getController('module');
            $oModuleController->insertModuleConfig('freedownload', $config);

            $this->setMessage('success_update');

            $returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispFreedownloadAdminIndex');
            $this->setRedirectUrl($returnUrl);
        }

        public function procFreedownloadAdminSaveFreeloadNum()
        {
            $oFreeloadController = getController('freedownload');
            $requestVar = Context::getRequestVars();

            $member_srl = $requestVar->member_srl;
            $point = $requestVar->point;

            $oFreeloadController->set_point($member_srl,$point);

            $this->setMessage('success_update');

            $returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispFreedownloadAdminView');
            $this->setRedirectUrl($returnUrl);
        }
    }
?>