<?php
    /**
     * @class daum_postcode
     * @author jungbaksa (jungbaksa@jungbaksa.com)
     * @brief 다음 우편번호서비스 위젯
     * @version 0.1
     **/

    class daum_postcode extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 제목
            $widget_info->name = $args->name;
            $widget_info->zone = $args->zone;
            $widget_info->address1 = $args->address1;
            $widget_info->address2 = $args->address2;
            $widget_info->zone_value = $args->zone_value;
            $widget_info->address1_value = $args->address1_value;
            $widget_info->address2_value = $args->address2_value;
            $widget_info->width = $args->width;
            $widget_info->height = $args->height;

            Context::set('widget_info', $widget_info);

            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, "default");

            // 템플릿 파일을 지정
            $tpl_file = !$args->type ? 'iframe' : $args->type;

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }
    }
?>
