/**
 * @file hashtags.js
 * @brief javascript code for hashtags addon
 * @author phiDel(https://github.com/phiDelbak, xe.phidel@gmail.com)
 * @refer NHN (developers@xpressengine.com) js
 */
(function($){
	var Hashtags = xe.createPlugin("hashtags", {
		targets : [],
		init : function() {
			this.targets = [];
		},
		API_ONREADY : function() {
			var thisPlugin = this;

			// extract target text nodes
			this.extractTargets($('.xe_content'));

			$(this.targets).each(function() {
				thisPlugin.cast('HASHTAGS', [this]);
			});
		},
		API_HASHTAGS : function(oSender, params) {
			var textNode = params[0];
			if(!$(textNode).parent().length || $(textNode).parent().get(0).nodeName.toLowerCase() == 'a') return;
			var content = textNode.nodeValue,
				dummy = $('<span>'),
				opts = addonHashtagsJsOptions,
				newval;

			// is IS
			if(opts[1]) {
				newval = '<a href="./?mid='+current_mid+'&act=IS&where=document&search_target='+opts[0]+'&is_keyword=';
			} else {
				newval = '<a href="./?mid='+current_mid+'&search_target='+opts[0]+'&search_keyword=';
			}

			content = content.replace(/(?:^:|^|\s|>|&nbsp;)(#([\w|ㄱ-ㅎ|ㅏ-ㅣ|가-힣\-]+)){1,}/g, function(match) {
				return match.replace(/#([\w|ㄱ-ㅎ|ㅏ-ㅣ|가-힣\-]+)/g, function(m, p1) {
					return newval+encodeURIComponent(p1)+'" '+(opts[3]?'target="_blank" ':'')+'style="color:'+opts[2]+'">#'+p1+'</a>';
				});
			});

			$(textNode).before(dummy);
			$(textNode).replaceWith(content);
			params[0] = dummy.next('a');
			dummy.remove();
		},
		extractTargets : function(obj) {
			var thisPlugin = this,
				wrap = $('.xe_content', obj);
				
			if(wrap.length) {
				this.extractTargets(wrap);
				return;
			}

			$(obj)
			.contents()
			.each(function(){
				var node_name = this.nodeName.toLowerCase();
				if($.inArray(node_name, ['a', 'pre', 'xml', 'textarea', 'input', 'select', 'option', 'code', 'script', 'style', 'iframe', 'button', 'img', 'embed', 'object', 'ins']) != -1) return;

				if(this.nodeType == 3) { // text node
					var content = this.nodeValue;

					if(content.length < 2) return;
					if(!/(?:^:|^|\s|>|&nbsp;)#([\w|ㄱ-ㅎ|ㅏ-ㅣ|가-힣\-]+)/.test(content)) return;

					thisPlugin.targets.push(this);
				} else {
					thisPlugin.extractTargets(this);
				}
			});
		}
	});

	xe.registerPlugin(new Hashtags());
})(jQuery);