<?php
	if(!defined('__XE__')) exit();

	/**
	 * @hashtags.addon.php
	 * @author phiDel(https://github.com/phiDelbak, xe.phidel@gmail.com)
	 * @brief 해시태그 에드온
	 **/

	if(!class_exists('AddonHashtags', false))
	{
		class AddonHashtags
		{
			function setInfo(&$addon_info)
			{
				$this->addon_info = $addon_info;
			}

			function stripTagsEx($content)
			{
				$tags = array('a', 'pre', 'xml', 'textarea', 'input', 'select', 'option', 'code', 'script', 'style', 'iframe', 'button', 'img', 'embed', 'object', 'ins');
				$pattern = '/<(' . implode('|', $tags) . ')[^>]*>.*?<\/\1>/si';
				$content= preg_replace($pattern, '',$content);
				$content= strip_tags($content);
				return htmlspecialchars_decode($content, ENT_QUOTES);
			}

			function before_module_proc()
			{				
				if($this->addon_info->is_save_tags !== 'N' && preg_match('/^proc[A-Za-z]+InsertDocument/', Context::get('act')))
				{
					$GLOBALS['__AddonHashtags_matches__'] = array();
			        function __preg_callback($mc) {
			        	if(@preg_match_all('/#([\w|ㄱ-ㅎ|ㅏ-ㅣ|가-힣\-]+)/', $mc[0], $matches)) {
			        		$GLOBALS['__AddonHashtags_matches__'] = array_merge($GLOBALS['__AddonHashtags_matches__'], $matches[1]);
			        	}
			            return '';
			        }

					$content= $this->stripTagsEx(Context::get('content'));
					$pattern = '/(?:^:|^|\s|>|&nbsp;)(#([\w|ㄱ-ㅎ|ㅏ-ㅣ|가-힣\-]+)){1,}/';
					$content = preg_replace_callback($pattern, "__preg_callback", $content);

					if(count($GLOBALS['__AddonHashtags_matches__'])) {
						$tags = implode(',', $GLOBALS['__AddonHashtags_matches__']);
						Context::set('tags', $tags, true);
					}
				}
			}

			function before_display_content()
			{
				$target = $this->addon_info->hashtag_target;
				$color = $this->addon_info->hashtag_color;
				$blank = $this->addon_info->is_window_blank === 'Y'?'true':'false';
				$tarIS = $this->addon_info->is_Integration_search === 'Y'?'true':'false';
				Context::addHtmlHeader('<script> var addonHashtagsTarget = "'.($target?$target:'tag').'", addonHashtagsColor = "'.($color?$color:'blue').'", addonHashtagsBlank = '.$blank.', addonHashtagsTargetIS = '.$tarIS.'; </script>');
				Context::loadFile(array('./addons/hashtags/hashtags.js', 'body', '', null), true);
			}
		}

		$GLOBALS['__AddonHashtags__'] = new AddonHashtags;
		$GLOBALS['__AddonHashtags__']->setInfo($addon_info);
	}

	$oAddonHashtags = &$GLOBALS['__AddonHashtags__'];

	if(method_exists($oAddonHashtags, $called_position))
	{
		if(!call_user_func_array(array(&$oAddonHashtags, $called_position), array(&$this)))
		{
			return false;
		}
	}
?>
