<?php
/* Copyright (C) NAVER <http://www.navercorp.com> */
/**
 * @class login_info
 * @author NAVER (developers@xpressengine.com)
 * @version 0.1
 * @brief Widget to display log-in form
 *
 * $Pre-configured by using $logged_info
 */
class jwplayer extends WidgetHandler
{
	/**
	 * @brief Widget execution
	 * Get extra_vars declared in ./widgets/widget/conf/info.xml as arguments
	 * After generating the result, do not print but return it.
	 */
	function proc($args)
	{
		// Set a path of the template skin (values of skin, colorset settings)
		$tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);

		// Specify a template file
		$tpl_file = "jwplayer.html";

		$obj_id = "jwp_".rand(111,99999999);
		
		if(!$args->rtsp_url) $args->rtsp_url = $args->default_stream;
		if(!$args->hls_url) $args->hls_url = $args->default_stream;
		if(!$args->rtmp_url) $args->rtmp_url = $args->default_stream;

		// Get Browser Agent
		if(preg_match("/android/i", getenv("HTTP_USER_AGENT"))){
			$file_script = "sources: [{
								file: '".$args->rtsp_url."'
							}]";
		}else if(preg_match("/iphone/i", getenv("HTTP_USER_AGENT")) || preg_match("/ipad/i", getenv("HTTP_USER_AGENT"))){
			$file_script = "sources: [{
								file: '".$args->hls_url."'
							}]";
		}else{
			$file_script = "file: '".$args->rtmp_url."'";
		}

		// Override if 'YouTube URL Exists'
		if($args->youtube_url){
			$file_script = "";
			$args->youtube_url = str_replace("\r", "", $args->youtube_url);
			$youtubeArr = explode("\n", $args->youtube_url);
			
			$file_script = "
playlist: [{
	sources: [{\n		file: '".implode($youtubeArr, "'\n	}]\n}, {\n	sources: [{\n		file: '")."'
	}]
}]";
			// $file_string .= ",listbar: {position: 'bottom', size: 140}";
		}
		
		// Send Variables to Context
		Context::set("file_script", $file_script);
		
		// Send License Key to Context
		Context::set("license_key", $args->license_key);
				
		// Send About Text to Context
		Context::set("about_text", $args->about_text);
				
		// Send About Link to Context
		Context::set("about_link", $args->about_link);

		// Send Player width to Context
		Context::set("player_width", $args->player_width);

		// Send Player width to Context
		Context::set("player_height", $args->player_height);

		// Send License Key to Context
		Context::set("obj_id", $obj_id);

		// Compile a template
		$oTemplate = &TemplateHandler::getInstance();
		return $oTemplate->compile($tpl_path, $tpl_file);
	}
}
/* End of file login_info.class.php */
/* Location: ./widgets/login_info/login_info.class.php */
