<?php
class speedlimiterView extends speedlimiter
{
	/**
	 * @brief Add a form for editor addition setup
	 */
	function triggerDispEditorAdditionSetup(&$obj)
	{
		$oModuleModel = getModel("module");
		$oMemberModel = getModel("member");
		$current_module_srl = Context::get('module_srl');

		Context::set("current_module_srl", $current_module_srl);

		$MemberGroupList = $oMemberModel->getGroups();
		
		$this->module_config = $oModuleModel->getModulePartConfig('speedlimiter', $current_module_srl);
		
		$GroupConfig = array();
		foreach($MemberGroupList as $srl => $groupInfo)
		{
			$GroupConfig[$srl] = new stdClass;
			$GroupConfig[$srl]->title = $groupInfo->title;
			$GroupConfig[$srl]->name = 'speedlimit_'.$groupInfo->group_srl;
			$GroupConfig[$srl]->value = $this->module_config->{$GroupConfig[$srl]->name};
			$GroupConfig[$srl]->unit_name = 'speedunit_'.$groupInfo->group_srl;
			$GroupConfig[$srl]->unit = $this->module_config->{$GroupConfig[$srl]->unit_name};
		}
		
		Context::set("GroupConfig", $GroupConfig);
		Context::set("UnitArr", array("Mbps", "Gbps"));
		Context::set("module_config", $this->module_config);

		// Set a template file
		$oTemplate = &TemplateHandler::getInstance();
		$tpl = $oTemplate->compile($this->module_path.'tpl', 'speedlimiter_module_config');
		$obj .= $tpl;

		return new BaseObject();
	}
}