<?php
class speedlimiterController extends speedlimiter
{
	public function Init()
	{
		
	}
	
	public function procSpeedlimiterFileOutput()
	{
		@set_time_limit(0);
		@ini_set('max_execution_time', 0);
		
		$oModuleModel = getModel('module');
		$oFileModel = getModel('file');
		$file_srl = Context::get('file_srl');
		$file_key = Context::get('file_key');
		$module_config = $this->module_config;
		if(strstr($_SERVER['HTTP_USER_AGENT'], "Android")) $is_android = true;

		if($is_android && $_SESSION['__XE_FILE_KEY_AND__'][$file_srl]) $session_key = '__XE_FILE_KEY_AND__';
		else $session_key = '__XE_FILE_KEY__';
		$columnList = array('source_filename', 'uploaded_filename', 'file_size', 'module_srl');
		$file_obj = $oFileModel->getFile($file_srl, $columnList);

		$uploaded_filename = $file_obj->uploaded_filename;

		if(!file_exists($uploaded_filename)) return $this->stop('msg_file_not_found');

		if(!$file_key || $_SESSION[$session_key][$file_srl] != $file_key)
		{
			unset($_SESSION[$session_key][$file_srl]);
			// return $this->stop('msg_invalid_request');
		}

		$file_size = $file_obj->file_size;
		$filename = $file_obj->source_filename;
		if(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== FALSE || (strpos($_SERVER['HTTP_USER_AGENT'], 'Windows') !== FALSE && strpos($_SERVER['HTTP_USER_AGENT'], 'Trident') !== FALSE && strpos($_SERVER['HTTP_USER_AGENT'], 'rv:') !== FALSE))
		{
			$filename = rawurlencode($filename);
			$filename = preg_replace('/\./', '%2e', $filename, substr_count($filename, '.') - 1);
		}

		if($is_android)
		{
			if($_SESSION['__XE_FILE_KEY__'][$file_srl]) $_SESSION['__XE_FILE_KEY_AND__'][$file_srl] = $file_key;
		}

		// unset($_SESSION[$session_key][$file_srl]);
		
		// get Module Part Config
		$this->spl_module_config = $oModuleModel->getModulePartConfig('speedlimiter', $file_obj->module_srl);
		
		if($this->spl_module_config->enable_spl == 'Y') {
			$module_config = $this->spl_module_config;
		}
		
		// Set speed limit
		$speeddefault = true;
		if(!$module_config->speedlimit_default)
		{
			$speedlimit = 30;
			$speedunit = $module_config->speedunit_default;
			if(!$speedunit) $speedunit = 'Mbps';
			$speedbit = $this->calculate_speed($speedlimit, $speedunit);
		}
		else
		{
			$speedlimit = $module_config->speedlimit_default;
			$speedunit = $module_config->speedunit_default;
			if(!$speedunit) $speedunit = 'Mbps';
			$speedbit = $this->calculate_speed($speedlimit, $speedunit);
		}

		foreach($logged_info->group_list as $group_srl=>$group_title)
		{
			$speedVal = 'speedlimit_'.$group_srl;
			$unitVal = 'speedunit_'.$group_srl;
			
			if($module_config->{$speedVal} && $module_config->{$unitVal})
			{
				if($this->calculate_speed($module_config->{$speedVal}, $module_config->{$unitVal}) > $speedbit || $speeddefault == true)
				{
					$speedbit = $this->calculate_speed($module_config->{$speedVal}, $module_config->{$unitVal});
					unset($speeddefault);
				}
			}
		}
		// Remove variables
		unset($speedlimit);
		unset($speedunit);

		// Get module info with module_srl
		$parent_module_info = $oModuleModel->getModuleInfoByModuleSrl($file_obj->module_srl);
		
		// Check module specialize configuratino exists and enabled
		if($this->spl_module_config->enable_spl != 'Y')
		{
			// Check exec method
			if(!$module_config->exec_method)
				$module_config->exec_method = 'run_selected';
	
			// enable speedlimiter only module that mid exist
			if($parent_module_info->mid)
			{
				// When exec_method value is 'no_run_selected'
				if($module_config->exec_method == 'no_run_selected')
				{
					// when exec_method is 'no_run_selected' and module has selected
					if(!in_array($parent_module_info->mid, $module_config->mid_list))
						$useSpeedLimiter = true;
					else
						$useSpeedLimiter = false;
				}
				else
				{
					// when exec_method is 'run_selected' and module has selected
					if(in_array($parent_module_info->mid, $module_config->mid_list))
						$useSpeedLimiter = true;
					else
						$useSpeedLimiter = false;
				}
			}
			else
			{
				$useSpeedLimiter = false;
			}
		}
		else
		{
			$useSpeedLimiter = true;
		}
		Context::close();
		
		// If XSendFile User
		if($module_config->download_accelerator == "XSendFile") {
			$downlaodspeed = $speedbit / 125 * 1000 * 1024;
			$uploaded_filename = str_replace("./", "", $uploaded_filename);
			$uploaded_filename = _XE_PATH_ . $uploaded_filename;
			header("X-Sendfile: ".$uploaded_filename);
			header("Content-Type: application/octet-stream");
			header("Content-Disposition: attachment; filename=\"".$filename."\"");
			exit;
		}
		
		if($module_config->download_accelerator == "X-Accel") {
			$downlaodspeed = $speedbit / 125 * 1000 * 1024;
			$uploaded_filename = str_replace("./", "", $uploaded_filename);
			$uploaded_filename = _XE_PATH_ . $uploaded_filename;
			header('Cache-Control: public, must-revalidate');
			header('Pragma: no-cache');
			header('Content-Type: application/octet-stream');
			header('Content-Disposition: attachment; filename='.$filename.'');
			header('Content-Transfer-Encoding: binary');
			header('X-Accel-Redirect: '. $uploaded_filename);
			if($useSpeedLimiter == true) {
				header('X-Accel-Limit-Rate: ' . $downlaodspeed);
			}
			exit;
		}
		

		$fp = fopen($uploaded_filename, 'rb');
		if(!$fp) return $this->stop('msg_file_not_found');
		
		header("Cache-Control: ");
		header("Pragma: ");
		header("Content-Type: application/octet-stream");
		header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");

		header("Content-Length: " .(string)($file_size));
		header('Content-Disposition: attachment; filename="'.$filename.'"');
		header("Content-Transfer-Encoding: binary\n");
		
		// Download file with rate control
		while(!feof($fp))
		{
			echo fread($fp, $speedbit * 0.01);
			if($useSpeedLimiter == true) 
				usleep(1);
			
			flush();
		}
		fclose($fp);

		exit();
	}
	
	public function triggerFileDownloadAfter($args)
	{
		$file_srl = $args->file_srl;

		$random = new Password();
		$file_key = $_SESSION['__XE_FILE_KEY__'][$file_srl] = $random->createSecureSalt(32, 'hex');
		header('Location: '.getNotEncodedUrl('', 'act', 'procSpeedlimiterFileOutput','file_srl',$file_srl,'file_key',$file_key));
		Context::close();
		exit();
	}
	
	private function calculate_speed($speed, $unit)
	{
		if($unit == 'Mbps')
			return $speed * (1024 * 0.125);
		else if($unit == 'Kbps')
			return $speed * 0.125;
		else if($unit == 'Gbps') 
			return $speed * (1024 * 1024 * 0.125);
	}
}