<?php
class speedlimiterAdminController extends speedlimiter 
{
	
	public function procSpeedlimiterAdminModuleConfig()
	{
		$oModuleController = getController("module");
		$target_module_srl = Context::get('target_module_srl');
		
		$args = Context::getRequestVars();
		foreach($_POST as $key=>$val)
		{
			if(!$args->{$key}) $args->{$key} = $val;
		}
		unset($args->error_return_url);
		unset($args->mid);
		unset($args->module);
		unset($args->act);
		unset($args->target_module_srl);
		unset($args->vid);
		unset($args->success_return_url);
		
		$oModuleController->insertModulePartConfig("speedlimiter", $target_module_srl, $args);
		
		$returnUrl = Context::get('success_return_url');
		if(!$returnUrl)
		{
			$returnUrl = getNotEncodedUrl('act', 'dispBoardAdminBoardAdditionSetup');
		}
		
		$this->setRedirectUrl($returnUrl);
		$this->setMessage('success_saved');
		
		
	}
	
	public function procSpeedlimiterAdminConfigurationSave()
	{
		$oModuleController = getController("module");
		
		$RequestVars = (object)$_POST;
		// Request Data Calibration
		unset($RequestVars->error_return_url);
		unset($RequestVars->module);
		unset($RequestVars->act);
		unset($RequestVars->mid);
		unset($RequestVars->vid);
		unset($RequestVars->xe_validator_id);
		unset($RequestVars->xe_run_method);
		if(!$RequestVars->mid_list) $RequestVars->mid_list = array();
		
		$args = new stdClass;
		foreach($RequestVars as $key=>$val)
		{
			$args->{$key} = $val;
		}

		// Save Module Configuration
		$oModuleController->updateModuleConfig($this->module, $args);
		
		if(Context::get("error_return_url"))
		{
			$redirect_url = Context::get("error_return_url");
		}
		else
		{
			$redirect_url = getNotEncodedURL("module", $this->module, "act", 'dispSpeedlimiterAdminConfiguration');
		}
		$this->SetRedirectURL($redirect_url);
		
	}
}