<?php
class speedlimiterAdminView extends speedlimiter 
{
	public function Init()
	{
		$template_path = sprintf('%stpl/', $this->module_path);
		$this->setTemplatePath($template_path);
	}

	public function dispSpeedlimiterAdminConfiguration()
	{
		$oModuleModel = getModel("module");
		$oMemberModel = getModel("member");

		Context::loadLang("addon");

		$this->module_info = $oModuleModel->getModuleInfoXml('speedlimiter');
		Context::set("module_info", $this->module_info);
		
		Context::set("UnitArr", array("Mbps", "Gbps"));

		$args = new stdClass();
		if($site_module_info->site_srl)
		{
			$args->site_srl = $site_module_info->site_srl;
		}
		$columnList = array('module_srl', 'module_category_srl', 'mid', 'browser_title');
		$mid_list = $oModuleModel->getMidList($args, $columnList);
		// module_category and module combination
		if(!$site_module_info->site_srl)
		{
			// Get a list of module categories
			$module_categories = $oModuleModel->getModuleCategories();

			if(is_array($mid_list))
			{
				foreach($mid_list as $module_srl => $module)
				{
					$module_categories[$module->module_category_srl]->list[$module_srl] = $module;
				}
			}
		}
		else
		{
			$module_categories = array();
			$module_categories[0] = new stdClass();
			$module_categories[0]->list = $mid_list;
		}
		Context::set('mid_list', $module_categories);

		$MemberGroupList = $oMemberModel->getGroups();

		$GroupConfig = array();
		foreach($MemberGroupList as $srl => $groupInfo)
		{
			$GroupConfig[$srl] = new stdClass;
			$GroupConfig[$srl]->title = $groupInfo->title;
			$GroupConfig[$srl]->name = 'speedlimit_'.$groupInfo->group_srl;
			$GroupConfig[$srl]->value = $this->module_config->{$GroupConfig[$srl]->name};
			$GroupConfig[$srl]->unit_name = 'speedunit_'.$groupInfo->group_srl;
			$GroupConfig[$srl]->unit = $this->module_config->{$GroupConfig[$srl]->unit_name};
		}
		Context::set("GroupConfig", $GroupConfig);
		Context::set("module_config", $this->module_config);
		
		$this->setTemplateFile("speedlimiter_config");
	}
}