<?

class ezmemberAdminController extends ezmember {
	
	function init(){	
		
	}

	/**
	 * @bref procEzmemberAdminStep2Configuration (본인인증 설정 수정 및 저장)
	 */
	function procEzmemberAdminStep2Configuration(){
		// 기본 Model 초기화
		$oModuleModel = getModel("module"); // module model init
		$oMemberModel = getModel("member"); // member model init
		$oModuleController = getController("module"); // module controller init
		$oEzmemberAdminModel = getAdminModel("ezmember");

		$args = Context::getRequestVars();
		$args = $this->checkModuleConfig($args); // 모듈 설정에 필요 없는 변수 삭제
		if($args->individual_auth_type=='none'){
			// 개인 인증 방식을 비활성화할 경우
			$args->user_id='';
			$args->secure='';
			$args->smsvendor='';
		}
		
		// 모듈 설정 저장
		$oModuleController->updateModuleConfig("ezmember", $args);

		$this->setMessage('success_updated', 'info');

		if(Context::get("success_return_url")){
			$this->setRedirectURL(Context::get("success_return_url"));
		}else{
			$this->setRedirectURL(getURL('', 'module', 'admin', 'act', 'dispEzmemberAdminStep2Configuration'));
		}
	}
	
	/**
	 * @bref procEzmemberAdminInsertMemberType (회원 종류 삽입/수정 저장)
	 */
	function procEzmemberAdminInsertMemberType(){
		// 기본 Model 초기화
		$oModuleModel = getModel("module"); // module model init
		$oMemberModel = getModel("member"); // member model init
		$oModuleController = getController("module"); // module controller init
		$oEzmemberAdminModel = getAdminModel("ezmember");

		$type_id = Context::get("type_id");
		$is_update = Context::get("is_update");
		
		// 모듈 설정 가저오기
		$module_config = $this->module_config; // module_config 가저오기
		$mbrtype = unserialize($module_config->member_types); // 기존 회원정보 목록 불러오기
		
		$order = count($mbrtype); // 새로운 회원 종류의 sequence 값 개하기
		
		// 회원 종류 ID 중복 검사
		if( $is_update!='Y' && $oEzmemberAdminModel->getMemberType($type_id) ){ return new Object(-1, 'type_id_already_exists'); }

		$mbrtype->$type_id = new stdClass; // 새로운 Class 초기화
		$mbrtype->$type_id->member_type = Context::get("member_type"); // member_type 변수 넣기
 		$mbrtype->$type_id->member_form_type = Context::get("member_form_type"); // member_form_type 변수 넣기
		$mbrtype->$type_id->description = Context::get("description"); // description 변수 넣기
		$mbrtype->$type_id->group_srl = Context::get("group_srl"); // group_srl 변수 넣기
		$mbrtype->$type_id->sort_order = $order; // 정렬 순서에 맨 마지막 폼 내용 넣기
		
		$args = new stdClass; // 모듈 설정 저장을 위한 $args 객체 생성
		$args->member_types = serialize($mbrtype); // DB에 객체를 저장하기 위하여 'serialize' 처리
		
		$args = $this->checkModuleConfig($args); // 모듈 설정에 필요 없는 변수 삭제
		
		// 모듈 설정 저장
		$oModuleController->updateModuleConfig("ezmember", $args);
		
		// 필요 없는 변수 Unset
		unset($args);
		unset($type_id);
		unset($order);
		unset($module_config);
		
		$this->setMessage('success_updated', 'info');
		
		if(Context::get("success_return_url")){
			$this->setRedirectURL(Context::get("success_return_url"));
		}else{
			$this->setRedirectURL(getURL('', 'module', 'admin', 'act', 'dispEzmemberAdminMembmerTypeConfiguration'));
		}
		
	}

	/**
	 * @bref procEzmemberAdminUpdateMemberType (회원 종류 기본 설정 수정 처리)
	 */
	function procEzmemberAdminUpdateMemberType(){
		$oModuleController = getController("module"); // module controller init
		
		// 모듈 설정 저장
		$RequestVars = (object)$_POST;
		// Request Data Calibration
		unset($RequestVars->error_return_url);
		unset($RequestVars->module);
		unset($RequestVars->act);
		unset($RequestVars->mid);
		unset($RequestVars->vid);
		unset($RequestVars->xe_validator_id);
		unset($RequestVars->xe_run_method);
		
		$args = new stdClass;
		foreach($RequestVars as $key=>$val)
		{
			$args->{$key} = $val;
		}

		$postVars = $this->checkModuleConfig($RequestVars); // 모듈 설정에 필요 없는 변수 삭제
		
		// 모듈 설정 가저오기
		$module_config = $this->module_config; // module_config 가저오기
		$mbrtype = unserialize($module_config->member_types); // 기존 회원정보 목록 불러오기
		
		$new_mbrtype = new stdClass; // 새로운 모듈 설정 저장을 위한 Class 생성

		foreach($postVars->list_order as $val){
			$new_mbrtype->$val = $mbrtype->$val; // 모듈 순서 변경을 위하여 이전 데이터를 그대로 저장
		}
		
		$args->member_types = serialize($new_mbrtype); // DB에 객체를 저장하기 위하여 'serialize' 처리
		$args->use_member_type = Context::get("use_member_type"); // DB에 객체를 저장처리

		$args = $this->checkModuleConfig($args); // 모듈 설정에 필요 없는 변수 삭제

		// 모듈 설정 저장
		$oModuleController->updateModuleConfig("ezmember", $args);

		// 필요 없는 변수 삭제
		unset($args);
		unset($new_mbrtype);
		unset($mbrtype);

		$this->setMessage('success_updated', 'info');

		if(Context::get("success_return_url")){
			$this->setRedirectURL(Context::get("success_return_url"));
		}else{
			$this->setRedirectURL(getURL('', 'module', 'admin', 'act', 'dispEzmemberAdminMembmerTypeConfiguration'));
		}

	}
	
	/**
	 * @bref procEzmemberAdminDeleteMemberType (회원 종류 삭제 처리)
	 */
	function procEzmemberAdminDeleteMemberType(){
		$oModuleController = getController("module"); // module controller init

		$type_id = Context::get("type_id");
		
		// 모듈 설정 가저오기
		$module_config = $this->module_config; // module_config 가저오기
		$mbrtype = unserialize($module_config->member_types); // 기존 회원정보 목록 불러오기

		foreach($mbrtype as $key=>$val){
			if($type_id==$key){
				unset($mbrtype->$key);
			}
		}
		
		$args = new stdClass; // 설정 저장을 위한 $args 객체 생성
		$args->member_types = serialize($mbrtype); // DB에 객체를 저장하기 위하여 'serialize' 처리
		
		$args = $this->checkModuleConfig($args); // 모듈 설정에 필요 없는 변수 삭제

		// 모듈 설정 저장
		$oModuleController->updateModuleConfig("ezmember", $args);

		// 필요 없는 변수 삭제
		unset($args);
		unset($new_mbrtype);
		unset($mbrtype);

	}
	
	/**
	 * @bref procEzmemberAdminConfiguration (확장 모듈 기본 설정 처리)
	 */
	function procEzmemberAdminConfiguration() {
		// Create Object
		$oModuleController = getController("module");
		$oModuleModel = getModel("module");
		
		// Config 전달
		$module_info = $this->module_config;
		
		// 모듈 설정 저장
		$module_config = Context::getRequestVars();
		$module_config->skin_vars = $module_info->skin_vars;

		$module_config = $this->checkModuleConfig($module_config); // 모듈 설정에 필요 없는 변수 삭제

		// 설정 저장
		$oModuleController->updateModuleConfig("ezmember", $module_config);
		
		$this->setMessage('success_updated', 'info');

		if (Context::get('success_return_url')){
			changeValueInUrl('mid', $args->mid, $module_info->mid);
			$this->setRedirectUrl(Context::get('success_return_url'));
		}else{
			$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispEzmemberAdminConfiguration'));
		}
	}

	/**
	 * @procEzmemberAdminAgreementConfig (약관 설정 저장)
	 */
	function procEzmemberAdminAgreementConfig(){
		// Create Object
		$oModuleController = getController("module");
		$oModuleModel = getModel("module");
			
		$field = Context::get("field"); // field 설정 받아 오기
		$use_member_agree = Context::get("use_member_agree"); // 회원모듈 기본 약관 사용 변수값 받아 오기
	
		// 모듈 설정 저장
		$RequestVars = (object)$_POST;
		// Request Data Calibration
		unset($RequestVars->error_return_url);
		unset($RequestVars->module);
		unset($RequestVars->act);
		unset($RequestVars->mid);
		unset($RequestVars->vid);
		unset($RequestVars->xe_validator_id);
		unset($RequestVars->xe_run_method);
		
		$args = new stdClass;
		foreach($RequestVars as $key=>$val)
		{
			$args->{$key} = $val;
		}

		/**
		 * ISSUE 10554
		 * 약관이 DB에 들어갈 경우 오류를 유발 하므로, 파일로 별도 저장한다.
		 **ADDED**
		 **/
		eval('$fcontent = Context::get("'.$field.'");'); // 파일 내용을 fcontent 로 저장한다.
		
		// ezmember 설정 디렉터리가 존재하지 않는 경우 생성
		if(!is_dir(_XE_PATH_."files/ezmember")) @mkdir(_XE_PATH_."files/ezmember");
		$fp = fopen(_XE_PATH_.'files/ezmember/'.$field.'.cml', "w");
		fwrite($fp, $fcontent);
		fclose($fp);

		unset($args->{$field});
		
		// 설정 저장
		$oModuleController->updateModuleConfig("ezmember", $args);

		$this->setMessage('success_updated', 'info');
		
		if (Context::get('success_return_url')){
			changeValueInUrl('mid', $args->mid, $module_info->mid);
			$this->setRedirectUrl(Context::get('success_return_url'));
		}else{
			$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispEzmemberAdminAgreementList'));
		}
	}

	function procEzmemberAdminMailTemplateRemove(){
			
		$file_name = Context::get("file_name"); // field 설정 받아 오기
		if(!$file_name) return $this->stop('msg_invalid_request');

		require_once($this->module_path.'ezmember.config.php');

		foreach($mail_template_list as $key=>$val){

			if($val->file_name==$file_name) $check_ok = 'True';
		}

		if(!$check_ok) return $this->stop("msg_invalid_request");

		@unlink(_XE_PATH_.'files/ezmember/'.$file_name.'.html');
		@unlink(_XE_PATH_.'files/ezmember/'.$file_name.'.html');

		if (Context::get('success_return_url')){
			changeValueInUrl('mid', $args->mid, $module_info->mid);
			$this->setRedirectUrl(Context::get('success_return_url'));
		}else{
			$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispEzmemberAdminMailTemplateList'));
		}
	}

	function procEzmemberAdminMailTemplateEdit(){
		// Create Object
		$oModuleController = getController("module");
		$oModuleModel = getModel("module");
			
		$file_name = Context::get("file_name"); // field 설정 받아 오기
		if(!$file_name) return $this->stop('msg_invalid_request');
		
		/**
		 * ISSUE 10554
		 * 약관이 DB에 들어갈 경우 오류를 유발 하므로, 파일로 별도 저장한다.
		 **ADDED**
		 **/
		eval('$fcontent = Context::get("'.$file_name.'");'); // 파일 내용을 fcontent 로 저장한다.
		$fcontent = htmlspecialchars_decode($fcontent); // HTML 내용 그대로 저장
		
		// EZMember 설정 파일을 불러온다.
		require_once($this->module_path.'ezmember.config.php');

		foreach($mail_template_list as $key=>$val){
			if($val->file_name==$file_name) $check_ok = 'True';
		}

		if(!$check_ok) return $this->stop("msg_invalid_request");

		// ezmember 설정 디렉터리가 존재하지 않는 경우 생성
		if(!is_dir(_XE_PATH_."files/ezmember")) @mkdir(_XE_PATH_."files/ezmember");
		$fp = fopen(_XE_PATH_.'files/ezmember/'.$file_name.'.html', "w");
		fwrite($fp, $fcontent);
		fclose($fp);

		if (Context::get('success_return_url')){
			changeValueInUrl('mid', $args->mid, $module_info->mid);
			$this->setRedirectUrl(Context::get('success_return_url'));
		}else{
			$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispEzmemberAdminMailTemplateList'));
		}
	}

	/**
	 * @procEzmemberAdminPreference (스킬 설정 저장)
	 */
	function procEzmemberAdminPreference(){
		// Get configurations (using module model object)
		$oModuleModel = getModel('module');
		$config = $oModuleModel->getModuleConfig('ezmember');
		
		// 인전 데이터 가저오기
		$module_info = unserialize($this->module_config->skin_vars);
		
		$args = new stdClass;
		$args->skin = $config->skin; // 스킨 설정 변경
		$args->target_module_srl = $config->target_module_srl; // module_srl 지저
		// Get skin information (to check extra_vars)
		$skin_info = $oModuleModel->loadSkinInfo($this->module_path, $config->skin);
		// Check received variables (delete the basic variables such as mo, act, module_srl, page)
		$obj = Context::getRequestVars(); // 모든 변수 받기
		$obj = $this->checkModuleConfig($obj); // 모듈 설정에 필요 없는 변수 삭제

		unset($obj->act);
		unset($obj->module_srl);
		unset($obj->page);

		// Separately handle if the extra_vars is an image type in the original skin_info
		if($skin_info->extra_vars)
		{
			foreach($skin_info->extra_vars as $vars)
			{
				if($vars->type!='image') continue;

				$image_obj = $obj->{$vars->name};
				// Get a variable on a request to delete
				$del_var = $obj->{"del_".$vars->name};
				unset($obj->{"del_".$vars->name});
				if($del_var == 'Y')
				{
					FileHandler::removeFile($module_info->{$vars->name});
					continue;
				}
				// Use the previous data if not uploaded
				if(!$image_obj['tmp_name'])
				{
					$obj->{$vars->name} = $module_info->{$vars->name};
					continue;
				}
				// Ignore if the file is not successfully uploaded, and check uploaded file
				if(!is_uploaded_file($image_obj['tmp_name']) || !checkUploadedFile($image_obj['tmp_name']))
				{
					unset($obj->{$vars->name});
					continue;
				}
				// Ignore if the file is not an image
				if(!preg_match("/\.(jpg|jpeg|gif|png)$/i", $image_obj['name']))
				{
					unset($obj->{$vars->name});
					continue;
				}
				// Upload the file to a path
				$path = sprintf("./files/attach/images/%s/", $module_srl);
				// Create a directory
				if(!FileHandler::makeDir($path)) return false;

				$filename = $path.$image_obj['name'];
				// Move the file
				if(!move_uploaded_file($image_obj['tmp_name'], $filename))
				{
					unset($obj->{$vars->name});
					continue;
				}
				// Change a variable
				unset($obj->{$vars->name});
				$obj->{$vars->name} = $filename;
			}
		}
		// Serialize and save 
		$args->skin_vars = serialize($obj);

		$args = $this->checkModuleConfig($args); // 모듈 설정에 필요 없는 변수 삭제
		
		$oModuleController = getController('module');
		$output = $oModuleController->updateModuleConfig('ezmember', $args);

		$this->setMessage('success_updated', 'info');
		
		if (Context::get('success_return_url')){
			changeValueInUrl('mid', $args->mid, $module_info->mid);
			$this->setRedirectUrl(Context::get('success_return_url'));
		}else{
			$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispEzmemberAdminPreference'));
		}
		
	}
	
	function procEzmemberAdminLicenseAgreement(){
		if(!is_dir("./files/ezmember")){
			@mkdir("./files/ezmember");
		}
		@file_put_contents("./files/ezmember/.license", true);
		if($_SESSION['EZMEMBER_FROM'])
		{
			$redirectURL = getNotEncodedURL("act", $_SESSION['EZMEMBER_FROM']);
		}
		else
		{
			$redirectURL = getNotEncodedURL("act", "dispEzmemberAdminConfiguration");
		}
		$this->setRedirectUrl($redirectURL);
	}

	function checkModuleConfig($args){
		unset($args->success_return_url); // 필요 없는 변수 unset
		unset($args->error_return_url); // 필요 없는 변수 unset
		unset($args->module); // 필요 없는 변수 unset
		unset($args->xe_validator_id); // 필요 없는 변수 unset
		unset($args->act); // 필요 없는 변수 unset

		return $args;
	}
}