<?
require_once(_XE_PATH_."modules/member/member.controller.php");

class ezmemberController extends memberController {
	
	function init(){
		
		// 실행을 위한 레이아웃 및 스킨 Hooking
		$this->module_info->layout_srl = $this->module_config->layout_srl;
		$this->module_info->skin = $this->module_config->skin;
		
	}

	/**
	 * procEzmemberSignUpStep1 (Ezmember Sign Up Form Step 1 Process)
	 **/
	function procEzmemberSignUpStep1(){

		// Load EZMember Configuration
		require_once($this->module_path."/ezmember.config.php");

		// 약관 상태 체크
		foreach($ez_agreement_list as $key=>$val){
			$field_name = 'use_step1_'.$val->file_name;
			if($this->module_config->{$field_name} == 'Enabled')
			{
				if($val->is_required!='N'){
					$is_agreed = Context::get($val->file_name);
					if($is_agreed!='Y') return new Object(-1, $val->name.'내용에 동의하여 주시기 바랍니다.');
				}
			}
		}

		// Agreement Complete
		$_SESSION['ss_ezmember_step1'] = True; // step1 유효 세션 등록
		unset($_SESSION['ss_ezmember_step2']);// 나머지 유효 세션 삭제
		unset($_SESSION['ss_ezmember_step3']);// 나머지 유효 세션 삭제

		// Redirect to Step 2
		$this->setRedirectUrl(getNotEncodedUrl('', 'act', 'dispEzmemberSignUpStep2'));
	}

	/**
	 * procEzmemberSignUpStep2 (Ezmember Sign Up Form Step 2 Process)
	 **/
	function procEzmemberSignUpStep2(){
		$oEzmemberModel = getModel("ezmember");

		$_SESSION['ss_ezmember_step2'] = True; // step2 유효 세션 등록
		unset($_SESSION['ss_ezmember_step3']);// 나머지 유효 세션 삭제
			
		$member_type_config = $oEzmemberModel->getMemberTypeInformation($_SESSION['ez_member_type']); // 회원 종류에 대한 설정 가저오기
		$member_form_type = $member_type_config->member_form_type; // 회원 가입폼 종류 구해오기
		
		if(!$member_form_type) $member_form_type='individual'; // 기본 회원 종류가 정의되지 않은 경우
		// 개인 인증이 있는 경우
		if($member_form_type=='individual'){
			if($this->module_config->individual_auth_type=='none') $_SESSION['ss_auth_ok']='True'; // 사용자 인증을 수행하지 않는 경우 항상 인증완료 처리
			
			// SMS 체크
			if($this->module_config->individual_auth_type=='cp'){
				if($_SESSION['ss_auth_ok']!=True) return new Object(-1, 'sms_auth_not_complete');

				if($_SESSION['user_hp']!=Context::get('user_hp') || $_SESSION['authCode']!=Context::get('authCode')) return new Object(-1, 'sms_auth_failure');
			
				$_SESSION['ss_user_hp'] = Context::get('user_hp'); // 세션에 휴대폰 번호 저장
			}

		}else{
			// 기업 회원일 경우 체크
			if(!Context::get('company_name') || !Context::get('business_no')) return new Object(-1, 'companyinfo_not_provided');
			
			$_SESSION['ss_company_name'] = Context::get('company_name');
			$_SESSION['ss_business_no'] = Context::get('business_no');
			$_SESSION['ss_auth_ok'] = 'True'; // 회사 정보 인증 후 인증완료 처리
			
			// 사업자 등록번호 검증
			if(!$oEzmemberModel->checkBusinessNo(Context::get('business_no'))){
				 return new Object(-1, 'business_license_invalid');
			}

			// 사업자 등록 번호 중복 확인
			$mbr_check = $oEzmemberModel->getMemberInfoViaExtraVars('business_no', Context::get('business_no'));
			if($mbr_check->member_srl){ return new Object(-1, 'business_no_exists'); }

		}

		// 휴대폰 인증과 관련된 SESSION 제거

		// Redirect to Step 3
		$this->setRedirectUrl(getNotEncodedUrl('', 'act', 'dispEzmemberSignUpStep3'));
	}

	/**
	 * @procEzmemberSignUpStep3 (Ezmember Sign Up Form Step 3 Process)
	 **/
	function procEzmemberSignUpStep3(){
		$oEzmemberModel = getModel("ezmember");
		$oMemberController = getController("member");
		
		if($this->module_config->use_captcha=='Y'){
			if($this->module_config->captcha_type=='reCAPTCHA'){
				// reCAPTCHA Validation
				include_once($this->module_path."/captcha/recaptcha/recaptcha.php");

				// validate captcha data
				$resp = recaptcha_check_answer (
						$this->module_config->recaptcha_privkey,
						$_SERVER["REMOTE_ADDR"],
						Context::get("recaptcha_challenge_field"),
						Context::get("recaptcha_response_field")
						);

				if (!$resp->is_valid) {
					// Captcha가 올바르지 않을 경우 되돌려 보낸다.
					return new Object(-1, 'invalid_captcha');
				}
			}

			if($this->module_config->captcha_type=='KCAPTCHA'){
				// KCAPTCHA Validation
				$token = Context::get("kcaptcha_token");

				if(!$token) return new Object(-1, 'invalid_captcha'); // Token 이 존재하지 않을 경우 오류 봔한
				
				if($_SESSION[$token]!=Context::get('kcaptcha_value')) return new Object(-1, 'invalid_captcha'); // Captcha 값이 일치 하지 않는 경우 오류 반환

				// KCaptcha Session 무효화
				// unset($_SESSION[$token]);
			}

			
		}

		$member_type_config = $oEzmemberModel->getMemberTypeInformation($_SESSION['ez_member_type']); // 회원 종류에 대한 설정 가저오기
		$member_form_type = $member_type_config->member_form_type; // 회원 가입폼 종류 구해오기
		
		// 개인 회원폼일 경우
		if($member_form_type=='individual'){
		// 개인 회원일 경우
			if($this->module_config->individual_auth_type=='cp'){
				// 휴대폰 인증인 경우
				// 인증 여부 검사
				if(!$_SESSION['ss_auth_ok']) return new Object(-1, 'invalid_access');
			}
		}

		// 약관의 호환성을 위하여 약관은 무조건 동의로 처리한다.
		Context::set("accept_agreement", "Y"); // 약관 동의 처리
		
		// move to member Controller -> @procMemberInsert
		// (And then, Ezmember trigger move to @triggerMemberInsertMember
		return $oMemberController->procMemberInsert();

	}

	/**
	 * @procEzmemberSignUpComplete (EZMember Sign Up Complete Process (Callback from procMemberInsert after Trigger)
	 */
	function procEzmemberSignUpComplete(){	
		// SMS 인증 및 회원 인증 세션 모두 삭제
		unset($_SESSION['authCode']);// 쓸데 없는 세션 충돌 방지
		unset($_SESSION['user_hp']);// 쓸데 없는 세션 충돌 방지
		unset($_SESSION['ss_auth_ok']); // IPIN 혹은 SMS 인증 완료 상태를 나타내는 세션

		unset($_SESSION['ss_ezmember_step2']); // IPIN 혹은 SMS 인증 완료 상태를 나타내는 세션
		unset($_SESSION['ss_ezmember_step1']); // IPIN 혹은 SMS 인증 완료 상태를 나타내는 세션

		// Move to @dispEzmemberSignUpComplete
		$this->setRedirectUrl(getNotEncodedUrl('', 'act', 'dispEzmemberSignUpComplete'));
	}
	
	function procEzmemberModifyInfoBefore()
	{
		$logged_info = Context::get("logged_info");
		$member_srl = $logged_info->member_srl;
		if($_SESSION['rechecked_password_step'] != 'INPUT_PASSWORD')
		{
			return $this->stop('msg_invalid_request');
		}

		if(!Context::get('is_logged'))
		{
			return $this->stop('msg_not_logged');
		}

		$password = Context::get('password');

		if(!$password)
		{
			return $this->stop('msg_invalid_request');
		}

		$oMemberModel = getModel('member');

		if(!$this->memberInfo->password)
		{
			$columnList = array('member_srl', 'password');
			$memberInfo = $oMemberModel->getMemberInfoByMemberSrl($member_srl, 0, $columnList);
			$this->memberInfo->password = $memberInfo->password;
		}
		
		// Verify the current password
		if(!$oMemberModel->isValidPassword($this->memberInfo->password, $password))
		{
			return new Object(-1, 'invalid_password');
		}

		$_SESSION['rechecked_password_step'] = 'VALIDATE_PASSWORD';

		$redirectUrl = getNotEncodedUrl('', 'mid', Context::get('mid'), 'act', 'dispEzmemberModifyInfo');
		$this->setRedirectUrl($redirectUrl);
	}
	
	/**
	 * procEzmemberModifyInfo (Member Update Information Process)
	 **/
	function procEzmemberModifyInfo()
	{
	
		if(!Context::get('is_logged'))
		{
			return $this->stop('msg_not_logged');
		}

		if($_SESSION['rechecked_password_step'] != 'INPUT_DATA')
		{
			return $this->stop('msg_invalid_request');
		}
		unset($_SESSION['rechecked_password_step']);

		// Extract the necessary information in advance
		$oMemberModel = &getModel ('member');
		$config = $oMemberModel->getMemberConfig ();
		$getVars = array('find_account_answer','allow_mailing','allow_message');
		if($config->signupForm)
		{
			foreach($config->signupForm as $formInfo)
			{
				if($formInfo->isDefaultForm && ($formInfo->isUse || $formInfo->required || $formInfo->mustRequired))
				{
					$getVars[] = $formInfo->name;
				}
			}
		}

		if($this->module_config->use_captcha=='Y'){
			if($this->module_config->captcha_type=='reCAPTCHA'){
				// reCAPTCHA Validation
				include_once($this->module_path."/captcha/recaptcha/recaptcha.php");

				// validate captcha data
				$resp = recaptcha_check_answer (
						$this->module_config->recaptcha_privkey,
						$_SERVER["REMOTE_ADDR"],
						Context::get("recaptcha_challenge_field"),
						Context::get("recaptcha_response_field")
						);

				if (!$resp->is_valid) {
					// Captcha가 올바르지 않을 경우 되돌려 보낸다.
					$_SESSION['rechecked_password_step'] = 'VALIDATE_PASSWORD';
					$this->setMessage('invalid_captcha');
					$this->setMessageType('error');
					return $this->setRedirectUrl(getNotEncodedUrl('', 'mid', Context::get('mid'), 'act', 'dispEzmemberModifyInfo'));
				}
			}

			if($this->module_config->captcha_type=='KCAPTCHA'){
				// KCAPTCHA Validation
				$token = Context::get("kcaptcha_token");

				if(!$token){
					// Captcha가 올바르지 않을 경우 되돌려 보낸다.
					$_SESSION['rechecked_password_step'] = 'VALIDATE_PASSWORD';
					$this->setMessage('invalid_captcha');
					$this->setMessageType('error');
					return $this->setRedirectUrl(getNotEncodedUrl('', 'mid', Context::get('mid'), 'act', 'dispEzmemberModifyInfo'));
				}
				
				if($_SESSION[$token]!=Context::get('kcaptcha_value')){
					// Captcha가 올바르지 않을 경우 되돌려 보낸다.
					$_SESSION['rechecked_password_step'] = 'VALIDATE_PASSWORD';
					$this->setMessage('invalid_captcha');
					$this->setMessageType('error');
					return $this->setRedirectUrl(getNotEncodedUrl('', 'mid', Context::get('mid'), 'act', 'dispEzmemberModifyInfo'));
				}
			}

			
		}

		$args = new stdClass;
		foreach($getVars as $val)
		{
			$args->{$val} = Context::get($val);
			if($val == 'birthday') $args->birthday_ui = Context::get('birthday_ui');
		}
		// Login Information
		$logged_info = Context::get('logged_info');
		$args->member_srl = $logged_info->member_srl;
		$args->birthday = intval(strtr($args->birthday, array('-'=>'', '/'=>'', '.'=>'', ' '=>'')));
		if(!$args->birthday && $args->birthday_ui) $args->birthday = intval(strtr($args->birthday_ui, array('-'=>'', '/'=>'', '.'=>'', ' '=>'')));
		
		// Remove some unnecessary variables from all the vars
		$all_args = Context::getRequestVars();
		unset($all_args->module);
		unset($all_args->act);
		unset($all_args->member_srl);
		unset($all_args->is_admin);
		unset($all_args->description);
		unset($all_args->group_srl_list);
		unset($all_args->body);
		unset($all_args->accept_agreement);
		unset($all_args->signature);
		unset($all_args->_filter);
		unset($all_args->mid);
		unset($all_args->error_return_url);
		unset($all_args->ruleset);
		unset($all_args->password);

		// Add extra vars after excluding necessary information from all the requested arguments
		$extra_vars = delObjectVars($all_args, $args);
		
		$oMemberModel = getModel("member");
		$memberInfo = $oMemberModel->getMemberInfoByMemberSrl($logged_info->member_srl);
		
		// 아이핀 오류 보정
		$extra_vars->ipin_dupinfo = $memberInfo->ipin_dupinfo;
		$extra_vars->virtual_no = $memberInfo->virtual_no;
		
		// 사업자 오류 보정
		$extra_vars->business_no = $memberInfo->business_no;
		
		
		// 확장 변수 설정
		$args->extra_vars = serialize($extra_vars);

		// remove whitespace
		$checkInfos = array('user_id', 'nick_name', 'email_address');
		$replaceStr = array("\r\n", "\r", "\n", " ", "\t", "\xC2\xAD");
		foreach($checkInfos as $val)
		{
			if(isset($args->{$val}))
			{
				$args->{$val} = str_replace($replaceStr, '', $args->{$val});
			}
		}
		
		$oMemberController = getController("member");
		// Execute insert or update depending on the value of member_srl
		$output = $oMemberController->updateMember($args);
		
		if(!$output->toBool()) return $output;

		$profile_image = $_FILES['profile_image'];
		if(is_uploaded_file($profile_image['tmp_name']))
		{
			$oMemberController->insertProfileImage($args->member_srl, $profile_image['tmp_name']);
		}

		$image_mark = $_FILES['image_mark'];
		if(is_uploaded_file($image_mark['tmp_name']))
		{
			$oMemberController->insertImageMark($args->member_srl, $image_mark['tmp_name']);
		}

		$image_name = $_FILES['image_name'];
		if(is_uploaded_file($image_name['tmp_name']))
		{
			$oMemberController->insertImageName($args->member_srl, $image_name['tmp_name']);
		}

		// Save Signature
		$signature = Context::get('signature');
		$oMemberController->putSignature($args->member_srl, $signature);

		// Get user_id information
		$this->memberInfo = $oMemberModel->getMemberInfoByMemberSrl($args->member_srl);

		$oMemberController->_clearMemberCache($args->member_srl);

		// Call a trigger after successfully log-in (after)
		$trigger_output = ModuleHandler::triggerCall('member.procMemberModifyInfo', 'after', $this->memberInfo);
		if(!$trigger_output->toBool()) return $trigger_output;

		$oMemberController->setSessionInfo();
		// Return result
		$this->add('member_srl', $args->member_srl);
		$this->setMessage('success_updated');

		$oMemberController->_clearMemberCache($args->member_srl);

		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'mid', Context::get('mid'), 'act', 'dispEzmemberInfo');
		$this->setRedirectUrl($returnUrl);
		
	}

	/**
	 * @procEzmemberSMSSend (Send SMS Authenticode)
	 **/
	function procEzmemberSMSSend(){
		$oEzmemberModel = getModel("ezmember"); // ezmember model init
		global $lang;
		
		// SESSION으로 'authCode'와 'user_hp'를 설정한다.
		$_SESSION['authCode'] = rand(111111,999999);
		$_SESSION['user_hp'] = Context::get('user_hp');
		
		// POST 요청만 허용
		if($_SERVER['REQUEST_METHOD']!='POST') return $this->Stop('invalid_access Access');

		if(!Context::get('user_hp')) return $this->Stop('invalid_access');

		$sms_content = $lang->sms_auth_content;
		$sms_content = str_replace("%s", $_SESSION['authCode'], $sms_content);
		
		// 휴대폰 번호가 이미 존재하는지 확인
		$mbr_chk = $oEzmemberModel->getMemberInfoViaExtraVars('user_hp', Context::get('user_hp'));
		if($mbr_chk->member_srl){
			echo "<meta charset='utf-8' />";
			echo "<script type='text/javascript'>alert('".$lang->user_hp_exists."');</script>";
			exit();
		}

		/**
		 * SMS Vendor 설정이 카페24인 경우 카페24로 발송하고 smsmania인 경우 SMSMania로 발송
		 **/
		if($this->module_config->smsvendor=='Cafe24') $output = $oEzmemberModel->cafe24SMSSend($sms_content, Context::get('user_hp'));
		else $output = $oEzmemberModel->SMSManiaSMSSend($sms_content, Context::get('user_hp'));
		
		if($output){
			echo "<meta charset='utf-8' />";
			echo "<script type='text/javascript'>alert('".$output."');</script>";
			exit();
		}
		
		echo "<meta charset='utf-8' />";
		echo "<script type='text/javascript'>alert('".$lang->sms_send_seccuess."');</script>";
		exit();
	}

	function procEzmemberSMSValidation(){
		$oEzmemberModel = getModel("ezmember"); // ezmember model init
		
		global $lang;
		
		// POST 요청만 허용
		if($_SERVER['REQUEST_METHOD']!='POST') return $this->Stop('invalid_access Access');

		// 요청이 잘못된 경우 방어
		if(!$_SESSION['authCode'] || !$_SESSION['user_hp']){
			echo "<meta charset='utf-8' />";
			echo "<script type='text/javascript'>alert('".$lang->sms_auth_failure."');</script>";
			exit();
		}
			
		if($_SESSION['user_hp'] != Context::get('user_hp')){
			echo "<meta charset='utf-8' />";
			echo "<script type='text/javascript'>alert('".$lang->sms_auth_failure."');</script>";
			exit();
		}

		if($_SESSION['authCode'] != Context::get('authCode')){
			echo "<meta charset='utf-8' />";
			echo "<script type='text/javascript'>alert('".$lang->sms_auth_failure."');</script>";
			exit();
		}
		
		// 인증번호 확인이 완료된 경우 세션 값 생성!
		$_SESSION['ss_auth_ok']='True';

		echo "<meta charset='utf-8' />";
		echo "<script type='text/javascript'>alert('".$lang->sms_auth_seccuess."');</script>";
		exit();
	}
	
	function procEzmemberIpinValidation(){
		$oEzmemberModel = getModel("ezmember");
		extract($oEzmemberModel->getIpinRuntimeVars());
		
		$sCPRequest = $_SESSION['CPREQUEST'];
		$sEncData = Context::get("enc_data");
		
		if($sEncData){
			
			$sDecData = exec("$sModulePath RES $sSiteCode $sSitePw $sEncData");
			
			if ($sDecData == -9) {
	    		$sRtnMsg = "입력값 오류 : 복호화 처리시, 필요한 파라미터값의 정보를 정확하게 입력해 주시기 바랍니다.";
	    	} else if ($sDecData == -12) {
	    		$sRtnMsg = "NICE신용평가정보에서 발급한 개발정보가 정확한지 확인해 보세요.";
	    	} else {
	    	
	    		$arrData = explode("^", $sDecData);
	    		$iCount = count($arrData);
	    		
	    		if ($iCount >= 5) {
	    						
					$strResultCode	= $arrData[0];			// 결과코드
					if ($strResultCode == 1) {
						$strCPRequest	= $arrData[8];			// CP 요청번호
						
						if ($sCPRequest == $strCPRequest) {
					
							$sRtnMsg = null;
							
							$strVno      		= $arrData[1];	// 가상주민번호 (13자리이며, 숫자 또는 문자 포함)
							$strUserName		= $arrData[2];	// 이름
							$strDupInfo			= $arrData[3];	// 중복가입 확인값 (64Byte 고유값)
							$strAgeInfo			= $arrData[4];	// 연령대 코드 (개발 가이드 참조)
						    $strGender			= $arrData[5];	// 성별 코드 (개발 가이드 참조)
						    $strBirthDate		= $arrData[6];	// 생년월일 (YYYYMMDD)
						    $strNationalInfo	= $arrData[7];	// 내/외국인 정보 (개발 가이드 참조)
						
						} else {
							$sRtnMsg = "CP 요청번호 불일치 : 세션에 넣은 $sCPRequest 데이타를 확인해 주시기 바랍니다.";
						}
					} else {
						$sRtnMsg = "리턴값 확인 후, NICE신용평가정보 개발 담당자에게 문의해 주세요. [$strResultCode]";
					}
	    		
	    		} else {
	    			$sRtnMsg = "리턴값 확인 후, NICE신용평가정보 개발 담당자에게 문의해 주세요.";
	    		}
	    	
	    	}
	    } else {
	    	$sRtnMsg = "처리할 암호화 데이타가 없습니다.";
	    }
	
		if($sRtnMsg){
			return $this->stop($sRtnMsg);
		}else{
			
			$_SESSION['strVno'] = $strVno;
			$_SESSION['strUserName'] = iconv("CP949", "UTF-8", $strUserName);
			$_SESSION['strBirthDate'] = $strBirthDate;
			$_SESSION['strDupInfo'] = $strDupInfo;
			$_SESSION['strGender'] = $strGender;
			
			$mbr = $oEzmemberModel->getMemberInfoViaExtraVars("ipin_dupinfo", $strDupInfo);
			
			echo "<script type='text/javascript'>opener.goto_nextstep(); window.close();</script>";
			
		}
		
		exit;
	}

	function procEzmemberNameCheckValidation()
	{
		$oEzmemberModel = getModel("ezmember");
		extract($oEzmemberModel->getNameCheckRuntimeVars());

		$enc_data = Context::get("EncodeData"); // 암호화된 결과 데이타
		$sReserved1 = Context::get('param_r1');
		$sReserved2 = Context::get("param_r2");
		$sReserved3 = Context::get("param_r3");
			
		if(preg_match('~[^0-9a-zA-Z+/=]~', $enc_data, $match)) {echo "입력 값 확인이 필요합니다 : ".$match[0]; exit;} // 문자열 점검 추가. 
		if(base64_encode(base64_decode($enc_data))!=$enc_data) {echo "입력 값 확인이 필요합니다"; exit;}
		if(preg_match("/[#\&\\+\-%@=\/\\\:;,\.\'\"\^`~\_|\!\/\?\*$#<>()\[\]\{\}]/i", $sReserved1, $match)) {echo "문자열 점검 : ".$match[0]; exit;}
		if(preg_match("/[#\&\\+\-%@=\/\\\:;,\.\'\"\^`~\_|\!\/\?\*$#<>()\[\]\{\}]/i", $sReserved2, $match)) {echo "문자열 점검 : ".$match[0]; exit;}
		if(preg_match("/[#\&\\+\-%@=\/\\\:;,\.\'\"\^`~\_|\!\/\?\*$#<>()\[\]\{\}]/i", $sReserved3, $match)) {echo "문자열 점검 : ".$match[0]; exit;}

		if ($enc_data != "") {

		    $plaindata = exec($sModulePath." DEC ".$sSiteCode.' '.$sSitePw.' '.$enc_data);		// 암호화된 결과 데이터의 복호화
		
		    if ($plaindata == -1){
		        $returnMsg  = "암/복호화 시스템 오류";
		    }else if ($plaindata == -4){
		        $returnMsg  = "복호화 처리 오류";
		    }else if ($plaindata == -5){
		        $returnMsg  = "HASH값 불일치 - 복호화 데이터는 리턴됨";
		    }else if ($plaindata == -6){
		        $returnMsg  = "복호화 데이터 오류";
		    }else if ($plaindata == -9){
		        $returnMsg  = "입력값 오류";
		    }else if ($plaindata == -12){
		        $returnMsg  = "사이트 비밀번호 오류";
		    }else{
		        // 복호화가 정상적일 경우 데이터를 파싱합니다.
		        $ciphertime = `$cb_encode_path CTS $sitecode $sitepasswd $enc_data`;	// 암호화된 결과 데이터 검증 (복호화한 시간획득)
		    
		        $requestnumber = $this->GetValue($plaindata , "REQ_SEQ");
		        $responsenumber = $this->GetValue($plaindata , "RES_SEQ");
		        $authtype = $this->GetValue($plaindata , "AUTH_TYPE");
		        $conninfo = $this->GetValue($plaindata , "CI");
		        $auth_info = new stdClass;
		        $auth_info->name = $this->GetValue($plaindata , "NAME");
		        $auth_info->birthdate = $this->GetValue($plaindata , "BIRTHDATE");
		        $auth_info->gender = $this->GetValue($plaindata , "GENDER");
		        $auth_info->nationalinfo = $this->GetValue($plaindata , "NATIONALINFO");	//내/외국인정보(사용자 매뉴얼 참조)
		        $auth_info->dupinfo = $this->GetValue($plaindata , "DI");
		
		        if(strcmp($_SESSION["REQ_SEQ"], $requestnumber) != 0)
		        {
		            $requestnumber = "";
		            $responsenumber = "";
		            $authtype = "";
		            $auth_info->name = "";
		        	$auth_info->birthdate = "";
		        	$auth_info->gender = "";
		        	$auth_info->nationalinfo = "";
		        	$auth_info->dupinfo = "";
		        	$auth_info->conninfo = "";
		        	return $this->Stop("세션값이 다릅니다. 올바른 경로로 접근하시기 바랍니다.");
		        }
		        
		        // 나이체크
		        $birth_year = substr($auth_info->birthdate, 0, 4);
		        $now_year = date("Y");
		        if($now_year - $birth_uear < 19){
			        echo "<script>alert('성인인증에 실패하였습니다.\\n\\n청소년보호법에 의해 만 19세 이상만 가입하실 수 있습니다.');";
						exit;
		        }
		        
		        // 세션에 인증 값을 저장한다.
				$_SESSION['strUserName'] = iconv("CP949", "UTF-8", $auth_info->name);
				$_SESSION['strBirthDate'] = $auth_info->birthdate;
				$_SESSION['strDupInfo'] = $auth_info->dupinfo;
				$_SESSION['strGender'] = iconv("CP949", "UTF-8", $auth_info->gender);
			
				$mbr = $oEzmemberModel->getMemberInfoViaExtraVars("ipin_dupinfo", $auth_info->dupinfo);
			        
		        $_SESSION['signup_step2'] = 'form';
		        
				echo "<script type='text/javascript'>opener.goto_nextstep(); window.close();</script>";
		        
		    }
		}
		    
		if($returnMsg) return $this->Stop($returnMsg);
		    
		// 쓸데 없는 세션 삭제
		$_SESSION["REQ_SEQ"] = '';

			
		exit;
		    
	}
	
	/* Member module Extends */
	function _sendAuthMail($auth_args, $member_info)
	{
		$oMemberModel = getModel('member');
		$member_config = $oMemberModel->getMemberConfig();
		// Get content of the email to send a member
		Context::set('auth_args', $auth_args);

		$memberInfo = array();

		global $lang;
		if(is_array($member_config->signupForm))
		{
			$exceptForm=array('password', 'find_account_question');
			foreach($member_config->signupForm as $form)
			{
				if(!in_array($form->name, $exceptForm) && $form->isDefaultForm && ($form->required || $form->mustRequired))
				{
					$memberInfo[$lang->{$form->name}] = $member_info->{$form->name};
				}
			}
		}
		else
		{
			$memberInfo[$lang->user_id] = $member_info->user_id;
			$memberInfo[$lang->user_name] = $member_info->user_name;
			$memberInfo[$lang->nick_name] = $member_info->nick_name;
			$memberInfo[$lang->email_address] = $member_info->email_address;
		}
		Context::set('memberInfo', $memberInfo);

		if(!$member_config->skin) $member_config->skin = "default";
		if(!$member_config->colorset) $member_config->colorset = "white";

		Context::set('member_config', $member_config);

		$tpl_path = sprintf('%s/tpl', $this->module_path);

		$auth_url = getFullUrl('','module','member','act','procMemberAuthAccount','member_srl',$member_info->member_srl, 'auth_key',$auth_args->auth_key);
		Context::set('auth_url', $auth_url);

		$oTemplate = &TemplateHandler::getInstance();
		if(is_file(_XE_PATH_.'/files/ezmember/confirm_member_account_mail.html')){
			
			// 1회용 템플릿
			if(!is_dir(_XE_PATH_.'/files/ezmember/temp')) mkdir(_XE_PATH_.'/files/ezmember/temp');
			$instant_tpl = uniqid("ezmember_tpl_").time();
			
			$instant_tpl_content = @file_get_contents(_XE_PATH_.'/files/ezmember/confirm_member_account_mail.html');

			// 정규식으로 loop 문 컴파일
			$instant_tpl_content = str_ireplace("[/loop]", "<!--@end-->", $instant_tpl_content);
			preg_match_all("/\[loop=[\"|'](.*)[\"|']\]/iU", $instant_tpl_content, $compile_arr);
			foreach($compile_arr[0] as $key=>$val){
				$replace_to = $compile_arr[1][$key];
				// $replace_to = str_replace(array('=>',','), array(' as ', '=>'), $replace_to);
				$instant_tpl_content = str_replace($val, "<!--@foreach(".$replace_to.")-->", $instant_tpl_content);
			}

			// 일회용 템플릿 컴파일
			file_put_contents(_XE_PATH_."/files/ezmember/temp/".$instant_tpl.'.html', $instant_tpl_content);
			$content = $oTemplate->compile(_XE_PATH_.'/files/ezmember/temp', $instant_tpl);
			@unlink(_XE_PATH_.'/files/ezmember/temp/'.$instant_tpl.'.html');
			@unlink(_XE_PATH_.'/files/ezmember/temp/'.$instant_tpl.'.html');
			
		}else{
			$instant_tpl = uniqid("ezmember_tpl_").time();
			
			$instant_tpl_content = @file_get_contents($tpl_path.'confirm_member_account_mail.html');

			// 정규식으로 loop 문 컴파일
			$instant_tpl_content = str_ireplace("[/loop]", "<!--@end-->", $instant_tpl_content);
			preg_match_all("/\[loop=[\"|'](.*)[\"|']\]/iU", $instant_tpl_content, $compile_arr);
			foreach($compile_arr[0] as $key=>$val){
				$replace_to = $compile_arr[1][$key];
				// $replace_to = str_replace(array('=>',','), array(' as ', '=>'), $replace_to);
				$instant_tpl_content = str_replace($val, "<!--@foreach(".$replace_to.")-->", $instant_tpl_content);
			}

			// 일회용 템플릿 컴파일
			file_put_contents(_XE_PATH_."/files/ezmember/temp/".$instant_tpl.'.html', $instant_tpl_content);
			$content = $oTemplate->compile(_XE_PATH_.'/files/ezmember/temp', $instant_tpl);
			@unlink(_XE_PATH_.'/files/ezmember/temp/'.$instant_tpl.'.html');
			@unlink(_XE_PATH_.'/files/ezmember/temp/'.$instant_tpl.'.html');
			
		}
		// Send a mail
		$oMail = new Mail();
		$oMail->setTitle( Context::getLang('msg_confirm_account_title') );
		$oMail->setContent($content);
		$oMail->setSender( $member_config->webmaster_name?$member_config->webmaster_name:'webmaster', $member_config->webmaster_email);
		$oMail->setReceiptor( $member_info->user_name, $member_info->email_address );
		$oMail->send();
	}

	function procMemberInsert()
	{
		// Perform MemberInsert process
		parent::procMemberInsert();

		$oMemberController = getController("member");
		$oEzmemberModel = getModel("ezmember");
		
		$member_srl = $this->get("member_srl");
		
		// 회원 종류에 대한 설정 가저오기
		$member_type_config = $oEzmemberModel->getMemberTypeInformation($_SESSION['ez_member_type']);
		
		if($member_type_config->group_srl)
		{
			// Remote All Group from Member
			$args = new stdClass;
			$args->member_srl = $member_srl;
			
			$output = executeQuery('member.deleteMemberGroupMember', $args);
			if(!$output->toBool())
			{
				$oDB->rollback();
				return $output;
			}

			// Add Default Group to member
			$oMemberController->addMemberToGroup($member_srl, $member_type_config->group_srl);
		}

		// Remove Sessions
		unset($_SESSION['ez_member_type']);
	}

	function GetValue($str , $name)
	{
	    $pos1 = 0;  //length의 시작 위치
	    $pos2 = 0;  //:의 위치
	
	    while( $pos1 <= strlen($str) )
		{
	        $pos2 = strpos( $str , ":" , $pos1);
	        $len = substr($str , $pos1 , $pos2 - $pos1);
	        $key = substr($str , $pos2 + 1 , $len);
	        $pos1 = $pos2 + $len + 1;
	        if( $key == $name )
	        {
	            $pos2 = strpos( $str , ":" , $pos1);
	            $len = substr($str , $pos1 , $pos2 - $pos1);
	            $value = substr($str , $pos2 + 1 , $len);
	            return $value;
	        }
	        else
	        {
	            // 다르면 스킵한다.
	            $pos2 = strpos( $str , ":" , $pos1);
	            $len = substr($str , $pos1 , $pos2 - $pos1);
	            $pos1 = $pos2 + $len + 1;
	        }            
	    }
	}

}
?>