<?

class ezmemberModel extends ezmember {
	
	function init(){
		
	}
	
	/**
	 * @getCaptchaFormData (Get Captcha Form Data)
	 * (getCaptchaFormData)
	 **/
	function getCaptchaField(){
		$oModuleModel = getModel("module"); // module model init
		$module_config = $oModuleModel->getModuleConfig('ezmember'); // get 'ezmember' module configuration

		if($module_config->captcha_type=='reCAPTCHA'){
			// Captcha 종류가 reCAPTCHA 인 경우
			include_once($this->module_path."/captcha/recaptcha/recaptcha.php");
			
			if(!$module_config->recaptcha_skin) $skin = 'white';
			else $skin = $module_config->recaptcha_skin;
			$response_html = '<script type="text/javascript">var RecaptchaOptions = { theme : "'.$skin.'" };</script>';
			$response_html .= recaptcha_get_html($module_config->recaptcha_pubkey, $error, true);
			
		}

		if($module_config->captcha_type=='KCAPTCHA'){
			// Captcha 종류가 KCAPTCHA 인 경우
			$token = 'k'.$this->randomString(40);
			while($_SESSION[$token]) $token = 'k'.$this->randomString(40); // 세션이 이미 존재할 경우 재설정
			
			$response_html = "<input type='hidden' name='kcaptcha_token' value='".$token."' />"; // Add Token
			$response_html .= "<img id='kcaptcha_image' src='".getURL('act','getEzmemberCaptchaImage', 'token', $token)."' alt='KCAPTCHA'  onclick=\"this.src='".getURL('act','getEzmemberCaptchaImage', 'token', $token)."&reqtime='+new Date().getTime();\" title='Click to refresh' style='cursor: pointer;' /><br/>"; // Add Captcha Image
			$response_html .= "<input type='text' name='kcaptcha_value' style='width: 190px;' />";
			// $response_html .= "&nbsp;<input type='button' class='btn' value='Refresh' onclick=\"document.getElementById( 'kcaptcha_image').src='".getURL('act','getEzmemberCaptchaImage', 'token', $token)."&reqtime='+new Date().getTime();\" />";
			/**
			 * Will be added soon~
			 **INPROGRESS** $response_html .= '<audio src="#" id="captcha_audio" controls></audio>'; // Add Captcha Audio
			 **/
			
		}

		return $response_html;
	}

	/**
	 * @getEzmemberCaptchaImage (Show captcha image when captcha type is KCAPTCHA)
	 * (getCaptchaFormData)
	 **/
	function getEzmemberCaptchaImage(){
		$oModuleModel = getModel("module"); // module model init
		$module_config = $oModuleModel->getModuleConfig('ezmember'); // get 'ezmember' module configuration
		
		if($module_config->captcha_type=='KCAPTCHA'){
			// Captcha 종류가 KCAPTCHA 인 경우
			include_once($this->module_path."/captcha/kcaptcha/kcaptcha.php");
			$token = Context::get("token"); // token 가저오기
			
			if(!$token) $KCAPTCHA = new KCAPTCHA('null'); // token에 오류가 있을 경우 이미지에 오류 표시

			$KCAPTCHA = new KCAPTCHA; // Captcha 이미지 출력
			
			$_SESSION[$token] = $KCAPTCHA->getKeyString(); // 검증을 위한 변수 설정
		}

		return $response_html;
	}

	/**
	 * @triggerprocMemberInsert (Member Insert Trigger)
	 * (And then, move to @procEzmemberSignUpComplete)
	 **/
	function triggerprocMemberInsert(){
		$oEzmemberController = getController("ezmember"); 
		
		// move to procEzmemberSignUpComplete
		return $oEzmemberController->procEzmemberSignUpComplete();
	}

	/**
	 * @triggerdispMemberSignUpForm (Redirect Member SignUp Form to EZ Member SignUp Form)
	 * (And then, move to @procEzmemberSignUpComplete)
	 **/
	function triggerdispMemberSignUpForm(){
		$oEzmemberView = getView("ezmember"); 
		
		// move to procEzmemberSignUpComplete
		header("Location: ".getNotEncodedUrl('', 'act', 'dispEzmemberSignUpStep1'));

	}
	
	/**
	 * @triggerinsertMember (insert Member Extra Information Trigger)
	 **/
	function triggerinsertMember($args){
		$oEzmemberModel = getModel("ezmember"); // ezmember model init
		$oModuleModel = getModel("module"); // module model init

		$module_config = $oModuleModel->getModuleConfig('ezmember');
		$member_type_config = $oEzmemberModel->getMemberTypeInformation($_SESSION['ez_member_type']); // 회원 종류에 대한 설정 가저오기
		$member_form_type = $member_type_config->member_form_type; // 회원 가입폼 종류 구해오기
		
		$extra_vars = unserialize($args->extra_vars); // unserialize 'extra_vars' data

		$extra_vars->member_type_id=$_SESSION['ez_member_type']; // 회원 종류명 넣기
 
		if($member_form_type=='individual'){
			// 개인 휴대폰 인증을 수행할 경우
			if($module_config->individual_auth_type=='cp'){
				if($_SESSION['ss_user_hp']) $extra_vars->user_hp = $_SESSION['ss_user_hp'];
			}
			
			if($module_config->individual_auth_type=='ipin'){
				// 아이핀에서 불러오는 정보로 Overwrite
				$extra_vars->ipin_dupinfo = $_SESSION['strDupInfo'];
				$extra_vars->virtual_no = $_SESSION['strVno'];
				
				// 회원정보 후킹
				$args->user_name = $_SESSION['strUserName'];
			}
		}else{
			// 회사 인증인 경우
			if($module_config->business_auth_type=='business_no'){
				
				
			}

			if($_SESSION['ss_business_no']) $extra_vars->business_no = $_SESSION['ss_business_no'];

			// Request 변조를 방지하기 위하여 $args->user_name 을 상호명으로 다시 설정
			$args->user_name = $_SESSION['ss_company_name'];

		}

		$args->extra_vars = serialize($extra_vars); // 확장 변수를 다시 serialize 처리
	}
	
	/**
	 * @randomString (Create random string)
	 **/
	function randomString($length){
		$strArr = array('a','b','c','d','e','f','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','1','2','3','4','5','6','7','8','9','0'); // String Array
		
		$str = '';
		for($i=0; $i<=$length; $i++){
			$idx = rand(0,34);
			$str .= $strArr[$idx];
		}

		return $str;
	}

	/**
	 * @getMemberType (get Member Types)
	 **/
	function getMemberType(){
		$oModuleModel = getModel("module");
		$module_config = $oModuleModel->getModuleConfig('ezmember');
		$returnArr = unserialize($module_config->member_types); // 회원 종류 전달
		foreach($returnArr as $key=>$val){
			$returnArr->{$key}->type_id = $key;
			// $returnArr->{$key}->isEnabled = 'Y';
		}

		return $returnArr;
	}

	/**
	 * @getMemberTypeInformation (get Member Type Configuration)
	 **/
	function getMemberTypeInformation($type=''){
		if(!$type) return false;

		$oModuleModel = getModel("module");
		$module_config = $oModuleModel->getModuleConfig('ezmember');
		$returnArr = unserialize($module_config->member_types); // 회원 종류 전달
		$returnArr->type_id = $type; // Type ID 지정
		if($returnArr->$type) return $returnArr->$type;
		else return false;
	}

	/**
	 * @getCafe24remainSMS (get Remains SMS Counts on Cafe24)
	 **/
	function getCafe24remainSMS(){
		$oModuleModel = getModel("module");
		$module_config = $oModuleModel->getModuleConfig('ezmember');

		$sms_url = "http://sslsms.cafe24.com/sms_remain.php"; // 전송요청 URL
		$sms['user_id'] = $module_config->user_id;
		$sms['secure'] = $module_config->secure;
		$sms['mode'] = '1';

		// UTF-8 꺠짐 방지를 위하여 bass64_encode
		foreach($sms as $key=>$val) $sms[$key] = base64_encode($val);

		$host_info = explode("/", $sms_url);
		$host = $host_info[2];
		$path = $host_info[3];
		srand((double)microtime()*1000000);
		$boundary = "---------------------".substr(md5(rand(0,32000)),0,10);

		// 헤더 생성
		$header = "POST /".$path ." HTTP/1.0\r\n";
		$header .= "Host: ".$host."\r\n";
		$header .= "Content-type: multipart/form-data, boundary=".$boundary."\r\n";

		// 본문 생성
		foreach($sms AS $index => $value){
			$data .="--$boundary\r\n";
			$data .= "Content-Disposition: form-data; name=\"".$index."\"\r\n";
			$data .= "\r\n".$value."\r\n";
			$data .="--$boundary\r\n";
		}
		$header .= "Content-length: " . strlen($data) . "\r\n\r\n";

		$fp = fsockopen($host, 80);

		if ($fp) {
			fputs($fp, $header.$data);
			$rsp = '';
			while(!feof($fp)) {
				$rsp .= fgets($fp,8192);
			}
			fclose($fp);
			$msg = explode("\r\n\r\n",trim($rsp));
			$Count = $msg[1]; //잔여건수
			if($Count<0) return '-';
			return $Count;
		}
		else {
			return "-";
		}
	}

	/**
	 * @cafe24SMSSend (Send SMS Message via Cafe24)
	 **/
	function cafe24SMSSend($msg, $recv){
		$oModuleModel = getModel("module");
		$module_config = $oModuleModel->getModuleConfig('ezmember');
		
		// 파라메터 체크
		if(!$msg) return 'msg_not_found';
		if(!$recv) return 'recieve_number_not_found';

		$sms_url = "https://sslsms.cafe24.com/sms_sender.php"; // 전송요청 URL

		$sms['user_id'] = $module_config->user_id;
		$sms['secure'] = $module_config->secure;
		$sms['msg'] = $msg;
		$sms['rphone'] = $recv;
		$sms['sphone1'] = $module_config->sendor_phone1;
		$sms['sphone2'] = $module_config->sendor_phone2;
		$sms['sphone3'] = $module_config->sendor_phone3;
		$sms['mode'] = '1';

		// UTF-8 꺠짐 방지를 위하여 bass64_encode
		foreach($sms as $key=>$val) $sms[$key] = base64_encode($val);

		$host_info = explode("/", $sms_url);
		$host = $host_info[2];
		$path = $host_info[3];

		srand((double)microtime()*1000000);
		$boundary = "---------------------".substr(md5(rand(0,32000)),0,10);
		//print_r($sms);

		// 헤더 생성
		$header = "POST /".$path ." HTTP/1.0\r\n";
		$header .= "Host: ".$host."\r\n";
		$header .= "Content-type: multipart/form-data, boundary=".$boundary."\r\n";

		// 본문 생성
		foreach($sms AS $index => $value){
			$data .="--$boundary\r\n";
			$data .= "Content-Disposition: form-data; name=\"".$index."\"\r\n";
			$data .= "\r\n".$value."\r\n";
			$data .="--$boundary\r\n";
		}
		$header .= "Content-length: " . strlen($data) . "\r\n\r\n";

		$fp = fsockopen($host, 80);

		if ($fp) {
			fputs($fp, $header.$data);
			$rsp = '';
			while(!feof($fp)) {
				$rsp .= fgets($fp,8192);
			}
			fclose($fp);
			$msg = explode("\r\n\r\n",trim($rsp));
			$rMsg = explode(",", $msg[1]);
			$Result= $rMsg[0]; //발송결과
			$Count= $rMsg[1]; //잔여건수
			
			// Cafe24 Error Code Trace
			if($Result=='-100') return 'Error while sending SMS\\n\\nPlease Contact to Administrators.\\n\\nReason : CAFE24 API Server Error';
			if($Result=='-101') return 'Error while sending SMS\\n\\nReason : Parameter Error';
			if($Result=='-102') return 'Error while sending SMS\\n\\nPlease Contact to Administrators.\\n\\nReason : CAFE24 Authentication Failure';
			if($Result=='-105') return 'Error while sending SMS\\n\\nReason : Reserved time Error';
			if($Result=='-201') return 'Error while sending SMS\\n\\nPlease Contact to Administrators.\\n\\nReason : SMS Credit Limit exceed';
			if($Result=='-202') return 'Error while sending SMS\\n\\nReason : string \'됬\' cannot be used';
			if($Result=='0001') return 'Error while sending SMS\\n\\nReason : Invalid Service number';
			if($Result=='0044') return 'Error while sending SMS\\n\\nReason : Sending spam is not allowed';
			if($Result=='3207') return 'Error while sending SMS\\n\\nReason : Cell Phone is not activated';
			if($Result=='3208') return 'Error while sending SMS\\n\\nReason : Cell Phone is turned off';

			//발송결과 알림
			if($Result=="success") return false; // 발송 완료일 경우 'false' 반환
			else return $Result; // 실패일 경우 nResult 반환
		}

	}

	/**
	 * @SMSManiaSMSSend (Send SMS via SMSMania)
	 **/
	function SMSManiaSMSSend($msg='', $dest=''){
		$oModuleModel = getModel("module");
		$module_config = $oModuleModel->getModuleConfig('ezmember');
		
		// 파라메터 체크
		if(!$msg) return false;
		if(!$dest) return false;

		$posts = array();
		$posts['type'] = 'sms';
		$posts['phone'] = $dest;
		$posts['callback'] = $module_config->sendor_phone1.$module_config->sendor_phone2.$module_config->sendor_phone3;
		$posts['msg'] = iconv("UTF-8", "CP949", $msg); // 메시지 내용을 CP949(EUC-KR)로 변환
		$posts['userid'] = $module_config->user_id;

		$host = "sms.smsmania.co.kr";
		$target = "/module/socket_send_multi.php";
		$port = 80;
		$socket  = fsockopen($host, $port);
		if( is_array($posts) ) {
			foreach( $posts AS $name => $value )
			$postValues .= urlencode($name)."=".urlencode( $value )."&";
			$postValues = substr($postValues, 0, -1);
		}

		$postLength = strlen($postValues);
		$request = "POST $target HTTP/1.0\r\n";
		$request .= "Host: $host\r\n";
		$request .= "User-agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)\r\n";
		$request .= "Content-type: application/x-www-form-urlencoded\r\n";
		$request .= "Content-length: ".$postLength."\r\n\r\n";
		$request .= $postValues."\r\n";
		fputs($socket, $request);

		$ret = "";
		while( !feof($socket) ){
			$ret .= trim(fgets($socket,4096));
		}
		fclose( $socket );
		$std_bar = ":header_stop:";

		if(substr($ret,(strpos($ret,$std_bar)+strLen($std_bar)))) return false;
		else return substr($ret,(strpos($ret,$std_bar)+strLen($std_bar)));

	}
	
	/**
	 * @getMemberInfoViaExtraVars (Search Member via Extra Vars)
	 **/
	function getMemberInfoViaExtraVars($key, $b_no){
		$data = new stdClass;
		$data->$key = $b_no;

		$args = new stdClass;
		$args->s_extra_vars = serialize($data); // Serialize Data Field
		$args->s_extra_vars = preg_replace("/O:8:\"stdClass\":[0-9]:{/i", "", $args->s_extra_vars); // Remove Serialized Data Header
		$args->s_extra_vars = preg_replace("/(})+$/", "", $args->s_extra_vars); // Remove Serialized Data Footer
		unset($data); // unset Temporary Object

		$output = executeQuery("ezmember.getMemberInfoviaExtraVars", $args); // Search from Database
		return $output->data; // return Data
	}
	
	/**
	 * @checkBusinessNo
	 * @bref Check SouthKorea Business License Number
	 **/
	function checkBusinessNo($cnum){
		
		 if (!preg_match ('/^\d{10}$/', $cnum)) {
			return false;
		 }

		 $buf = array(10);
		 for ($i = 0; $i < 10; $i++) $buf[$i] = (int) substr ($cnum, $i, 1);

		 $multipliers = array(1,3,7,1,3,7,1,3,5);
		 $sum = 0;

		 for ($i = 0; $i < 9; $i++) $sum += ($sum_buf[$i] = $buf[$i] * $multipliers[$i]);

		 if (10 - (($sum + ((int) (($buf[8] * 5) / 10))) % 10) != $buf[9]) {
			return false;
		 }

		return true;
	}
	
	function getIpinRuntimeVars(){
		$oModuleModel = getModel("module");
		$this->module_config = $oModuleModel->getModuleConfig("ezmember");
		
		// 나이스 아이핀 준비
		$sSiteCode = $this->module_config->ipin_site_id;
		$sSitePw = $this->module_config->ipin_site_pw;
				
		/* IPIN 모듈 위치 산정 (Windows 인 경우와 리눅스인 경우) */
		$sModulePath = _XE_PATH_.$this->module_path."bin/nice/";
		if(preg_match("/Windows/i", $_SERVER['OS'])) $sModulePath .= "IPINClient.exe";
		else $sModulePath .= "IPINClient";
		
		$ret_val = new stdClass;
		$ret_val->sSiteCode = $sSiteCode;
		$ret_val->sSitePw = $sSitePw;
		$ret_val->sModulePath = $sModulePath;
		
		return (array)$ret_val;
	}
	
	function getNameCheckRuntimeVars(){
		$oModuleModel = getModel("module");
		$this->module_config = $oModuleModel->getModuleConfig("ezmember");
		
		// 나이스 아이핀 준비
		$sSiteCode = $this->module_config->namecheck_site_id;
		$sSitePw = $this->module_config->namecheck_site_pw;
				
		/* IPIN 모듈 위치 산정 (Windows 인 경우와 리눅스인 경우) */
		$sModulePath = _XE_PATH_.$this->module_path."bin/nice/";
		if(preg_match("/Windows/i", $_SERVER['OS'])) $sModulePath .= "CPClient.exe";
		else $sModulePath .= "CPClient";
		
		$ret_val = new stdClass;
		$ret_val->sSiteCode = $sSiteCode;
		$ret_val->sSitePw = $sSitePw;
		$ret_val->sModulePath = $sModulePath;
		
		return (array)$ret_val;
	}


}