<?php
/* Copyright (C) ezssl <http://www.migix.jp/> */

/**
 * @class  ezssl
 * @author MIGIX (noc@migix.jp)
 * @brief  ezssl module high class
 **/

class ezmember extends ModuleObject
{

	/**
	 * @brief install the module
	 **/
	function moduleInstall()
	{
		// use action forward(enabled in the admin model)
		//$oModuleController = getController('module');
		//$oModuleModel = getModel('module');

		return new Object();
	}

	/**
	 * @brief check module method
	 **/
	function checkUpdate()
	{
		$oModuleModel = getModel('module');

		// Check procMemberInsert Trigger
		if(!$oModuleModel->getTrigger('member.procMemberInsert', 'ezmember', 'model', 'triggerprocMemberInsert', 'after')) return true;

		// Check insertMember Trigger
		if(!$oModuleModel->getTrigger('member.insertMember', 'ezmember', 'model', 'triggerinsertMember', 'before')) return true;

		// Check dispMemberSignUpForm Trigger
		if(!$oModuleModel->getTrigger('member.dispMemberSignUpForm', 'ezmember', 'model', 'triggerdispMemberSignUpForm', 'before')) return true;
		
		// Check Module Extends
		if(!$oModuleModel->getModuleExtend('member','controller','')) return true;
		
		return false;
	}

	/**
	 * @brief update module
	 **/
	function moduleUpdate()
	{
		$oModuleModel = getModel('module');
		$oModuleController = getController('module');
		$oAdminController = getAdminController('admin');

		// Insert triggerprocMemberInsert Trigger
		if(!$oModuleModel->getTrigger('member.procMemberInsert', 'ezmember', 'model', 'triggerprocMemberInsert', 'after'))
		{
			$oModuleController->insertTrigger('member.procMemberInsert', 'ezmember', 'model', 'triggerprocMemberInsert', 'after');
		}

		// Insert triggerinsertMember Trigger
		if(!$oModuleModel->getTrigger('member.insertMember', 'ezmember', 'model', 'triggerinsertMember', 'before'))
		{
			$oModuleController->insertTrigger('member.insertMember', 'ezmember', 'model', 'triggerinsertMember', 'before');
		}

		// Insert triggerdispMemberSignUpForm Trigger
		if(!$oModuleModel->getTrigger('member.dispMemberSignUpForm', 'ezmember', 'model', 'triggerdispMemberSignUpForm', 'before'))
		{
			$oModuleController->insertTrigger('member.dispMemberSignUpForm', 'ezmember', 'model', 'triggerdispMemberSignUpForm', 'before');
		}
		
		// Insert Module Extends 'member controller'
		if(!$oModuleModel->getModuleExtend('member','controller','')){
            $oModuleController->insertModuleExtend('member','ezmember','controller','');
        }
	
		$oAdminController->procAdminRecompileCacheFile();

		return new Object(0, 'success_updated');
	}

	function moduleUninstall()
	{
		$oModuleModel = getModel('module');
		$oModuleController = getController('module');
		$oAdminController = getAdminController('admin');

		// Delete triggerprocMemberInsert Trigger
		if($oModuleModel->getTrigger('member.procMemberInsert', 'ezmember', 'model', 'triggerprocMemberInsert', 'after'))
		{
			$oModuleController->deleteTrigger('member.procMemberInsert', 'ezmember', 'model', 'triggerprocMemberInsert', 'after');
		}

		// Delete triggerinsertMember Trigger
		if($oModuleModel->getTrigger('member.insertMember', 'ezmember', 'model', 'triggerinsertMember', 'after'))
		{
			$oModuleController->deleteTrigger('member.insertMember', 'ezmember', 'model', 'triggerinsertMember', 'after');
		}

		// Delete triggerdispMemberSignUpForm Trigger
		if($oModuleModel->getTrigger('member.dispMemberSignUpForm', 'ezmember', 'model', 'triggerdispMemberSignUpForm', 'before'))
		{
			$oModuleController->deleteTrigger('member.dispMemberSignUpForm', 'ezmember', 'model', 'triggerdispMemberSignUpForm', 'before');
		}
		
		$oAdminController->procAdminRecompileCacheFile();
		
		return new Object();
	}
}
