<?

class ezmemberAdminView extends ezmember {
	
	function init(){
		// setup template path (board admin panel templates is resided in the tpl folder)
		$template_path = sprintf("%stpl/",$this->module_path);
		$this->setTemplatePath($template_path);
		
	}

	/**
	 * @dispEzmemberAdminConfiguration(EZMember  )
	 */
	function dispEzmemberAdminConfiguration() {
		$oEditorModel = &getModel('editor');
		$oModuleModel = getModel('module');
		$oLayoutModel = getModel('layout');
		
		// Config 
		$module_info = $this->module_config;
		Context::set("module_info", $module_info);

		// Ų  
		$skin_list = $oModuleModel->getSkins($this->module_path);
		Context::set('skin_list',$skin_list);
		
		//  Ų  
		$mskin_list = $oModuleModel->getSkins($this->module_path, "m.skins");
		Context::set('mskin_list', $mskin_list);
		
		// ̾ƿ  
		$layout_list = $oLayoutModel->getLayoutList();
		Context::set('layout_list', $layout_list);
		
		//  ̾ƿ 
		$mobile_layout_list = $oLayoutModel->getLayoutList(0,"M");
		Context::set('mlayout_list', $mobile_layout_list);

		// Captcha  
		$captcha_list = array("reCAPTCHA", 'KCAPTCHA');
		Context::set('captcha_list', $captcha_list);

		$this->setTemplateFile("ezmember_configuration");
	}

	/**
	 * @dispEzmemberAdminPreference (EZMember Ų )
	 */
	function dispEzmemberAdminPreference(){
		$oModuleModel = getModel('module');
		$skin_info = $oModuleModel->loadSkinInfo($this->module_path, $this->module_config->skin);
		$skin_vars = unserialize($this->module_config->skin_vars);

		// value for skin_info extra_vars
		if(count($skin_info->extra_vars))
		{
			foreach($skin_info->extra_vars as $key => $val)
			{
				$name = $val->name;
				$type = $val->type;
				$value = $skin_vars->{$name};
				if($type=="checkbox"&&!$value) $value = array();
				$skin_info->extra_vars[$key]->value= $value;
			}
		}
		Context::set('skin_info', $skin_info);
		Context::set('skin_vars', $skin_vars);
		
		$config = $oModuleModel->getModuleConfig('ezmember');
		Context::set('module_info', unserialize($config->skin_vars));

		$this->setTemplateFile("ezmember_preference");
	}
	
	/**
	 * @dispEzmemberAdminAgreementConfig (EZMember  )
	 */
	function dispEzmemberAdminAgreementConfig(){
		$oEditorModel = &getModel('editor');
		$field = Context::get("field");
		
		//   
		$module_info = $this->module_config;

		// Agree1  ʱȭ
		$option = $this->getEditorOption("no", $field);
		$editor = $oEditorModel->getEditor('', $option);
		
		/**
		 * ISSUE 10554
		 *  DB     ϹǷ, Ϸ  Ѵ.
		 **ADDED**
		 **/
		$field_content = @file_get_contents(_XE_PATH_.'files/ezmember/'.$field.'.cml');
		
		Context::set("module_config", $module_info); //module_config 
		Context::set('editor_skin_list', $oEditorModel->getEditorSkinList());
		Context::set("editor", $editor); // editor1  
		Context::set("field", $field); // $field  
		Context::set("field_content", $field_content);

		$this->setTemplateFile("ezmember_agreement");
	}

	/**
	 * @bref getEditorOption (get Editor Option)
	 **/
	function getEditorOption($args0, $args1){
		$option->primary_key_name = $args0;
		$option->content_key_name = $args1;
		$option->allow_fileupload = false;
		$option->enable_autosave = false;
		$option->enable_default_component = true;
		$option->enable_component = false;
		$option->resizable = true;
		$option->height = 240;
		$option->skin = "xpresseditor";

		return $option;
	}
	
	/**
	 * @bref dispEzmemberAdminMemberTypeConfiguration (Setting Member Types)
	 */
	function dispEzmemberAdminMembmerTypeConfiguration(){
		$oEzmemberModel = getModel('ezmember'); // get ezmember model

		// Config 
		$module_info = $this->module_config;
		Context::set("module_info", $module_info);
		
		$membertype_list = $oEzmemberModel->getMemberType(); // ȸ  

		Context::set("membertype_list", $membertype_list);

		$this->setTemplateFile("ezmember_type_configuration");
	}

	function dispEzmemberAdminStep2Configuration(){
		$oEzmemberModel = getModel('ezmember'); // get ezmember model

		// Config 
		$module_info = $this->module_config;
		Context::set("module_info", $module_info);

		$smsvendor_list = array('Cafe24', 'SMSMania'); // SMS  
		Context::set("smsvendor_list", $smsvendor_list);
	
		// ī24  ܿ SMS  ϱ
		Context::set("cafe24_ramains", $oEzmemberModel->getCafe24remainSMS());

		$this->setTemplateFile("ezmember_step2_configuration");
	}

	/**
	 * display member insert form
	 *
	 * @return void
	 */
	function dispEzmemberAdminInsert()
	{
		global $lang;
		// retrieve extend form
		$oMemberModel = getModel('member');
		$oMemberAdminView = getAdminView('member');
		$oEzmemberModel = getModel('ezmember');
	
		$oMemberAdminView->init();

		$memberInfo = Context::get('member_info');

		if(isset($memberInfo))
		{
			$memberInfo->signature = $oMemberModel->getSignature($this->memberInfo->member_srl);
		}
		Context::set('member_info', $memberInfo);

		// get an editor for the signature
		if($memberInfo->member_srl)
		{
			$oEditorModel = getModel('editor');
			$option = new stdClass();
			$option->primary_key_name = 'member_srl';
			$option->content_key_name = 'signature';
			$option->allow_fileupload = false;
			$option->enable_autosave = false;
			$option->enable_default_component = true;
			$option->enable_component = false;
			$option->resizable = false;
			$option->height = 200;
			$editor = $oEditorModel->getEditor($this->memberInfo->member_srl, $option);
			Context::set('editor', $editor);
		}

		$formTags = $oMemberAdminView->_getMemberInputTag($memberInfo, true);
		// Add Member Type
		$idx = count($formTags);
		$formTags[$idx] = new stdClass;
		$formTags[$idx]->title = $lang->member_type;
		$formTags[$idx]->name = 'member_type_id';
		$formTags[$idx]->type = 'input';
		$formTags[$idx]->inputTag = '';
		$types = $oEzmemberModel->getMemberType();
		foreach($types as $key=>$val){
			$formTags[$idx]->inputTag .= '<label class="x_inline" for=member_'.$val->type_id.'><input type="radio" name="member_type_id" id="member_'.$val->type_id.'" value="'.$val->type_id.'"';
			if($val->type_id==$memberInfo->member_type_id) $formTags[$idx]->inputTag .= ' checked';
			$formTags[$idx]->inputTag .= ' />'.$val->member_type.'</label>&nbsp;&nbsp;';
		}

		// Add Cell Phone Form Tag
		$idx = count($formTags);
		$formTags[$idx] = new stdClass;
		$formTags[$idx]->title = $lang->user_hp;
		$formTags[$idx]->type = 'input';
		$formTags[$idx]->name = 'user_hp';
		$formTags[$idx]->inputTag = "<input type='tel' id='user_hp' name='user_hp' value='".$memberInfo->user_hp."' />";
		
		// Add Business No Form Tag
		$idx = count($formTags);
		$formTags[$idx] = new stdClass;
		$formTags[$idx]->title = $lang->business_no;
		$formTags[$idx]->type = 'input';
		$formTags[$idx]->name = 'business_no';
		$formTags[$idx]->inputTag = "<input type='text' id='business_no' name='business_no' value='".$memberInfo->business_no."' />";

		// Add IPIN Virtual No
		$idx = count($formTags);
		$formTags[$idx] = new stdClass;
		$formTags[$idx]->title = $lang->virtual_no;
		$formTags[$idx]->type = 'input';
		$formTags[$idx]->name = 'virtual_no';
		$formTags[$idx]->inputTag = "<input type='hidden' id='ipin_dupinfo' name='ipin_dupinfo' value='".$memberInfo->ipin_dupinfo."' /><input type='hidden' id='virtual_no' name='virtual_no' value='".$memberInfo->virtual_no."' /><p style='padding: 5px 0;'>".$memberInfo->virtual_no.'</p>';

		Context::set('formTags', $formTags);
		$member_config = $oMemberAdminView->memberConfig;

		global $lang;
		$identifierForm = new stdClass();
		$identifierForm->title = $lang->{$member_config->identifier};
		$identifierForm->name = $member_config->identifier;
		$identifierForm->value = $memberInfo->{$member_config->identifier};
		Context::set('identifierForm', $identifierForm);
		
		// EZMember ʱȭ  ̸ ˸
		$lang->msg_update_member .= " (EZMember Extended)";
		$lang->msg_new_member .= " (EZMember Extended)";

		//   ȣȯ
		$member_module_path = str_replace('ezmember', 'member', $this->module_path);
		$template_path = sprintf("%stpl/", $member_module_path);
		$this->setTemplatePath($template_path);
		$this->setTemplateFile('insert_member');
	}
}