<?

class ezmemberView extends ezmember {
	
	function init(){
		
		// generate module model object
		$oModuleModel = getModel('module');
		$oMemberModel = getModel('member');
		$member_config = $oMemberModel->getMemberConfig(); // 회원 모듈 설정 가저오기
		
		$this->member_config = $oMemberModel->getMemberConfig();
		
		// 실행을 위한 레이아웃 및 스킨 Hooking
		$this->module_info->layout_srl = $this->module_config->layout_srl;
		$this->module_info->skin = $this->module_config->skin;

		$template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
		if(!is_dir($template_path)||!$this->module_info->skin)
		{
			$this->module_info->skin = 'default';
			$template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
		}
		$this->setTemplatePath($template_path);

		// EZMember Addon is required!! If EZMember Addon not enabled, Stop Executing EZMember
		if(!defined("__EZMember_Addon__")) return $this->Stop("ezmember_addon_not_enabled");

		/**
		 * ISSUE 10554
		 * 약관이 DB에 들어갈 경우 오류를 유발 하므로, 파일로 별도 저장한다.
		 **ADDED**
		 **/
		for($i=1; $i<=3; $i++){
			if(is_file(_XE_PATH_.'/files/ezmember/agree'.$i.'.cml')) eval('$this->module_config->agree'.$i.' = @file_get_contents(_XE_PATH_.\'/files/ezmember/agree'.$i.'.cml\');');
		}
		
		// 회원모듈 기본 약관을 사용할 경우, 회원 모듈에 있는 약관 설정을 가저온다.
		if($this->module_config->use_member_agree=='enabled') $this->module_config->agree1 = $member_config->agreement;
		
		$skin_config = ($this->module_config->skin_vars) ? unserialize($this->module_config->skin_vars) : new stdClass;
		Context::set("skin_config", $skin_config); // 스킨 설정 변수를 module_info 변수로 전달
		Context::set("module_config", $this->module_config); //module_config 변수 전달
	}

	/**
	 * @brief dispEzmemberSignUpSplash (Member Register Splash (Select Member Type)
	 */
	function dispEzmemberSignUpSplash(){

		$oEzmemberModel = getModel('ezmember'); // get ezmember model
		
		$mbrTypeList = $oEzmemberModel->getMemberType(); // 회원 종류 전달
		Context::set("mbrTypeList", $mbrTypeList);

		$this->setTemplateFile("signup_splash");
	}
	
	/**
	 * @brief dispEzmemberSignUpStep1 (Member Register Step 1)
	 */
	function dispEzmemberSignUpStep1(){
		// generate module model object
		$oModuleModel = getModel('module');
		$oMemberModel = getModel('member');
		$member_config = $oMemberModel->getMemberConfig();

		unset($_SESSION['ss_ezmember_step1']); // 모든 유효 세션 삭제
		unset($_SESSION['ss_ezmember_step2']); // 모든 유효 세션 삭제
		unset($_SESSION['ss_ezmember_step3']); // 모든 유효 세션 삭제
		
		// 회원 종류를 사용할 경우 회원 종류를 선택하는 페이지로 이동한다.
		if($this->module_config->use_member_type=='enabled'){
			if(Context::get("member_type")){
				$_SESSION['ez_member_type'] = Context::get("member_type");
			}else{
				return $this->dispEzmemberSignUpSplash();
			}
		}

		// call a trigger (before) 
		$trigger_output = ModuleHandler::triggerCall('ezmember.dispEzmemberSignUpStep1', 'before', $member_config);
		if(!$trigger_output->toBool()) return $trigger_output;

		// Get the member information if logged-in
		if($oMemberModel->isLogged()) return $this->stop('msg_already_logged');
		// Error appears if the member is not allowed to join
		if($member_config->enable_join != 'Y') return $this->stop('msg_signup_disabled');

		// call a trigger (after) 
		$trigger_output = ModuleHandler::triggerCall('ezmember.dispEzmemberSignUpStep1', 'after', $member_config);
		if(!$trigger_output->toBool()) return $trigger_output;

		$this->setTemplateFile("signup_step1");

	}

	/**
	 * @brief dispEzmemberSignUpStep2 (Member Register Step 2)
	 */
	function dispEzmemberSignUpStep2(){
		// create member model
		$oModuleModel = getModel('module');
		// create member model
		$oMemberModel = getModel('member');
		// create ezmember model
		$oEzmemberModel = getModel('ezmember');
		// create ezmember controller
		$oEzmemberController = getController('ezmember');

		$member_config = $oMemberModel->getMemberConfig();
		
		// call a trigger (before) 
		$trigger_output = ModuleHandler::triggerCall('ezmember.dispEzmemberSignUpStep2', 'before', $member_config);
		if(!$trigger_output->toBool()) return $trigger_output;
	
		// SMS 인증 및 회원 인증 세션 모두 삭제
		unset($_SESSION['ss_auth_ok']); // IPIN 혹은 SMS 인증 완료 상태를 나타내는 세션
		unset($_SESSION['ss_company_name']); // 회사 이름 검증 세션 삭제
		unset($_SESSION['ss_user_hp']); // 휴대폰 인증 삭제
		unset($_SESSION['ss_ezmember_step2']);// 나머지 유효 세션 삭제
		unset($_SESSION['ss_ezmember_step3']);// 나머지 유효 세션 삭제

		// Get the member information if logged-in
		if($oMemberModel->isLogged()) return $this->stop('msg_already_logged');
		// Error appears if the member is not allowed to join
		if($member_config->enable_join != 'Y') return $this->stop('msg_signup_disabled');

		if(!$_SESSION['ss_ezmember_step1']) return $this->Stop('agreement_failure');
		
		$member_type_config = $oEzmemberModel->getMemberTypeInformation($_SESSION['ez_member_type']); // 회원 종류에 대한 설정 가저오기
		$member_form_type = $member_type_config->member_form_type;

		if(!$member_form_type) $member_form_type='individual'; // 기본 회원 종류가 정의되지 않은 경우

		// 회원 종류 세션 전달
		Context::set("member_type", $_SESSION['ez_member_type']);
		Context::set("member_form_type", $member_form_type);

		if($member_form_type=='individual'){
			if($this->module_config->individual_auth_type=='none'){
				Context::set("prev_step", 'dispEzmemberSignUpStep1');
				$_SESSION['ss_ezmember_step2'] = True; // step2 유효 세션 등록
				return $this->dispEzmemberSignUpStep3(); // 개인이고 아무것도 인증하지 않을 경우 Step3 로 넘긴다.
			}else if($this->module_config->individual_auth_type=='ipin'){
				$oEzmemberModel = getModel("ezmember");
				extract($oEzmemberModel->getIpinRuntimeVars());
				
				// 리턴 URL
				$sReturnURL = getFullURL('act', 'procEzmemberIpinValidation', 'mid', $mid);
			
				$_SESSION['sCPRequest']	= uniqid();	// 하단내용 참조
				$sCPRequest	= $_SESSION['sCPRequest'];
					
				// 실행방법은 싱글쿼터(`) 외에도, 'exec(), system(), shell_exec()' 등등 귀사 정책에 맞게 처리하시기 바랍니다.
				$sCPRequest = exec("$sModulePath SEQ $sSiteCode");
				
				// 현재 예제로 저장한 세션은 ipin_result.php 페이지에서 데이타 위변조 방지를 위해 확인하기 위함입니다.
				// 필수사항은 아니며, 보안을 위한 권고사항입니다.
				$_SESSION['CPREQUEST'] = $sCPRequest;
					
				$sEncData	= "";	// 암호화 된 데이타
				$sRtnMsg	= "";	// 처리결과 메세지
				
				// 리턴 결과값에 따라, 프로세스 진행여부를 파악합니다.
				// 실행방법은 싱글쿼터(`) 외에도, 'exec(), system(), shell_exec()' 등등 귀사 정책에 맞게 처리하시기 바랍니다.
				$sEncData	= exec("$sModulePath REQ $sSiteCode $sSitePw $sCPRequest $sReturnURL");
				
				// 리턴 결과값에 따른 처리사항
				if ($sEncData == -9)
				{
					$sRtnMsg = "입력값 오류 : 암호화 처리시, 필요한 파라미터값의 정보를 정확하게 입력해 주시기 바랍니다.";
				} else {
					$sRtnMsg = null;
				}
					
				if($sEncData == null){
					$sRtnMsg = "암호화 데이터를 생성하는데 실패하였습니다. 관리자에게 문의하여 주시기 바랍니다.";
				}
					
				if($sRtnMsg!=null){
					 return $this->stop($sRtnMsg);
				}
				
				$ipin_script = '<form name="form_ipin" method="post" action="https://cert.vno.co.kr/ipin.cb">
									<input type="hidden" name="m" value="pubmain"><!-- 필수 데이타로, 누락하시면 안됩니다. -->
									<input type="hidden" name="enc_data" value="'.$sEncData.'"><!-- 위에서 업체정보를 암호화 한 데이타입니다. -->
									
									<!-- 업체에서 응답받기 원하는 데이타를 설정하기 위해 사용할 수 있으며, 인증결과 응답시 해당 값을 그대로 송신합니다.
								 해당 파라미터는 추가하실 수 없습니다. -->
									<input type="hidden" name="param_r1" value="'.$sParamR1.'">
									<input type="hidden" name="param_r2" value="">
									<input type="hidden" name="param_r3" value="">
								</form>';
								
				Context::set("extended_script", $ipin_script);
	
			}else if($this->module_config->individual_auth_type=='namecheck'){
				$oEzmemberModel = getModel("ezmember");
				extract($oEzmemberModel->getNameCheckRuntimeVars());
				
				// 리턴 URL
				$sReturnURL = getFullURL('act', 'procEzmemberNameCheckValidation', 'mid', $mid);
				$sErrorURL = getFullURL('act', 'procEzmemberNameCheckValidation', 'mid', $mid);
			
				$authtype = "M";      	// 없으면 기본 선택화면, X: 공인인증서, M: 핸드폰, C: 카드
			    	
				$popgubun 	= "M";		//Y : 취소버튼 있음 / N : 취소버튼 없음
				$customize 	= "";			//없으면 기본 웹페이지 / Mobile : 모바일페이지
			    
			    $reqseq = "";     // 요청 번호, 이는 성공/실패후에 같은 값으로 되돌려주게 되므로
			                                    // 업체에서 적절하게 변경하여 쓰거나, 아래와 같이 생성한다.
			    $reqseq = exec($sModulePath." SEQ ".$sSiteCode);
				
			    // reqseq값은 성공페이지로 갈 경우 검증을 위하여 세션에 담아둔다.
			    
			    $_SESSION["REQ_SEQ"] = $reqseq;
			
			    // 입력될 plain 데이타를 만든다.
			    $plaindata =  "7:REQ_SEQ" . strlen($reqseq) . ":" . $reqseq .
						    			  "8:SITECODE" . strlen($sSiteCode) . ":" . $sSiteCode .
						    			  "9:AUTH_TYPE" . strlen($authtype) . ":". $authtype .
						    			  "7:RTN_URL" . strlen($sReturnURL) . ":" . $sReturnURL .
						    			  "7:ERR_URL" . strlen($sErrorURL) . ":" . $sErrorURL .
						    			  "11:POPUP_GUBUN" . strlen($popgubun) . ":" . $popgubun .
						    			  "9:CUSTOMIZE" . strlen($customize) . ":" . $customize ;
			    
			    $sEncData = exec($sModulePath." ENC ".$sSiteCode.' '.$sSitePw.' '.$plaindata);
			
			    if( $sEncData == -1 )
			    {
			        $sReturnMsg = "암/복호화 시스템 오류입니다.";
			        $sEncData = "";
			    }
			    else if( $sEncData== -2 )
			    {
			        $sReturnMsg = "암호화 처리 오류입니다.";
			        $sEncData = "";
			    }
			    else if( $sEncData== -3 )
			    {
			        $sReturnMsg = "암호화 데이터 오류 입니다.";
			        $sEncData = "";
			    }
			    else if( $sEncData== -9 )
			    {
			        $sReturnMsg = "입력값 오류 입니다.";
			        $sEncData = "";
			    }
			    
			    if($sReturnMsg) return $this->Stop('Nice Return Error : '.$sReturnMsg);
				
				$namecheck_script = '<form name="form_namecheck" method="post" action="https://nice.checkplus.co.kr/CheckPlusSafeModel/checkplus.cb">
									<input type="hidden" name="m" value="checkplusSerivce"><!-- 필수 데이타로, 누락하시면 안됩니다. -->
									<input type="hidden" name="EncodeData" value="'.$sEncData.'"><!-- 위에서 업체정보를 암호화 한 데이타입니다. -->
									
									<!-- 업체에서 응답받기 원하는 데이타를 설정하기 위해 사용할 수 있으며, 인증결과 응답시 해당 값을 그대로 송신합니다.
								 해당 파라미터는 추가하실 수 없습니다. -->
									<input type="hidden" name="param_r1" value="'.$sParamR1.'">
									<input type="hidden" name="param_r2" value="">
									<input type="hidden" name="param_r3" value="">
								</form>';
								
				Context::set("extended_script", $namecheck_script);
	
			}
		}else{
			// 기업 회원일 경우 체크
			
		}

		// call a trigger (after) 
		$trigger_output = ModuleHandler::triggerCall('ezmember.dispEzmemberSignUpStep2', 'after', $member_config);
		if(!$trigger_output->toBool()) return $trigger_output;

		$this->setTemplateFile("signup_step2");

	}

	/**
	 * @brief dispEzmemberSignUpStep3 (Member Register Step 3)
	 */
	function dispEzmemberSignUpStep3(){
		
		if(!$_SESSION['ss_ezmember_step2']) return $this->Stop('msg_invalid_request');

		// generate module model object
		$oModuleModel = getModel('module');
		// generate member model object
		$oMemberModel = getModel('member');
		// generate member view object
		$oMemberView = getView('member');
		$oEzmemberModel = getModel('ezmember');
		
		// 아이핀 무단 접근 방지
		if($this->module_config->individual_auth_type=='ipin' && !$_SESSION['strVno']){
			return $this->stop("msg_invalid_request");
		}
		
		// 본인인증 무단 접근 방지
		if($this->module_config->individual_auth_type=='namecheck' && !$_SESSION['strUserName']){
			return $this->stop("msg_invalid_request");
		}
		
		// 언어 변수 받아오기
		$lang = $GLOBALS['lang'];
		
		// call a trigger (before) 
		$trigger_output = ModuleHandler::triggerCall('ezmember.dispEzmemberSignUpStep3', 'before', $member_config);
		if(!$trigger_output->toBool()) return $trigger_output;
		
		//setcookie for redirect url in case of going to member sign up
		setcookie("XE_REDIRECT_URL", $_SERVER['HTTP_REFERER']);
		
		$member_config = $oMemberModel->getMemberConfig();

		$oMemberModel = getModel('member');
		// Get the member information if logged-in
		if($oMemberModel->isLogged()) return $this->stop('msg_already_logged');
		// Error appears if the member is not allowed to join
		if($member_config->enable_join != 'Y') return $this->stop('msg_signup_disabled');

		$oMemberAdminView = getAdminView('member');
		$formTags = $oMemberAdminView->_getMemberInputTag($member_info);

		$member_type_config = $oEzmemberModel->getMemberTypeInformation($_SESSION['ez_member_type']); // 회원 종류에 대한 설정 가저오기
		$member_form_type = $member_type_config->member_form_type; // 회원 가입폼 종류 구해오기
		
		if(!$member_form_type) $member_form_type='individual'; // 기본 회원 종류가 정의되지 않은 경우

		// 개인 인증이 있는 경우
		if($member_form_type=='individual'){
			if($this->module_config->individual_auth_type=='cp'){
				// 휴대폰 인증인 경우

				// 인증 여부 검사
				if(!$_SESSION['ss_auth_ok']) return new Object(-1, 'invalid_access');
			}

			if($_SESSION['ss_user_hp']){	
				// 휴대폰 인증이 완료된 경우 휴대폰 번호 고정값으로 지정
				$idx = count($formTags);
				$formTags[$idx]->title = $lang->user_hp;
				$formTags[$idx]->name = 'user_hp';
				$formTags[$idx]->type = 'text';
				$formTags[$idx]->inputTag = substr($_SESSION['ss_user_hp'], 0, 3).'-'.substr($_SESSION['ss_user_hp'], 3, 4).'-'.substr($_SESSION['ss_user_hp'] ,7, 4);
			}else{
				// 휴대폰 인증을 수행하지 않을 경우 휴대폰 번호 폼만 출력
				$idx = count($formTags);
				$formTags[$idx]->title = $lang->user_hp;
				$formTags[$idx]->name = 'user_hp';
				$formTags[$idx]->type = 'text';
				$formTags[$idx]->inputTag = "<input type='tel' name='user_hp' id='user_hp' />";
			}
			
			// 아이핀 확장 변수 추가
			if($this->module_config->individual_auth_type=='ipin'){
				
				$idx = count($formTags);
				$formTags[$idx]->title = "가상 주민등록번호";
				$formTags[$idx]->type = 'text';
				$formTags[$idx]->inputTag = substr($_SESSION['strVno'], 0, 6).'-*******';
				
				foreach($formTags as $key=>$val){
					if($val->name=='birthday') $val->inputTag = '<input type="hidden" name="birthday" id="date_birthday" value="'.substr($_SESSION['strBirthDate'], 0, 4).'-'.substr($_SESSION['strBirthDate'], 4, 2).'-'.substr($_SESSION['strBirthDate'], 6, 2).'" />'.substr($_SESSION['strBirthDate'], 0, 4).'-'.substr($_SESSION['strBirthDate'], 4, 2).'-'.substr($_SESSION['strBirthDate'], 6, 2);
					
					if($val->name=='user_name') $val->inputTag = '<input type="hidden" name="user_name" id="user_name" value="'.$_SESSION['strUserName'].'" />'.$_SESSION['strUserName'];
					
					Context::set("prev_step", 'dispEzmemberSignUpStep2');
					
				}				
			}
			
			// 본인인증 확장 변수 추가
			if($this->module_config->individual_auth_type=='namecheck'){
				
				foreach($formTags as $key=>$val){
					if($val->name=='birthday') $val->inputTag = '<input type="hidden" name="birthday" id="date_birthday" value="'.substr($_SESSION['strBirthDate'], 0, 4).'-'.substr($_SESSION['strBirthDate'], 4, 2).'-'.substr($_SESSION['strBirthDate'], 6, 2).'" />'.substr($_SESSION['strBirthDate'], 0, 4).'-'.substr($_SESSION['strBirthDate'], 4, 2).'-'.substr($_SESSION['strBirthDate'], 6, 2);
					
					if($val->name=='user_name') $val->inputTag = '<input type="hidden" name="user_name" id="user_name" value="'.$_SESSION['strUserName'].'" />'.$_SESSION['strUserName'];
					
					Context::set("prev_step", 'dispEzmemberSignUpStep2');
					
				}				
			}
		}else{
			// 기업 회원일 경우
			if($this->module_config->business_auth_type=='business_no'){
				// 인증 여부 검사
				if(!$_SESSION['ss_auth_ok']) return new Object(-1, 'invalid_access');
			}

			// 기업 회원일 경우 상호명은 인증된 상호만 허용
			foreach($formTags as $key=>$val){
				if($val->name=='user_name') $val->inputTag = "<input type='hidden' name='user_name' id='user_name' value='".$_SESSION['ss_company_name']."' />".$_SESSION['ss_company_name'];
			}
			// 사업자등록번호 번호 입력폼 추가
			$idx = count($formTags);
			$formTags[$idx]->title = $lang->business_no;
			$formTags[$idx]->name = 'business_no';
			$formTags[$idx]->type = 'text';
			$formTags[$idx]->inputTag = substr($_SESSION['ss_business_no'], 0, 3).'-'.substr($_SESSION['ss_business_no'], 3, 2).'-'.substr($_SESSION['ss_business_no'], 5, 5);
			
			// 휴대폰 번호 입력폼 추가
			$idx = count($formTags);
			$formTags[$idx]->title = $lang->user_hp;
			$formTags[$idx]->name = 'user_hp';
			$formTags[$idx]->type = 'text';
			$formTags[$idx]->inputTag = "<input type='tel' name='user_hp' id='user_hp' />";
		}
		
		// Captcha가 활성화 되어 있는지 확인
		if($this->module_config->use_captcha=='Y'){
			// Captcha 가 활성화 된 경우 formTags 필드에 Captcha를 추가한다.
			$idx = count($formTags);
			$formTags[$idx]->title = $lang->field_captcha;
			$formTags[$idx]->type = 'text';
			$formTags[$idx]->inputTag = $oEzmemberModel->getCaptchaField();
		}
		
		if(!Context::get("prev_step")) Context::set("prev_step", 'dispEzmemberSignUpStep1');

		Context::set('formTags', $formTags);	

		global $lang;
		$identifierForm = new stdClass();
		$identifierForm->title = $lang->{$member_config->identifier};
		$identifierForm->name = $member_config->identifier;
		$identifierForm->value = $member_info->{$member_config->identifier};
		Context::set('identifierForm', $identifierForm);

		$this->addExtraFormValidatorMessage();
		
		// call a trigger (before) 
		$trigger_output = ModuleHandler::triggerCall('ezmember.dispEzmemberSignUpStep3', 'after', $member_config);
		if(!$trigger_output->toBool()) return $trigger_output;

		$this->setTemplateFile("signup_step3");

	}

	/**
	 * @brief dispEzmemberSignUpComplete (Sign Up Complete Display)
	 **/
	function dispEzmemberSignUpComplete(){
		// generate module model object
		$oModuleModel = getModel('module');
		// generate member model object
		$oMemberModel = getModel('member');
		// generate member view object
		$oMemberView = getView('member');

		$member_config = $oMemberModel->getMemberConfig();

		global $lang;
		$identifierForm = new stdClass();
		$identifierForm->title = $lang->{$member_config->identifier};
		$identifierForm->name = $member_config->identifier;
		Context::set('identifierForm', $identifierForm);
		
		Context::set("logged_info", $oMemberModel->getLoggedInfo());
			
		// SMS 인증 및 회원 인증 세션 모두 삭제
		unset($_SESSION['authCode']);// 쓸데 없는 세션 충돌 방지
		unset($_SESSION['user_hp']);// 쓸데 없는 세션 충돌 방지
		unset($_SESSION['ss_auth_ok']); // IPIN 혹은 SMS 인증 완료 상태를 나타내는 세션

		$this->setTemplateFile("signup_complete");
	}
	
	/**
	 * @brief dispEzmemberLoginForm (로그인 처리시 보여질 스크린)
	 **/
	function dispEzmemberLoginForm(){
		if(Context::get('is_logged'))
		{
			Context::set('redirect_url', getNotEncodedUrl('act',''));
			$this->setTemplatePath($this->module_path.'tpl');
			$this->setTemplateFile('redirect.html');
			return;
		}

		// get member module configuration.
		$oMemberModel = getModel('member');
		$config = $oMemberModel->getMemberConfig();
		Context::set('identifier', $config->identifier);

		// Set a template file
		Context::set('referer_url', htmlspecialchars($_SERVER['HTTP_REFERER'], ENT_COMPAT | ENT_HTML401, 'UTF-8', false));

		$this->setTemplateFile("login_form");
	}

	/**
	 * EZMemberInfo
	 */
	function dispEzmemberInfo(){
		global $lang;
		$oMemberView = getView("member");
		$oMemberModel = getModel('member');
		$logged_info = Context::get('logged_info');
		// Don't display member info to non-logged user
		if(!$logged_info->member_srl) return $this->stop('msg_not_permitted');

		$member_srl = Context::get('member_srl');
		if(!$member_srl && Context::get('is_logged'))
		{
			$member_srl = $logged_info->member_srl;
		}
		elseif(!$member_srl)
		{
			return $this->dispEzmemberSignUpStep1();
		}

		$site_module_info = Context::get('site_module_info');
		$columnList = array('member_srl', 'user_id', 'email_address', 'user_name', 'nick_name', 'homepage', 'blog', 'birthday', 'regdate', 'last_login', 'extra_vars');
		$member_info = $oMemberModel->getMemberInfoByMemberSrl($member_srl, $site_module_info->site_srl, $columnList);
		unset($member_info->password);
		unset($member_info->email_id);
		unset($member_info->email_host);

		if($logged_info->is_admin != 'Y' && ($member_info->member_srl != $logged_info->member_srl))
		{
			$start = strpos($member_info->email_address, '@')+1;
			$replaceStr = str_repeat('*', (strlen($member_info->email_address) - $start));
			$member_info->email_address = substr_replace($member_info->email_address, $replaceStr, $start);
		}

		if(!$member_info->member_srl) return $this->dispMemberSignUpForm();

		Context::set('memberInfo', get_object_vars($member_info));
		
		$extendForm = $oMemberModel->getCombineJoinForm($member_info);
		unset($extendForm->find_member_account);
		unset($extendForm->find_member_answer);
		Context::set('extend_form_list', $extendForm);
		
		// 추가 변수 넣기
		$extendForm['type_id'] = new stdClass;
		$extendForm['type_id']->column_type = 'text';
		$extendForm['type_id']->column_name = 'user_hp';
		$extendForm['type_id']->column_title = 'user_hp';
		$extendForm['type_id']->required = 'Y';
		$extendForm['type_id']->is_active = 1;
		$extendForm['type_id']->value = $member_info->user_hp;
		
		$oMemberView->_getDisplayedMemberInfo($member_info, $extendForm, $this->member_config);

		$this->displayDatas = Context::get("displayDatas");
		
		// 회원 정보 필드 구해오기
		$oEzmemberModel = getModel("ezmember");
		$member_type_config = $oEzmemberModel->getMemberTypeInformation($member_info->member_type_id); // 회원 종류에 대한 설정 가저오기
		$member_form_type = $member_type_config->member_form_type; // 회원 가입폼 종류 구해오기
		
		// 휴대폰 추가
		$idx = count($this->displayDatas);
		$this->displayDatas[$idx] = new stdClass;
		$this->displayDatas[$idx]->isIdentifier = 1;
		$this->displayDatas[$idx]->isDefaultForm = 0;
		$this->displayDatas[$idx]->name = 'user_hp';
		$this->displayDatas[$idx]->title = $lang->user_hp;
		$this->displayDatas[$idx]->required = 1;
		$this->displayDatas[$idx]->isUse = 1;
		$this->displayDatas[$idx]->value = $member_info->user_hp;
		
		// 회원종류 추가
		$idx = count($this->displayDatas);
		$this->displayDatas[$idx] = new stdClass;
		$this->displayDatas[$idx]->isIdentifier = 1;
		$this->displayDatas[$idx]->isDefaultForm = 0;
		$this->displayDatas[$idx]->name = 'member_type';
		$this->displayDatas[$idx]->title = $lang->member_type;
		$this->displayDatas[$idx]->required = 1;
		$this->displayDatas[$idx]->isUse = 1;
		$this->displayDatas[$idx]->value = $member_type_config->member_type;
		
		if($member_form_type!='individual'){
			// 사업자 등록번호 추가
			$idx = count($this->displayDatas);
			$this->displayDatas[$idx] = new stdClass;
			$this->displayDatas[$idx]->isIdentifier = 1;
			$this->displayDatas[$idx]->isDefaultForm = 0;
			$this->displayDatas[$idx]->name = 'business_no';
			$this->displayDatas[$idx]->title = $lang->business_no;
			$this->displayDatas[$idx]->required = 1;
			$this->displayDatas[$idx]->isUse = 1;
			$this->displayDatas[$idx]->value = $member_info->business_no;
		}
		
		
		Context::set("displayDatas", $this->displayDatas); // 폼 데이터 재설정

		$this->setTemplateFile("member_info");
	}

	function dispEzmemberModifyInfoBefore()
	{
		$logged_info = Context::get('logged_info');
		$oMemberModel = getModel('member');
		if(!$oMemberModel->isLogged() || empty($logged_info))
		{
			return $this->stop('msg_not_logged');
		}

		$_SESSION['rechecked_password_step'] = 'INPUT_PASSWORD';

		$templateFile = $this->getTemplatePath().'rechecked_password.html';
		if(!is_readable($templateFile))
		{
			$templatePath = sprintf('%sskins/default', $this->module_path);
			$this->setTemplatePath($templatePath);
		}

		if ($this->member_config->identifier == 'email_address')
		{
			Context::set('identifierTitle', Context::getLang('email_address'));
			Context::set('identifierValue', $logged_info->email_address); 
		}
		else
		{
			Context::set('identifierTitle', Context::getLang('user_id'));
			Context::set('identifierValue', $logged_info->user_id);
		}

		$this->setTemplateFile('rechecked_password');
	}

	/**
	 * @brief Modify member information
	 */
	function dispEzmemberModifyInfo() 
	{
		global $lang;
		if($_SESSION['rechecked_password_step'] != 'VALIDATE_PASSWORD' && $_SESSION['rechecked_password_step'] != 'INPUT_DATA')
		{
			$this->dispEzmemberModifyInfoBefore();
			return;
		}

		$_SESSION['rechecked_password_step'] = 'INPUT_DATA';

		$member_config = $this->member_config;

		$oMemberModel = getModel('member');
		// A message appears if the user is not logged-in
		if(!$oMemberModel->isLogged()) return $this->stop('msg_not_logged');

		$logged_info = Context::get('logged_info');
		$member_srl = $logged_info->member_srl;

		$columnList = array('member_srl', 'user_id', 'user_name', 'nick_name', 'email_address', 'find_account_answer', 'homepage', 'blog', 'birthday', 'allow_mailing');
		$member_info = $oMemberModel->getMemberInfoByMemberSrl($member_srl, 0, $columnList);
		$member_info->signature = $oMemberModel->getSignature($member_srl);
		Context::set('member_info',$member_info);

		// Get a list of extend join form
		Context::set('extend_form_list', $oMemberModel->getCombineJoinForm($member_info));

		// Editor of the module set for signing by calling getEditor
		if($member_info->member_srl)
		{
			$oEditorModel = getModel('editor');
			$option = new stdClass();
			$option->primary_key_name = 'member_srl';
			$option->content_key_name = 'signature';
			$option->allow_fileupload = false;
			$option->enable_autosave = false;
			$option->enable_default_component = true;
			$option->enable_component = false;
			$option->resizable = false;
			$option->disable_html = true;
			$option->height = 200;
			$option->skin = $member_config->signature_editor_skin;
			$option->colorset = $member_config->sel_editor_colorset;
			$editor = $oEditorModel->getEditor($member_info->member_srl, $option);
			Context::set('editor', $editor);
		}

		$this->member_info = $member_info;

		$oEzmemberModel = getModel("ezmember");
		$oMemberAdminView = getAdminView('member');
		$formTags = $oMemberAdminView->_getMemberInputTag($member_info);
		
		$member_type_config = $oEzmemberModel->getMemberTypeInformation($member_info->member_type_id); // 회원 종류에 대한 설정 가저오기
		$member_form_type = $member_type_config->member_form_type; // 회원 가입폼 종류 구해오기
		// 개인 인증이 있는 경우
		if($member_form_type=='individual'){

			if($this->module_config->individual_auth_type=='cp'){
				// 휴대폰 인증이 완료된 경우 휴대폰 번호 고정값으로 지정
				$idx = count($formTags);
				$formTags[$idx]->title = $lang->user_hp;
				$formTags[$idx]->name = 'user_hp';
				$formTags[$idx]->type = 'text';
				$formTags[$idx]->inputTag = "<input type='hidden' name='user_hp' id='user_hp' value='".$member_info->user_hp."' />".substr($member_info->user_hp, 0, 3).'-'.substr($member_info->user_hp, 3, 4).'-'.substr($member_info->user_hp ,7, 4);
			}else{
				// 휴대폰 인증을 수행하지 않을 경우 휴대폰 번호 폼만 출력
				$idx = count($formTags);
				$formTags[$idx]->title = $lang->user_hp;
				$formTags[$idx]->name = 'user_hp';
				$formTags[$idx]->type = 'text';
				$formTags[$idx]->inputTag = "<input type='tel' name='user_hp' id='user_hp' />";
			}
		}else{
			// 기업 회원일 경우
			if($this->module_config->business_auth_type=='business_no'){
				
			}

			// 기업 회원일 경우 상호명은 인증된 상호만 허용
			foreach($formTags as $key=>$val){
				if($val->name=='user_name') $val->inputTag = "<input type='hidden' name='user_name' id='user_name' value='".$member_info->user_name."' />".$member_info->user_name;
			}
			// 사업자등록번호 번호 입력폼 추가
			$idx = count($formTags);
			$formTags[$idx]->title = $lang->business_no;
			$formTags[$idx]->name = 'business_no';
			$formTags[$idx]->type = 'text';
			$formTags[$idx]->inputTag = "<input type='hidden' name='business_no' id='business_no' value='".$member_info->business_no."' />".substr($member_info->business_no, 0, 3).'-'.substr($member_info->business_no, 3, 2).'-'.substr($member_info->business_no, 5, 5);
			
			// 휴대폰 번호 입력폼 추가
			$idx = count($formTags);
			$formTags[$idx]->title = $lang->user_hp;
			$formTags[$idx]->name = 'user_hp';
			$formTags[$idx]->type = 'text';
			$formTags[$idx]->inputTag = "<input type='tel' name='user_hp' id='user_hp' value='".$member_info->user_hp."' />";
		}
		
		// 회원 종류 필드 추가
		$idx = count($formTags);
		$formTags[$idx]->title = $lang->member_type;
		$formTags[$idx]->name = 'member_type_id';
		$formTags[$idx]->type = 'text';
		$formTags[$idx]->inputTag = "<input type='hidden' name='member_type_id' id='member_type_id' value='".$member_info->member_type_id."' />".$member_type_config->member_type;
		
		// Captcha가 활성화 되어 있는지 확인
		if($this->module_config->use_captcha=='Y'){
			// Captcha 가 활성화 된 경우 formTags 필드에 Captcha를 추가한다.
			$idx = count($formTags);
			$formTags[$idx]->title = $lang->field_captcha;
			$formTags[$idx]->type = 'text';
			$formTags[$idx]->inputTag = $oEzmemberModel->getCaptchaField();
		}

		Context::set('formTags', $formTags);

		global $lang;
		$identifierForm = new stdClass();
		$identifierForm->title = $lang->{$member_config->identifier};
		$identifierForm->name = $member_config->identifier;
		$identifierForm->value = $member_info->{$member_config->identifier};
		Context::set('identifierForm', $identifierForm);

		$this->addExtraFormValidatorMessage();

		// Set a template file
		$this->setTemplateFile('modify_info');
	}
	
	/**
	 * dispEzmemberModifyPassword (Modify Member Password)
	 **/
	function dispEzmemberModifyPassword()
	{
		$oMemberModel = getModel('member');
		// A message appears if the user is not logged-in
		if(!$oMemberModel->isLogged()) return $this->stop('msg_not_logged');

		$memberConfig = $this->member_config;

		$logged_info = Context::get('logged_info');
		$member_srl = $logged_info->member_srl;

		$columnList = array('member_srl', 'user_id');
		$member_info = $oMemberModel->getMemberInfoByMemberSrl($member_srl, 0, $columnList);
		Context::set('member_info',$member_info);

		if($memberConfig->identifier == 'user_id')
		{
			Context::set('identifier', 'user_id');
			Context::set('formValue', $member_info->user_id);
		}
		else
		{
			Context::set('identifier', 'email_address');
			Context::set('formValue', $member_info->email_address);
		}
		// Set a template file
		$this->setTemplateFile('modify_password');
	}
	
	/**
	 * dispEzmemberLeave (Member Leave View)
	 **/
	function dispEzmemberLeave(){
		
		$oMemberModel = getModel('member');
		// A message appears if the user is not logged-in
		if(!$oMemberModel->isLogged()) return $this->stop('msg_not_logged');

		$memberConfig = $this->member_config;

		$logged_info = Context::get('logged_info');
		$member_srl = $logged_info->member_srl;

		$member_info = $oMemberModel->getMemberInfoByMemberSrl($member_srl);
		Context::set('member_info',$member_info);

		if($memberConfig->identifier == 'user_id')
		{
			Context::set('identifier', 'user_id');
			Context::set('formValue', $member_info->user_id);
		}
		else
		{
			Context::set('identifier', 'email_address');
			Context::set('formValue', $member_info->email_address);
		}
		// Set a template file
		$this->setTemplateFile('leave_form');
		
	}

	/**
	 * Add javascript codes into the header by checking values of member join form, required and others
	 * @return void
	 */
	function addExtraFormValidatorMessage()
	{
		$oMemberModel = getModel('member');
		$extraList = $oMemberModel->getUsedJoinFormList();

		$js_code = array();
		$js_code[] = '<script>//<![CDATA[';
		$js_code[] = '(function($){';
		$js_code[] = 'var validator = xe.getApp("validator")[0];';
		$js_code[] = 'if(!validator) return false;';

		$errorLang = array();
		foreach($extraList as $val) 
		{
			$title = str_ireplace(array('<script', '</script'), array('<scr"+"ipt', '</scr"+"ipt'), addslashes($val->column_title));
			if($val->column_type == 'kr_zip' || $val->column_type == 'tel')
			{
				$js_code[] = sprintf('validator.cast("ADD_MESSAGE", ["%s[]","%s"]);', $val->column_name, $title);
			}
			else
			{
				$js_code[] = sprintf('validator.cast("ADD_MESSAGE", ["%s","%s"]);', $val->column_name, $title);
			}
			$errorLang[$val->column_name] = $val->column_title;
		}
		$_SESSION['XE_VALIDATOR_ERROR_LANG'] = $errorLang;

		$js_code[] = '})(jQuery);';
		$js_code[] = '//]]></script>';
		$js_code   = implode("\n", $js_code);

		Context::addHtmlHeader($js_code);
	}
}
?>