(function ($){
    $(document).ready(function () {
        var padoSlide = padoSlide || {};
        padoSlide.init = function () {
            var animationFn = this.animation();

            var padoSlideBanner = $(".ding-padoSlideBanner .image-container"); // 이미지 컨테이너를 가르킵니다.
            var padoSlideTimer = $(""); // 파도 슬라이드 타이머.

            this.setAlignRight(padoSlideBanner); // 정렬 작업입니다.

            //애니메이션 모듈에 어떤것이 슬라이드인지 노드를 넘겨줍니다.
            animationFn.setOpction(padoSlideBanner);

            //컨트롤러를 설정합니다.
            animationFn.setArrowButton(".img-container-next", 0);
            animationFn.setArrowButton(".img-container-prev", 1);

            //애니메이션 모듈을 시작합니다.
            animationFn.run();
            this.setTimer(padoSlideTimer);
        };

        padoSlide.setTimer = function (n) { };

        /**
         * Slide left align.
         * @type {Function}
         */
        padoSlide.setAlignRight = function (n) {
            for (var i = 0; i < $(n).children().length; i++) {
                $(n.children()[i]).css("left", i * 100 + "%");
            }
        };

        /**
         * Slide Animation.
         * @type {Function}
         */
        padoSlide.animation = function () {
            var scope = this;

            this.slideLength = 0;
            this.slideCounter = 0;
            this.Node = 0;


            /**
             * Default slide setting.
             * @param n
             */
            function setOpction(n) {
                scope.Node = n;
                scope.slideLength = $(scope.Node).children().length;
                hideArrowButton(["img-container-next","img-container-prev"]);
            }


            /**
             * next, prev button hide.
             * @param n
             */
            function hideArrowButton(n){
                if (scope.slideLength <= 0) {
                    while(i < 1){
                        $(n[i]).css("display", "none");
                        i++;
                    }
                }
            }


            /**
             *
             * @param n     // button node.
             * @param p     // 0:left, 1:right.
             */
            function setArrowButton(n, p) {
                var node = $(n);
                k(node);
                function k(n) {
                    $(n).on("click", function () {
                        if (p === 0 && scope.slideCounter > 0) { //left
                            scope.slideCounter -= 1;
                            o();
                        } else if (p === 0 && scope.slideCounter === 0) {
                            scope.slideCounter = scope.slideLength - 1;
                            o();
                        } else if(p === 1 && scope.slideCounter < scope.slideLength - 1) {
                            scope.slideCounter += 1;
                            o();
                        } else if(p === 1 && scope.slideCounter === scope.slideLength - 1){
                            scope.slideCounter = 0;
                            o();
                        } else if(p === 1 &&  scope.slideCounter > scope.slideLength - 1){
                            scope.slideCounter = 0;
                            o();
                        }
                    });
                }
                function o(){
                    $(scope.Node).animate({
                        left: -1 * ((scope.slideCounter) * 100) + "%"
                    }, 1000, "easeOutExpo");
                }
            }

            /**
             * Banner animation start.
             */
            function startAnimation() {
                if (scope.slideCounter <= scope.slideLength - 1) {
                    $(scope.Node).animate({
                        left: -1 * (scope.slideCounter * 100) + "%"
                    }, 1000, "easeOutExpo", function () {
                        if (scope.slideCounter >= scope.slideLength - 1 || scope.slideCounter < -1 || scope.slideCounter > scope.slideLength ) {
                            setTimeout(function () {
                                scope.slideCounter = 0;
                                startAnimation();
                            }, 5000);
                        } else {
                            setTimeout(function () {
                                scope.slideCounter += 1;
                                startAnimation();
                            }, 5000);
                        }
                    });
                }else if(scope.slideCounter > scope.slideLength - 1) {
                    scope.slideCounter = 0;
                    startAnimation();
                }
            }
            return {
                setArrowButton: (function (n, p) {
                    setArrowButton(n, p);
                }),
                setOpction: (function (n) {
                    setOpction(n);
                }),
                run: function () {
                    startAnimation();
                }
            };
        };
        padoSlide.init();
    });
})(jQuery.noConflict());