var ding = ding || {};
ding.UI = ding.UI || {};

(function ($){
    $(function () {
        ding.UI._loginForm = function () {
            var self = this;
            self.loginFormNode = null;

            function runAnimation(type) {
                type >= 1 ? $(".input-background").css("display", "block") : $(".input-background").css("display", "none");
                self.loginFormNode.animate({
                    top: 40 * type,
                    opacity: 1 * type
                }, type >= 1 ? 500 : 0, "easeInOutBack");
            }

            function setEventListener(node, bgNode) {
                $(node).click(function (){
                    runAnimation(1);
                });

                $(bgNode).click(function (e){
                    if(e.target == this) {
                        runAnimation(0);
                    }
                });
            }

            return {
                setLoginForm: function (node) {
                    self.loginFormNode = $(node);
                    return this;
                },
                setEventListener: function (node, bgNode) {
                    setEventListener(node, bgNode);
                    return this;
                }
            };
        };

        ding.UI._idRemember = function (){

            function createDate (n) {
                var date = new Date();
                return new Date (date.getTime() + 24 * n * 60 * 60 * 1e3);
            }

            // 쿠키를 사용하는지 체크하고 UI 반영.
            function useCookie (){
                $(".user-id").val(cookies.get('email-remember'));
                if(cookies.get('email-remember')) {
                    $(".remember_wrap input[name*='remember-email']")[0].checked = true;
                }
            }

            // 이벤트 리스너 설정.
            function setEventListener(node){
                // 이메일 노드.
                var valueChecked = $(node+' input[name="remember-email"]');


                // 체크박스 클릭 시.
                valueChecked.click(function (){
                    if(valueChecked[0].checked == true){
                        cookies.set('email-remember', $(".user-id").val(), { expires: createDate(1) });
                    } else {
                        cookies.del('email-remember');
                    }
                });

                // Input Method 값이 바뀔 때.
                $(".user-id").change(function(){
                    if(valueChecked[0].checked == true) {
                        cookies.set('email-remember', $(".user-id").val(), { expires: createDate(1) });
                    } else {
                        cookies.del('email-remember');
                    }
                });
            }
            return{
                setEventListener: function(node) { setEventListener(node) },
                useCookie: function() { useCookie(); return this; }
            }
        }

        //로그인 폼.
        ding.UI._loginForm().setLoginForm(".input-warpper").setEventListener(".layout-navMenu-user .login", ".input-background");

        //이메일 기억하기.
        ding.UI._idRemember().useCookie().setEventListener(".remember_wrap");
    });
}(jQuery.noConflict()));
