<?php

class voteModel extends vote
{
	var $config;

	function getConfig()
	{
		if(!$this->config)
		{
			$oModuleModel = &getModel('module');
			$config = $oModuleModel->getModuleConfig('vote');

			// 출력모듈 미선택시 모든 모듈 출력
			if(!$config->use_module_srls) $config->use_all = 'Y';

			// 공지글 추천X 일 경우 메시지
			if(!$config->msg_noticeVote) $config->msg_noticeVote = '공지글에는 추천/비추천 하실 수 없습니다.';

			// 확인창 세팅
			if(!$config->msg_confirm_v) $config->msg_confirm_v = '추천하시겠습니까?';
			if(!$config->msg_confirm_b) $config->msg_confirm_b = '비추천하시겠습니까?';

			// 레벨특권, 조건들이 비어있을 경우 미사용으로 전환
			if(!$config->level_over || !$config->level_count) $config->use_level = 'N';

			// 스킨세팅
			if(!$config->skin) $config->skin = 'default';

			// 게시물이동 메시지 기본세팅
			if(!$config->msg_mvV) $config->msg_mvV = '베스트게시판으로 이동되었습니다.';
			if(!$config->msg_mvB) $config->msg_mvB = '관리게시판으로 이동되었습니다.';

			// 게시물이동시 댓글남기기 세팅
			if(!$config->use_mvV_cmt) $config->use_mvV_cmt = 'N';
			if(!$config->mvV_cmt_memberSrl) $config->mvV_cmt_memberSrl = '4';
			if(!$config->mvV_cmt_memberNick) $config->mvV_cmt_memberNick = '운영진';
			if(!$config->msg_mvV_cmt) $config->msg_mvV_cmt = '베스트게시판으로 이동되었습니다.';

			if(!$config->use_mvB_cmt) $config->use_mvB_cmt = 'N';
			if(!$config->mvB_cmt_memberSrl) $config->mvB_cmt_memberSrl = '4';
			if(!$config->mvB_cmt_memberNick) $config->mvB_cmt_memberNick = '운영진';
			if(!$config->msg_mvB_cmt) $config->msg_mvB_cmt = '관리게시판으로 이동되었습니다.';

			//권한설정
			if(!$config->grant_group) $config->use_guestVote = 'Y';
			else $config->use_guestVote = 'N';

			if(!$config->msg_grant) $config->msg_grant = '권한이 없습니다.';

			// 비추천노출 설정 Ver1.1.1 추가
			if(!$config->use_blameBtn) $config->use_blameBtn = 'Y';

			// 추천실패 메시지 설정
			if(!$config->msg_failedVoted) $config->msg_failedVoted = 'failed_voted';
			if(!$config->msg_failedBlamed) $config->msg_failedBlamed = 'failed_blamed';

			// 노출위치 기본값 세팅 Ver1.1.3
			if(!$config->use_position) $config->use_position = 'BOTTOM';

			$this->config = $config;
		}

		return $this->config;
	}

/*
* 레벨구하기 모델
*/
	function getLevel()
	{
		$config = $oModuleModel->getModuleConfig('point'); 
		$logged_info = Context::get('logged_info');
		$oPointModel = &getModel('point'); 
		$point = $oPointModel->getPoint($logged_info->member_srl);
		$level = $oPointModel->getLevel($point, $config->level_step);

		return $level;
	}

/*
* 권한체크
*/
	function getPermission()
	{
		$oVoteModel = &getModel('vote');
		$config = $oVoteModel->getConfig();
		$logged_info = Context::get('logged_info');

		// Ver 1.1.3 코드수정
		if($config->grant_group && $logged_info->is_admin != 'Y')
		{
			if(!Context::get('is_logged')) return false;
			// 추천권한 설정
			$oMemberModel = &getModel('member');
			
			$member_srl = $logged_info->member_srl;
			$member_info = $oMemberModel->getMemberInfoByMemberSrl($member_srl);
			foreach($member_info->group_list as $k => $v)
			{
				if(in_array($k,$config->grant_group) && $logged_info->is_admin != 'Y' ) return true;
			}
		}
		else return true;
	}

}