<?php

class voteAdminView extends vote
{
	function init()
	{
		$oModuleModel = getModel('module');
		$oMemberModel = getModel('member');

		$logged_info = $oMemberModel->getLoggedInfo();
		$config = $oModuleModel->getModuleConfig('vote');

		Context::set('config', $config);

		$security = new Security();
		$security->encodeHTML('module_info..');

		$this->setTemplatePath($this->module_path.'tpl');
	}

/*
* 기본세팅
*/
	function dispVoteAdminConfig()
	{
		$oModuleModel = getModel('module');
		$columnList = array('module_srl', 'mid', 'browser_title');
		// 게시판 board 모듈만 출력
		$args = new stdClass();
		$args->module = 'board';
		$mid_list = $oModuleModel->getMidList($args, $columnList);
		Context::set('mid_list', $mid_list);

		$security = new Security();
		$security->encodeHTML('mid_list..browser_title','mid_list..mid');

		// 스킨 목록 구함
		$skin_list = $oModuleModel->getSkins($this->module_path);
		Context::set('skin_list',$skin_list);

		$mskin_list = $oModuleModel->getSkins($this->module_path, "m.skins");
		Context::set('mskin_list', $mskin_list);

		// Set the template
		$this->setTemplateFile('config');
	}
/*
* 게시물 이동기능 설정
*/
	function dispVoteAdminConfigMove()
	{
		// Get a list of mid
		$oModuleModel = getModel('module');
		$columnList = array('module_srl', 'mid', 'browser_title');
		// 게시판 board 모듈만 출력
		$args = new stdClass();
		$args->module = 'board';
		$mid_list = $oModuleModel->getMidList($args, $columnList);

		Context::set('mid_list', $mid_list);

		//Security
		$security = new Security();
		$security->encodeHTML('mid_list..browser_title','mid_list..mid');


		// Set the template
		$this->setTemplateFile('config_move');
	}

/*
* 추천내역
*/
	function dispVoteAdminVotedList()
	{
		$oVoteAdminModel = getAdminModel('vote');
		$output = $oVoteAdminModel->getAdminVotedList($args);
		$page = Context::get('page');
		if(!$page) $page = '1';

		Context::set('no', $output->count);
		Context::set('total_count', $output->page_navigation->total_count);
		Context::set('total_page', $output->page_navigation->total_page);
		Context::set('page', $page);
		Context::set('data_list', $output->data);
		Context::set('page_navigation', $output->page_navigation);

		$this->setTemplateFile('voted_list');
	}

/*
* 권한설정
*/
	function dispVoteAdminGrantSetting()
	{
			// 전체 그룹 정보
			$site_module_info = Context::get('site_module_info');
			$oMemberModel = &getModel('member');
			$group_list = $oMemberModel->getGroups($site_module_info->site_srl);
			Context::set('group_list', $group_list);

		$this->setTemplateFile('grant_setting');
	}
}