<?php

class voteAdminController extends vote
{
	function init()
	{
	}

	function procVoteAdminInsertConfig()
	{
		$oModuleModel = getModel('module');
		$config = $oModuleModel->getModuleConfig('vote');
		$args = Context::getRequestVars();

		// Vote 모듈 On/Off
		$config->use = $args->use;

		// 스킨설정
		$config->skin = $args->skin;

		// 단어설정
		$config->lang_vote = $args->lang_vote;
		$config->lang_blame = $args->lang_blame;

		// 비추천버튼 노출유무 2015.5.1 Ver1.0.1 추가
		$config->use_blameBtn = $args->use_blameBtn;

		// 비추천수 절대값 사용유무
		$config->use_absBlame = $args->use_absBlame;

		// 출력모듈
		$config->use_module_srls = $args->use_module_srls;

		// 공지글 추천
		$config->use_noticeVote = $args->use_noticeVote;

		// 공지글 알림메시지
		$config->msg_noticeVote = $args->msg_noticeVote;

		// 관리자 중복추천
		$config->use_adminVote = $args->use_adminVote;

		// 비회원추천
		$config->use_guestVote = $args->use_guestVote;

		// 비회원 추천불가시 로그인 메시지 세팅
		$config->msg_guestVote = $args->msg_guestVote;

		// 확인창
		$config->use_confirm = $args->use_confirm;
		// 확인창 메시지
		$config->msg_confirm_v = $args->msg_confirm_v;
		$config->msg_confirm_b = $args->msg_confirm_b;
		
		// 레벨특권
		$config->use_level = $args->use_level;
		// 해당 레벨 이상에게
		if($args->level_over<0) return new Object(-1,'레벨은 0 이상이어야 합니다.');
		$config->level_over = $args->level_over;
		// 추천/비추천 개수 세팅
		if($args->level_point<0) return new Object(-1,'추천/비추천 개수는 0 이상이어야 합니다.');
		$config->level_point = $args->level_point;

		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('vote', $config);

		$this->setMessage('success_updated');

		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispVoteAdminConfig');
		$this->setRedirectUrl($returnUrl);
	}


	function procVoteAdminInsertConfigMove()
	{
		$oModuleModel = getModel('module');
		$config = $oModuleModel->getModuleConfig('vote');

		$args = Context::getRequestVars();

		// 추천시 이동설정
		$config->use_mvV= $args->use_mvV;
		
		// 추천목표치
		$config->mvV_count = $args->mvV_count;

		// 이동시 메시지 설정
		$config->msg_mvV = $args->msg_mvV;

		// 이동시 댓글남기기
		$config->use_mvV_cmt = $args->use_mvV_cmt;
		$config->mvV_cmt_memberSrl = $args->mvV_cmt_memberSrl;
		$config->mvV_cmt_memberNick = $args->mvV_cmt_memberNick;
		$config->msg_mvV_cmt = $args->msg_mvV_cmt;

		$config->use_mvB_cmt = $args->use_mvB_cmt;
		$config->mvB_cmt_memberSrl = $args->mvB_cmt_memberSrl;
		$config->mvB_cmt_memberNick = $args->mvB_cmt_memberNick;
		$config->msg_mvB_cmt = $args->msg_mvB_cmt;

		// 출발지 모듈
		$config->mvV_from = $args->mvV_from;

		// 목적지 모듈
		$config->mvV_to = $args->mvV_to;

		// 비추천시 이동설정
		$config->use_mvB = $args->use_mvB;
		
		// 비추천목표치
		$config->mvB_count = $args->mvB_count;

		// 이동시 메시지 설정
		$config->msg_mvB = $args->msg_mvB;

		// 출발지 모듈
		$config->mvB_from = $args->mvB_from;

		// 목적지 모듈
		$config->mvB_to = $args->mvB_to;

		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('vote', $config);

		$this->setMessage('success_updated');

		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispVoteAdminConfigMove');
		$this->setRedirectUrl($returnUrl);
	}

	/**
	 * @brief 게시물 이동기능 config
	 */
	function procVoteAdminGrantSetting()
	{
		$oModuleModel = getModel('module');
		$config = $oModuleModel->getModuleConfig('vote');

		$args = Context::getRequestVars();

		$config->grant_group = $args->grant_group;
		$config->msg_grant = $args->msg_grant;

		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('vote', $config);

		$this->setMessage('success_updated');

		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispVoteAdminGrantSetting');
		$this->setRedirectUrl($returnUrl);
	}
}