<?php
class voteController extends vote
{
	function init()
	{
	}

	function procVoteVoteUp()
	{
		$oVoteModel = &getModel('vote');
		$config = $oVoteModel->getConfig();

		// Vote 모듈 작동유무 체크
		if($config->use!='Y') return;

		// 추천권한 설정
		if(!$oVoteModel->getPermission()) return new Object(-1, $config->msg_grant.'1');

		$document_srl = Context::get('target_srl');
		if(!$document_srl) return new Object(-1, 'msg_invalid_request');

		$oDocumentModel = getModel('document');
		$oDocument = $oDocumentModel->getDocument($document_srl, false, false);
		$module_srl = $oDocument->get('module_srl');
		if(!$module_srl) return new Object(-1, 'msg_invalid_request');

		// 공지글 추천 옵션
		if($oDocument->get('is_notice')=='Y' && $config->use_noticeVote!='Y') return new Object(-1, $config->msg_noticeVote);

		$oModuleModel = getModel('module');
		$document_config = $oModuleModel->getModulePartConfig('document',$module_srl);
		if($document_config->use_vote_up=='N') return new Object(-1, 'msg_invalid_request');

		// 레벨특권
		if($config->use_level=='Y')
		{
			$oVoteModel = getModel('vote');
			$level = $oVoteModel->getLevel();

			if($level >= $config->level_over) $point=$config->level_point;
			else $point=1;
		}
		else $point=1;

		$output = $this->updateVotedCount($document_srl, $point);
		$this->add('voted_count', $output->get('voted_count'));

		// 게시물 이동 method
		$module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);
		if($config->use_mvV == 'Y'&& in_array($module_info->module_srl, $config->mvV_from) && !in_array($module_info->module_srl,$config->mvV_to))
		{
			if($output->get('voted_count') >= $config->mvV_count)
			{
				$obj->mvV = true;
				$obj->document_srl = $document_srl;
				$mvDoc = $this->_moveDoc($obj);
				// 게시물이동값 true 로 넘어오면 아래 method 실행
				if($mvDoc)
				{
					// 댓글남기기 method
					if($config->use_mvV_cmt=='Y')
					{
						$c_obj = new stdClass();
						$c_obj->member_srl = $config->mvV_cmt_memberSrl;
						$c_obj->nick_name = $config->mvV_cmt_memberNick;
						$c_obj->content = $config->msg_mvV_cmt;
						$c_obj->module_srl = $module_info->module_srl;
						$c_obj->document_srl = $document_srl;
						$this->_insertCmt($c_obj);
					}
				}
				$this->add('msg',$config->msg_mvV);
			}
		}

		return $output;
	}

	function procVoteVoteDown()
	{
		$oVoteModel = &getModel('vote');
		$config = $oVoteModel->getConfig();

		// Vote 모듈 작동유무 체크
		if($config->use!='Y') return;

		// 추천권한 설정
		if(!$oVoteModel->getPermission()) return new Object(-1, $config->msg_grant.'1');

		$document_srl = Context::get('target_srl');
		if(!$document_srl) return new Object(-1, 'msg_invalid_request');

		$oDocumentModel = getModel('document');
		$oDocument = $oDocumentModel->getDocument($document_srl, false, false);
		$module_srl = $oDocument->get('module_srl');
		if(!$module_srl) return new Object(-1, 'msg_invalid_request');

		// 공지글 추천 옵션
		if($oDocument->get('is_notice')=='Y' && $config->use_noticeVote!='Y') return new Object(-1, $config->msg_noticeVote);

		$oModuleModel = getModel('module');
		$document_config = $oModuleModel->getModulePartConfig('document',$module_srl);
		if($document_config->use_vote_down=='N') return new Object(-1, 'msg_invalid_request');

		// 레벨특권 시작
		if($config->use_level=='Y')
		{
			$oVoteModel = getModel('vote');
			$level = $oVoteModel->getLevel();

			if($level >= $config->level_over) $point=-($config->level_point);
			else $point=-1;
		}
		else $point=-1;

		$output = $this->updateVotedCount($document_srl, $point);

		// 비추천 절대값 옵션
		if($config->use_absBlame=='Y') $this->add('blamed_count', abs($output->get('blamed_count')));
		else $this->add('blamed_count', $output->get('blamed_count'));

		// 게시물 이동 method
		$module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);
		if($config->use_mvB == 'Y'&& in_array($module_info->module_srl, $config->mvB_from)&&!in_array($module_info->module_srl,$config->mvB_to))
		{
			if(abs($output->get('blamed_count')) >= abs($config->mvB_count))
			{
				$obj->mvV = false;
				$obj->document_srl = $document_srl;
				$mvDoc = $this->_moveDoc($obj);
				// 게시물이동값 true 로 넘어오면 아래 method 실행
				if($mvDoc)
				{
					// 댓글남기기 method
					if($config->use_mvB_cmt=='Y')
					{
						$c_obj = new stdClass();
						$c_obj->member_srl = $config->mvB_cmt_memberSrl;
						$c_obj->nick_name = $config->mvB_cmt_memberNick;
						$c_obj->content = $config->msg_mvB_cmt;
						$c_obj->module_srl = $module_info->module_srl;
						$c_obj->document_srl = $document_srl;
						$this->_insertCmt($c_obj);
					}
				}
			}
			$this->add('msg',$config->msg_mvB);
		}

		return $output;
	}

	function updateVotedCount($document_srl, $point = 1)
	{
		$oVoteModel = &getModel('vote');
		$config = $oVoteModel->getConfig();

		// Vote 모듈 작동유무 체크
		if($config->use!='Y') return;

		if($point > 0) $failed_voted = 'failed_voted';
		else $failed_voted = 'failed_blamed';
		
		// 추천 세션확인
		$logged_info = Context::get('logged_info');
		if($logged_info->is_admin != 'Y')
		{
			if($_SESSION['voted_document'][$document_srl])
			{
				return new Object(-1, $failed_voted);
			}
		}
		else
		{
			if($config->use_adminVote != 'Y')
			{
				if($_SESSION['voted_document'][$document_srl])
			{
				return new Object(-1, $failed_voted);
			}
			}
		}

		$oDocumentModel = getModel('document');
		$oDocument = $oDocumentModel->getDocument($document_srl, false, false);
		

		if($logged_info->is_admin != 'Y')
		{
			if($oDocument->get('ipaddress') == $_SERVER['REMOTE_ADDR'])
			{
				$_SESSION['voted_document'][$document_srl] = true;
				return new Object(-1, $failed_voted);
			}
		}
		else
		{
			if($config->use_adminVote != 'Y')
			{
				if($oDocument->get('ipaddress') == $_SERVER['REMOTE_ADDR'])
				{
					$_SESSION['voted_document'][$document_srl] = true;
					return new Object(-1, $failed_voted);
				}
			}
		}

		$oMemberModel = getModel('member');
		$member_srl = $oMemberModel->getLoggedMemberSrl();
		

		if($oDocument->get('member_srl'))
		{
			if($logged_info->is_admin != 'Y')
			{
				if($member_srl && $member_srl == $oDocument->get('member_srl'))
				{
					$_SESSION['voted_document'][$document_srl] = true;
					return new Object(-1, $failed_voted);
				}
			}
			else
			{
				if($config->use_adminVote != 'Y')
				{
					if($member_srl && $member_srl == $oDocument->get('member_srl'))
					{
						$_SESSION['voted_document'][$document_srl] = true;
						return new Object(-1, $failed_voted);
					}
				}
			}
		}

		$args = new stdClass;
		if($member_srl)
		{
			$args->member_srl = $member_srl;
		}
		else
		{
			$args->ipaddress = $_SERVER['REMOTE_ADDR'];
		}
		$args->document_srl = $document_srl;
		$output = executeQuery('document.getDocumentVotedLogInfo', $args);

		if($logged_info->is_admin != 'Y')
		{
			if($output->data->count)
			{
				$_SESSION['voted_document'][$document_srl] = true;
				return $output;
			}
		}
		else
		{
			if($config->use_adminVote != 'Y')
			{
				if($output->data->count)
				{
					$_SESSION['voted_document'][$document_srl] = true;
					return $output;
				}
			}
		}

		$oDB = DB::getInstance();
		$oDB->begin();

		if($point < 0)
		{
			$args->blamed_count = $oDocument->get('blamed_count') + $point;
			$output = executeQuery('document.updateBlamedCount', $args);
		}
		else
		{
			$args->voted_count = $oDocument->get('voted_count') + $point;
			$output = executeQuery('document.updateVotedCount', $args);
		}
		if(!$output->toBool()) return $output;

		$args->point = $point;
		$output = executeQuery('document.insertDocumentVotedLog', $args);
		if(!$output->toBool()) return $output;

		$obj = new stdClass;
		$obj->member_srl = $oDocument->get('member_srl');
		$obj->module_srl = $oDocument->get('module_srl');
		$obj->document_srl = $oDocument->get('document_srl');
		$obj->update_target = ($point < 0) ? 'blamed_count' : 'voted_count';
		$obj->point = $point;
		$obj->before_point = ($point < 0) ? $oDocument->get('blamed_count') : $oDocument->get('voted_count');
		$obj->after_point = ($point < 0) ? $args->blamed_count : $args->voted_count;
		$trigger_output = ModuleHandler::triggerCall('document.updateVotedCount', 'after', $obj);
		if(!$trigger_output->toBool())
		{
			$oDB->rollback();
			return $trigger_output;
		}

		$oDB->commit();

		$oCacheHandler = CacheHandler::getInstance('object');
		if($oCacheHandler->isSupport())
		{
			$cache_key = 'document_item:'. getNumberingPath($document_srl) . $document_srl;
			$oCacheHandler->delete($cache_key);
		}

		$_SESSION['voted_document'][$document_srl] = true;

		$output = new Object();
		if($point > 0)
		{
			//$output->setMessage('success_voted');
			$output->add('voted_count', $obj->after_point);
		}
		else
		{
			//$output->setMessage('success_blamed');
			$output->add('blamed_count', $obj->after_point);
		}

		return $output;
	}

 
	function triggerBeforeDisplay(&$output_disp)
	{
		// HTML 모드와 admin 모듈 체크
		if(Context::getResponseMethod() != 'HTML' || strpos(strtolower(Context::get('act')), 'admin') !== false) return;
		$module_info = Context::get('module_info');
		if($module_info->module == 'admin' ) return;

		$oVoteModel = &getModel('vote');
		$config = $oVoteModel->getConfig();

		// Vote 모듈 작동유무 체크
		if($config->use!='Y') return;

		// 게시물에서만 작동
		$document_srl = Context::get('document_srl');
		if(!$document_srl) return new Object();

		$oModuleModel = getModel('module');
		$oDocumentModel = getModel('document');

		// document_srl 기반으로 해당 모듈 정보를 받아옴
		$oDocument = $oDocumentModel->getDocument($document_srl);
		$module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);

		// 사용안하는 모듈일 경우 중지
		if($config->use_all != 'Y')
		{
			if(!in_array($module_info->module_srl, $config->use_module_srls)) return new Object();
		}

		$oDocumentModel = &getModel('document');
		$oDocument = $oDocumentModel->getDocument($document_srl, false, false);

		// 추천/비추천 단어세팅
		if($config->lang_vote) Context::set('lang_vote',$config->lang_vote);
		if($config->lang_blame) Context::set('lang_blame',$config->lang_blame);

		Context::set('voted_count', $oDocument->get('voted_count'));

		// 비추천 절대값 옵션
		if($config->use_absBlame=='Y') Context::set('blamed_count', abs($oDocument->get('blamed_count')));
		else Context::set('blamed_count', $oDocument->get('blamed_count'));

		// 탬플릿 생성
		$tmp = $this->_setTemplate();

		// 본문에 삽입
		$output_disp = preg_replace('/<\!--AfterDocument\(([0-9]+),([0-9]+)\)-->/is', '<!--AfterDocument(${1},${2})-->'.$tmp.'', $output_disp);
	}

	// Template 탬플릿 출력 메소드
	function _setTemplate()
	{
		$oVoteModel = &getModel('vote');
		$config = $oVoteModel->getConfig();

		// Vote 모듈 작동유무 체크
		if($config->use!='Y') return;

		$oTemplateHandler = TemplateHandler::getInstance();
		
		// 로그인유무 / 비회원 추천 여부 / 확인창 관련 JS 변수로 할당
		Context::addHtmlHeader(sprintf("<script>var vote_logged = '%s';var vote_guest = '%s';var vote_guest_msg = '%s';var vote_confirm = '%s';var vote_confirm_msg_v = '%s';var vote_confirm_msg_b = '%s';</script>",(Context::get('logged_info')?'true':'false'),$config->use_guestVote,$config->msg_grant,$config->use_confirm,$config->msg_confirm_v,$config->msg_confirm_b));

		// 작동JS tpl 에서 출력(공동으로 쓰여야 하므로)
		Context::addJsFile('./modules/vote/tpl/js/vote.js');

		// 스킨세팅. 모바일,PC 동일하므로 모바일스킨은 따로 세팅하지 않는다.
		$path = sprintf('%sskins/%s/', $this->module_path, $config->skin);
		if(!is_dir($path)||!$config->skin)
		{
			$config->skin = 'default';
			$path = sprintf("%sskins/%s/",$this->module_path, $config->skin);
		}
		$result = $oTemplateHandler->compile($path, 'vote');

		return $result;
	}


	// 게시물 이동기능 함수
	function _moveDoc($obj)
	{
		$oVoteModel = &getModel('vote');
		$config = $oVoteModel->getConfig();

		if($obj->mvV)
		{
			$temp_module= $config->mvV_to;
		}
		else
		{
			$temp_module= $config->mvB_to;
		}

		$document_srl_list[0]=$obj->document_srl;
		$oModule = &getModel('module');
		$oDocumentAdminController = &getAdminController('document');
		$oDocumentAdminController->moveDocumentModule($document_srl_list, $temp_module, null);
		
		return true;
	}

	// 댓글남기기 method
	function _insertCmt($c_obj)
	{
		$oCommentController = &getController('comment');
		$oCommentController->insertComment($c_obj, true);
	}

}