<?php
class androidpushappController extends androidpushapp
{
	function sendPushNotification($devices, $board_title, $message_gcm, $dmember_srl, $cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm) {

		if(is_array($devices)){
			$devices=$devices;
		}else{
			$devices=array($devices);
		}

		$oAndroidpushappModel = getModel('androidpushapp');
		$config = $oAndroidpushappModel->getConfig();

		// please enter the api_key you received from google console
		$api_key_gcm = $config->api_key;						
		$url_gcm = 'https://android.googleapis.com/gcm/send';
		$fields_gcm = array(
			'registration_ids'  => $devices,
			'data'=> array( "board" => $board_title, "message" => $message_gcm, "dmember" => $dmember_srl, "cmember" => $cmember_srl, "ccmember" => $ccmember_srl, "sort" => $sort_gcm, "address" => $address_gcm),
		);		
		$headers_gcm = array(
			'Authorization: key=' . $api_key_gcm,
			'Content-Type: application/json'
		);
		
		$ch_gcm = curl_init();
		curl_setopt($ch_gcm, CURLOPT_URL, $url_gcm);
		curl_setopt($ch_gcm, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch_gcm, CURLOPT_POST, true );
		curl_setopt($ch_gcm, CURLOPT_HTTPHEADER, $headers_gcm);
		curl_setopt($ch_gcm, CURLOPT_RETURNTRANSFER, true );
		curl_setopt($ch_gcm, CURLOPT_POSTFIELDS, json_encode( $fields_gcm ) );	

		// Execute post
		$result33 = curl_exec($ch_gcm);
		// Close connection
		curl_close($ch_gcm);
		return $result33;

	}

	function procAndroidpushappFiledown(){
		$vars = Context::getRequestVars();		
		$file_srl = strip_tags($vars->file_srl);
		$sid = strip_tags($vars->sid);		

		$logged_info = Context::get('logged_info');

		$oFileModel = getModel('file');
		
		// Get file information from the DB
		$columnList = array('file_srl', 'sid', 'isvalid', 'source_filename', 'module_srl', 'uploaded_filename', 'file_size', 'member_srl', 'upload_target_srl', 'upload_target_type');
		$file_obj = $oFileModel->getFile($file_srl, $columnList);

		// If the requested file information is incorrect, an error that file cannot be found appears
		if($file_obj->file_srl!=$file_srl || $file_obj->sid!=$sid) return $this->stop('msg_file_not_found');

		// Notify that file download is not allowed when standing-by(Only a top-administrator is permitted)
		if($logged_info->is_admin != 'Y' && $file_obj->isvalid!='Y') return $this->stop('msg_not_permitted_download');

		$filename = $file_obj->source_filename;
		$file_size = $file_obj->file_size;
		$uploaded_filename = $file_obj->uploaded_filename;
		$file_module_config = $oFileModel->getFileModuleConfig($file_obj->module_srl);

		// Not allow the file outlink
		if($file_module_config->allow_outlink == 'N')
		{
			// Handles extension to allow outlink
			if($file_module_config->allow_outlink_format)
			{
				$allow_outlink_format_array = array();
				$allow_outlink_format_array = explode(',', $file_module_config->allow_outlink_format);
				if(!is_array($allow_outlink_format_array)) $allow_outlink_format_array[0] = $file_module_config->allow_outlink_format;

				foreach($allow_outlink_format_array as $val)
				{
					$val = trim($val);
					if(preg_match("/\.{$val}$/i", $filename))
					{
						$file_module_config->allow_outlink = 'Y';
						break;
					}
				}
			}
			// Sites that outlink is allowed
			if($file_module_config->allow_outlink != 'Y')
			{
				$referer = parse_url($_SERVER["HTTP_REFERER"]);
				if($referer['host'] != $_SERVER['HTTP_HOST'])
				{
					if($file_module_config->allow_outlink_site)
					{
						$allow_outlink_site_array = array();
						$allow_outlink_site_array = explode("\n", $file_module_config->allow_outlink_site);
						if(!is_array($allow_outlink_site_array)) $allow_outlink_site_array[0] = $file_module_config->allow_outlink_site;

						foreach($allow_outlink_site_array as $val)
						{
							$site = parse_url(trim($val));
							if($site['host'] == $referer['host'])
							{
								$file_module_config->allow_outlink = 'Y';
								break;
							}
						}
					}
				}
				else $file_module_config->allow_outlink = 'Y';
			}
			if($file_module_config->allow_outlink != 'Y') return $this->stop('msg_not_allowed_outlink');
		}

		// Check if a permission for file download is granted
		$downloadGrantCount = 0;
		if(is_array($file_module_config->download_grant))
		{
			foreach($file_module_config->download_grant AS $value)
				if($value) $downloadGrantCount++;
		}

		if(is_array($file_module_config->download_grant) && $downloadGrantCount>0)
		{
			if(!Context::get('is_logged')) return $this->stop('msg_not_permitted_download');
			$logged_info = Context::get('logged_info');
			if($logged_info->is_admin != 'Y')
			{
				$oModuleModel =& getModel('module');
				$columnList = array('module_srl', 'site_srl');
				$module_info = $oModuleModel->getModuleInfoByModuleSrl($file_obj->module_srl, $columnList);

				if(!$oModuleModel->isSiteAdmin($logged_info, $module_info->site_srl))
				{
					$oMemberModel =& getModel('member');
					$member_groups = $oMemberModel->getMemberGroups($logged_info->member_srl, $module_info->site_srl);

					$is_permitted = false;
					for($i=0;$i<count($file_module_config->download_grant);$i++)
					{
						$group_srl = $file_module_config->download_grant[$i];
						if($member_groups[$group_srl])
						{
							$is_permitted = true;
							break;
						}
					}
					if(!$is_permitted) return $this->stop('msg_not_permitted_download');
				}
			}
		}
		
		// Increase download_count
		$args = new stdClass();
		$args->file_srl = $file_srl;
		executeQuery('file.updateFileDownloadCount', $args);		
		

		Context::close();

		$fp = fopen($uploaded_filename, 'rb');
		if(!$fp) return $this->stop('msg_file_not_found');

		header("Cache-Control: ");
		header("Pragma: ");
		header("Content-Type: application/octet-stream");
		header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");

		header("Content-Length: " .(string)($file_size));
		header('Content-Disposition: attachment; filename="'.$filename.'"');
		header("Content-Transfer-Encoding: binary\n");

		// if file size is lager than 10MB, use fread function (#18675748)
		if(filesize($uploaded_filename) > 1024 * 1024)
		{
			while(!feof($fp)) echo fread($fp, 1024);
			fclose($fp);
		}
		else
		{
			fpassthru($fp);
		}


		exit();

	}

	// 기기를 등록하기 위해 필요한 장치입니다.
	function procAndroidpushappRegIn(){

		$vars = Context::getRequestVars();		
		$reg_id = strip_tags($vars->reg_id);
		
		$args = new stdClass();
		$args->reg_id = $reg_id;

		$r = executeQueryArray("androidpushapp.getgcmbyid", $args);
		
		if(isset($r->data[0])) return;

		$args = new stdClass();		
		$args->regdate = date('YmdHis');
		$args->reg_id = $reg_id;

		$output = executeQuery("androidpushapp.insertDevice", $args);
		if(!$output->toBool()) return $output;
		
	}	

	// 기기를 회원정보와 동기화 하기 위해 필요한 장치입니다.
	function procAndroidpushappSync(){

		$vars = Context::getRequestVars();		
		$reg_id = strip_tags($vars->reg_id);
		
		$args = new stdClass();		
		$args->member_srl = $vars->member_srl;
		$args->reg_id = $reg_id;

		$output = executeQuery("androidpushapp.updateDevice", $args);
		if(!$output->toBool()) return $output;
		
	}
	

	function triggerAfterInsertDocument(&$obj)
	{
		$oModuleModel = getModel('module');

		$oAndroidpushappModel = getModel('androidpushapp');
		$config = $oAndroidpushappModel->getConfig();
		if($config->use != 'Y') return new Object();
		if($config->use_d != 'Y') return new Object();
		if($obj->status == 'TEMP') return new Object();	
		if($obj->is_secret == 'Y') return new Object();
		if($obj->status == 'SECRET') return new Object();
		
		if(in_array($obj->module_srl, $config->no_use_module_srls)) return;

		$content = strip_tags($obj->title . ' ' . $obj->content);		

		$oDocumentModel = getModel('document');
		$document_srl = $obj->document_srl;		
		$oDocument = $oDocumentModel->getDocument($document_srl);
		$module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);

		$board_title = $module_info->browser_title;
		$member_srl = $oDocument->get('member_srl');
		if(!$member_srl) {			
			
			$logged_info = Context::get('logged_info');
			if($logged_info->member_srl){
				$member_srl = $logged_info->member_srl;
			}else{
				$member_srl = "none";
			}
		}
		
		$dmember_srl=$member_srl;
		$cmember_srl="none";
		$ccmember_srl="none";

		$title_gcm=cut_str(strip_tags($obj->title), 200);
		$address_gcm=$obj->document_srl;
		$name_gcm=$obj->nick_name;
		$message_gcm = $title_gcm."(".$name_gcm.")";

		$sort_gcm = 1;

		$type="Document";
		$this->pushprocessor($type,$board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm);			

		return new Object();
	}

	function triggerAfterInsertComment(&$obj)
	{		

		$oAndroidpushappModel = getModel('androidpushapp');
		$config = $oAndroidpushappModel->getConfig();
		if($config->use != 'Y') return new Object();
		if($config->use_c != 'Y') return new Object();

		if(in_array($obj->module_srl, $config->no_use_module_srls)) return;
		
		$oDocumentModel = getModel('document');
		$oModuleModel = getModel('module');
		$document_srl = $obj->document_srl;
		$comment_srl = $obj->comment_srl;

		$oDocument = $oDocumentModel->getDocument($document_srl);

		$module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);
		$board_title = $module_info->browser_title;			
		$content = $obj->content;
		$comment_count = $oDocument->get('comment_count');

		$member_srl = $oDocument->get('member_srl');

		if(!$member_srl) {			
			$member_srl = "none";
		}

		$member_srl_w = $obj->member_srl;
		if(!$member_srl_w) {			
			
			$logged_info = Context::get('logged_info');
			if($logged_info->member_srl){
				$member_srl_w = $logged_info->member_srl;
			}else{
				$member_srl_w = "none";
			}
		}

		$dmember_srl = $member_srl;
		$cmember_srl = $member_srl_w;

		if($comment_count>1){
			$args->document_srl=$document_srl;			
			$output = executeQueryArray('comment.getAllComments',$args);
			foreach($output->data as $data){
				$cmember_srl.="-".$data->member_srl;
			}
		}		

		$title_gcm=cut_str(strip_tags($content), 200);
		$address_gcm=$document_srl."#comment_".$comment_srl;
		$name_gcm=$obj->nick_name;
		$message_gcm = $title_gcm."(".$name_gcm.")";
	
		$parent_srl = $obj->parent_srl;
		$type="Comment";

		if($parent_srl){

			$oCommentModel = getModel('comment');
			$oComment = $oCommentModel->getComment($parent_srl);
			$ccmember_srl = $oComment->member_srl;
			
		}else{
			
			$ccmember_srl = "none";
		}
		$sort_gcm =3;

		if($obj->is_secret == 'Y') $sort_gcm =7;
		
		$this->pushprocessor($type,$board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm);		

		return new Object();
	}

	function triggerAfterSendMessage(&$trigger_obj)
	{
		$oAndroidpushappModel = getModel('androidpushapp');
		$config = $oAndroidpushappModel->getConfig();
		if($config->use != 'Y') return new Object();
		if($config->use_m != 'Y') return new Object();
		$dmember_srl=$trigger_obj->receiver_srl;
		$oMemberModel = getModel('member');
		$member_info = $oMemberModel->getMemberInfoByMemberSrl($trigger_obj->sender_srl);
		$name_gcm=$member_info->nick_name;
		$title_gcm=cut_str(strip_tags($trigger_obj->title), 200);

		$address_gcm = $trigger_obj->related_srl;			
		
		$message_gcm = $title_gcm."(".$name_gcm.")";
		
		$type="Message";
		$board_title="쪽지";
		$dmember_srl=$trigger_obj->receiver_srl;
		$cmember_srl='none';
		$ccmember_srl='none';
		$sort_gcm=4;
		$this->pushprocessor($type,$board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm);
		
	}

	public function triggerBeforeDisplay(&$output)
	{		
		
			$logged_info = Context::get('logged_info');

			if($logged_info->member_srl){
				$htmlCode = '<script>
					function callAndroid(){		
						window.myJs.callAndroid("%d","%s");
					}

					function callAndroid_login(){		
						window.myJs_login.callAndroid_login("true");
					}
					</script>';
				$htmlCode = sprintf($htmlCode, $logged_info->member_srl,$logged_info->nick_name);
					
			}else{

				$htmlCode = '<script>
					function callAndroid(){		
						window.myJs.callAndroid(null,null);
					}

					function callAndroid_login(){		
						window.myJs_login.callAndroid_login("false");
					}					
					</script>';				
			}
			Context::addHtmlHeader($htmlCode);
			
	}

	function pushprocessor($type,$board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm){
		if($sort_gcm==10){			
			$args->is_admin = "Y";
			$output = executeQueryArray('member.getMemberList',$args);
			foreach($output->data as $data){
				$admin_srl=$data->member_srl;
			}
			$cond->member_srl=$admin_srl;
			$output = executeQueryArray('androidpushapp.getgcmbymem',$cond);

			$send_title = $this->notify($output, $board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm);
			

			$args = new stdClass();
			$args->target_title = "Test";		
			$args->type = $type;		
			$args->target_url = getUrl('act','dispAndroidpushappAdminList');	
			$args->push_date = date('YmdHis');
			$args->text = $send_title;
			$args->target_browser = $board_title;
			$args->pushid = md5(date('YmdHis'));
			$output = executeQuery('androidpushapp.insertPush', $args);
			if(!$output->toBool())
			{
				return $output;
			}

		}elseif($sort_gcm==7){

			$cond->member_srl=$dmember_srl;
			$sort_gcm=3;
			$output = executeQueryArray('androidpushapp.getgcmbymem',$cond);

			$send_title = $this->notify($output, $board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm);

			$args = new stdClass();
			$args->target_title = "Secret Comment";		
			$args->type = $type;		
			$args->target_url = getUrl('act','dispAndroidpushappAdminList');	
			$args->push_date = date('YmdHis');
			$args->text = $send_title;
			$args->target_browser = $board_title;
			$args->pushid = md5(date('YmdHis'));
			$output = executeQuery('androidpushapp.insertPush', $args);
			if(!$output->toBool())
			{
				return $output;
			}

			$cond->member_srl=$ccmember_srl;			
			$output = executeQueryArray('androidpushapp.getgcmbymem',$cond);
			$send_title = $this->notify($output, $board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm);

			$args = new stdClass();
			$args->target_title = "Secret Comment";		
			$args->type = $type;		
			$args->target_url = getUrl('act','dispAndroidpushappAdminList');	
			$args->push_date = date('YmdHis');
			$args->text = $send_title;
			$args->target_browser = $board_title;
			$args->pushid = md5(date('YmdHis'));
			$output = executeQuery('androidpushapp.insertPush', $args);
			if(!$output->toBool())
			{
				return $output;
			}

		}elseif($sort_gcm!=4){

			unset($gcmRegIds);
			$output = executeQueryArray('androidpushapp.getgcm');
			$send_title = $this->notify($output, $board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm);

			$args = new stdClass();
			$args->target_title = $message_gcm;		
			$args->type = $type;		
			$args->target_url = getNotEncodedFullUrl('', 'document_srl', $address_gcm);		
			$args->push_date = date('YmdHis');
			$args->text = $send_title;
			$args->target_browser = $board_title;
			$args->pushid = md5(date('YmdHis'));
			$output = executeQuery('androidpushapp.insertPush', $args);
			if(!$output->toBool())
			{
				return $output;
			}
		}else{
			
			$cond->member_srl=$dmember_srl;
			$output = executeQueryArray('androidpushapp.getgcmbymem',$cond);
			$send_title = $this->notify($output, $board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm);

			$args = new stdClass();
			$args->target_title = "Secret";		
			$args->type = $type;		
			$args->target_url = getUrl('act','dispAndroidpushappAdminList');	
			$args->push_date = date('YmdHis');
			$args->text = $send_title;
			$args->target_browser = $board_title;
			$args->pushid = md5(date('YmdHis'));
			$output = executeQuery('androidpushapp.insertPush', $args);
			if(!$output->toBool())
			{
				return $output;
			}


		}
	}

	function notify ($output, $board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm){

		$i=0;			
		$gcmRegIds = array();		

		foreach($output->data as $data){

			$i++;				
			$gcmRegIds[floor($i/1000)][] = $data->reg_id;
			
		}			

		$f=1;
		$send_title="";		
		
		foreach($gcmRegIds as $val){

			unset($gcm_result);
			unset($remove_ids);			
			
			$gcm_result = $this->sendPushNotification($val, $board_title, $message_gcm, $dmember_srl,$cmember_srl,$ccmember_srl,$sort_gcm, $address_gcm);
			$jsonArray = json_decode($gcm_result);
			$success_send = $jsonArray->success;
			$error_ids = $jsonArray->failure;
			$canonical_ids = $jsonArray->canonical_ids;
			$total_ids = count($jsonArray->results);

			if(!empty($jsonArray->results)){

				$remove_ids = array();					
				$m=0;

				foreach($jsonArray->results as $key3){

					if(isset($key3->error)){

						if($key3->error == "NotRegistered"){

							array_push($remove_ids, $val[$m]);

						}
						if($key3->error == "InvalidRegistration"){

							array_push($remove_ids, $val[$m]);

						}
					}

					if(isset($key3->registration_id)) {
						array_push($remove_ids, $val[$m]);
					}

					$m++;

				}						

				if(!empty($remove_ids)){						

					foreach($remove_ids as $val55){
						
						$del_reg->reg_id = $val55;
						executeQuery('androidpushapp.deletegcm', $del_reg);							

					}
					
				}					
				
				$total_del = $error_ids+$canonical_ids;										
				$send_title .= $f."번째 발송건 : ".$total_ids."명 발송 요청 중 ".$success_send."명 발송 성공, ".$error_ids."명 에러, ".$canonical_ids."명 중복, ".$total_del."명 삭제<br><br>";					
			}

			$f++;
			
		}
		return $send_title;
	}

	
	
}


