<?php
class androidpushapp extends ModuleObject
{
	
	var $triggers = array(
		array('comment.insertComment', 'androidpushapp', 'controller', 'triggerAfterInsertComment', 'after'),	
		array('document.insertDocument', 'androidpushapp', 'controller', 'triggerAfterInsertDocument', 'after'),
		array('communication.sendMessage', 'androidpushapp', 'controller', 'triggerAfterSendMessage', 'after'),	
		array('display', 'androidpushapp', 'controller', 'triggerBeforeDisplay', 'before'),
	);	

	function moduleInstall()
	{
		return new Object();
	}

	function checkUpdate()
	{
		$oModuleModel = getModel('module');
		$oDB = &DB::getInstance();

		foreach($this->triggers as $trigger)
		{
			if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) return true;
		}

		if(!$oDB->isColumnExists('androidpushapp_gcmregid', 'member_srl'))
		{
			return true;
		}	
		

		return false;
	}

	function moduleUpdate()
	{
		$oModuleModel = getModel('module');
		$oModuleController = getController('module');
		$oDB = &DB::getInstance();

		foreach($this->triggers as $trigger)
		{
			if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]))
			{
				$oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
			}
		}

		if(!$oDB->isColumnExists('androidpushapp_gcmregid','member_srl'))
		{
			$oDB->addColumn('androidpushapp_gcmregid', 'member_srl', 'number', 11);
		}
		return new Object(0, 'success_updated');		
	}

	function recompileCache()
	{
		return new Object();
	}

	function moduleUninstall()
	{
		$oModuleController = getController('module');

		foreach($this->triggers as $trigger)
		{
			$oModuleController->deleteTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
		}
		return new Object();
	}
}
