<?php
class androidpushappController extends androidpushapp
{
	function sendPushNotification($devices, $board_title, $message_gcm, $sort_gcm, $address_gcm) {

		if(is_array($devices)){
			$devices=$devices;
		}else{
			$devices=array($devices);
		}

		$oAndroidpushappModel = getModel('androidpushapp');
		$config = $oAndroidpushappModel->getConfig();
		

		// please enter the api_key you received from google console
		$api_key_gcm = $config->api_key;						
		$url_gcm = 'https://android.googleapis.com/gcm/send';
		$fields_gcm = array(
			'registration_ids'  => $devices,
			'data'=> array( "board" => $board_title, "message" => $message_gcm, "sort" => $sort_gcm, "address" => $address_gcm),
		);		
		$headers_gcm = array(
			'Authorization: key=' . $api_key_gcm,
			'Content-Type: application/json'
		);
		
		$ch_gcm = curl_init();
		curl_setopt($ch_gcm, CURLOPT_URL, $url_gcm);
		curl_setopt($ch_gcm, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch_gcm, CURLOPT_POST, true );
		curl_setopt($ch_gcm, CURLOPT_HTTPHEADER, $headers_gcm);
		curl_setopt($ch_gcm, CURLOPT_RETURNTRANSFER, true );
		curl_setopt($ch_gcm, CURLOPT_POSTFIELDS, json_encode( $fields_gcm ) );	

		// Execute post
		$result33 = curl_exec($ch_gcm);
		// Close connection
		curl_close($ch_gcm);
		return $result33;

	}

	// 기기를 등록하기 위해 필요한 장치입니다.
	function procAndroidpushappRegIn(){

		$vars = Context::getRequestVars();		
		$reg_id = strip_tags($vars->reg_id);
		
		$args = new stdClass();
		$args->reg_id = $reg_id;

		$r = executeQueryArray("androidpushapp.getgcmbyid", $args);
		
		if(isset($r->data[0])) return;

		$args = new stdClass();		
		$args->regdate = date('YmdHis');
		$args->reg_id = $reg_id;

		$output = executeQuery("androidpushapp.insertDevice", $args);
		if(!$output->toBool()) return $output;
		
	}	
	

	function triggerAfterInsertDocument(&$obj)
	{
		$oModuleModel = getModel('module');

		$oAndroidpushappModel = getModel('androidpushapp');
		$config = $oAndroidpushappModel->getConfig();
		if($config->use != 'Y') return new Object();
		if($config->use_d != 'Y') return new Object();
		if(in_array($obj->module_srl, $config->no_use_module_srls)) return;

		$content = strip_tags($obj->title . ' ' . $obj->content);		

		$oDocumentModel = getModel('document');
		$document_srl = $obj->document_srl;		
		$oDocument = $oDocumentModel->getDocument($document_srl);
		$module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);

		$board_title = $module_info->browser_title;

		$member_srl = $oDocument->get('member_srl');

		$title_gcm=cut_str(strip_tags($obj->title), 200);
		$address_gcm=$obj->document_srl;
		$name_gcm=$obj->nick_name;
		$message_gcm = $title_gcm."(".$name_gcm.")";

		$sort_gcm = 1;		

		unset($gcmRegIds);
		$output = executeQueryArray('androidpushapp.getgcm');
		$i=0;			
		$gcmRegIds = array();
		

		foreach($output->data as $data){

			$i++;				
			$gcmRegIds[floor($i/1000)][] = $data->reg_id;
			
		}

		$gcm_result = array();

		$f=1;
		$send_title="";
		
		
		foreach($gcmRegIds as $val){

			unset($gcm_result);
			unset($remove_ids);				
			$gcm_result = array();
			$gcm_result = $this->sendPushNotification($val, $board_title, $message_gcm, $sort_gcm, $address_gcm);
			$jsonArray = json_decode($gcm_result);
			$success_send = $jsonArray->success;
			$error_ids = $jsonArray->failure;
			$canonical_ids = $jsonArray->canonical_ids;
			$total_ids = count($jsonArray->results);

			if(!empty($jsonArray->results)){

				$remove_ids = array();					
				$m=0;

				foreach($jsonArray->results as $key3){

					if(isset($key3->error)){

						if($key3->error == "NotRegistered"){

							array_push($remove_ids, $val[$m]);

						}
					}

					if(isset($key3->registration_id)) {
						array_push($remove_ids, $val[$m]);
					}

					$m++;

				}						

				if(!empty($remove_ids)){						

					foreach($remove_ids as $val55){
						
						$del_reg->reg_id = $val55;
						executeQuery('androidpushapp.deletegcm', $del_reg);							

					}
					
				}					
				
				$total_del = $error_ids+$canonical_ids;										
				$send_title .= $f."번째 발송건 : ".$total_ids."명 발송 요청 중 ".$success_send."명 발송 성공, ".$error_ids."명 에러, ".$canonical_ids."명 중복, ".$total_del."명 삭제<br><br>";					
			}

			$f++;

			
		}

		$args = new stdClass();
		$args->target_title = $message_gcm;		
		$args->type = "Document";		
		$args->target_url = getNotEncodedFullUrl('', 'document_srl', $obj->document_srl);		
		$args->push_date = date('YmdHis');
		$args->target_browser = $module_info->browser_title;
		$args->text = $send_title;
		$args->pushid = md5(date('YmdHis'));
		$output = executeQuery('androidpushapp.insertPush', $args);
		if(!$output->toBool())
		{
			return $output;
		}			

		return new Object();
	}

	function triggerAfterInsertComment(&$obj)
	{		

		$oAndroidpushappModel = getModel('androidpushapp');
		$config = $oAndroidpushappModel->getConfig();
		if($config->use != 'Y') return new Object();
		if($config->use_c != 'Y') return new Object();

		if(in_array($obj->module_srl, $config->no_use_module_srls)) return;		

		$document_srl = $obj->document_srl;
		$oModuleModel = getModel('module');
		$module_info = $oModuleModel->getModuleInfoByDocumentSrl($document_srl);
		$board_title = $module_info->browser_title;			
		$content = $obj->content;		


		$title_gcm=cut_str(strip_tags($content), 200);
		$address_gcm=$document_srl;
		$name_gcm=$obj->nick_name;
		$message_gcm = $title_gcm."(".$name_gcm.")";		

		$sort_gcm =3;			
		unset($gcmRegIds);
		$output = executeQueryArray('androidpushapp.getgcm');
		$i=0;			
		$gcmRegIds = array();
		

		foreach($output->data as $data){

			$i++;				
			$gcmRegIds[floor($i/1000)][] = $data->reg_id;
			
		}

		$gcm_result = array();

		$f=1;
		$send_title="";
		
		
		foreach($gcmRegIds as $val){

			unset($gcm_result);
			unset($remove_ids);				
			$gcm_result = array();
			$gcm_result = $this->sendPushNotification($val, $board_title, $message_gcm, $sort_gcm, $address_gcm);
			$jsonArray = json_decode($gcm_result);
			$success_send = $jsonArray->success;
			$error_ids = $jsonArray->failure;
			$canonical_ids = $jsonArray->canonical_ids;
			$total_ids = count($jsonArray->results);

			if(!empty($jsonArray->results)){

				$remove_ids = array();					
				$m=0;

				foreach($jsonArray->results as $key3){

					if(isset($key3->error)){

						if($key3->error == "NotRegistered"){

							array_push($remove_ids, $val[$m]);

						}
					}

					if(isset($key3->registration_id)) {
						array_push($remove_ids, $val[$m]);
					}

					$m++;

				}						

				if(!empty($remove_ids)){						

					foreach($remove_ids as $val55){
						
						$del_reg->reg_id = $val55;
						executeQuery('androidpushapp.deletegcm', $del_reg);							

					}
					
				}					
				
				$total_del = $error_ids+$canonical_ids;										
				$send_title .= $f."번째 발송건 : ".$total_ids."명 발송 요청 중 ".$success_send."명 발송 성공, ".$error_ids."명 에러, ".$canonical_ids."명 중복, ".$total_del."명 삭제<br><br>";					
			}

			$f++;

			
		}

		$args = new stdClass();
		$args->target_title = $message_gcm;		
		$args->type = "Comment";		
		$args->target_url = getNotEncodedFullUrl('', 'document_srl', $obj->document_srl);		
		$args->push_date = date('YmdHis');
		$args->text = $send_title;
		$args->target_browser = $module_info->browser_title;
		$args->pushid = md5(date('YmdHis'));
		$output = executeQuery('androidpushapp.insertPush', $args);
		if(!$output->toBool())
		{
			return $output;
		}			
	

		return new Object();
	}
	
}


