<?php
    class ding_member_ranking extends WidgetHandler
    {
        /*
        * 올바른 값이 Conf에 들어왔는지 확인한다.
        * 올바른 값이 들어오지 않았으면 $basic_value가 들어온다.
        * $info_value = Conf의 값, $basic_value = 기본적인 값
       */
        function Check_RightValue($info_value, $basic_value)
        {
            if(!$info_value)
                $info_value = $basic_value;

            return $info_value;
        }

        /*
         * CSS_Sorce로 변경시켜준다.
         * css_type = CSS의 종류(height, font 등)
         * css_value = CSS의 값(red, 25 등)
         * css_unit = CSS의 단위 값(px em 등)
         */
        function Return_CssSorce($css_type, $css_value, $css_unit=null)
        {
            return $css_type." : ".$css_value.$css_unit.";";
        }

        /*
         * Conf로 받은 값을 ,을 기준으로 나눠준다.
         * $info_value = Conf의 값. 배열의 값으로 반환.
         */
        function Divide_Value($info_value)
        {
            // 값을 반환시키기 위한 배열.
            $return_array = array();
            $info_value = preg_replace('/\s+/', "", $info_value);

            $return_array = explode(',', $info_value);
            return $return_array;
        }

        /*
         * 올바른 색깔 값이 들어왔는지 확인한다.
         * 틀렸을 때 $basic_color가 null 이면 기본값을 대입.
         * null이 아니면 $basic_color를 대입한다.
         */
        function Check_ColorValue($info_value, $basic_color=null)
        {
            $info_value = preg_replace('/\s+/', "", $info_value);

            if($info_value[0] != '#' && !$basic_color)
                $info_value = 기본값;
            else if($info_value[0] != '#' && $basic_color)
                $info_value = $basic_color;

            return $info_value;
        }

        /*
         * 사용할 여부를 체크한다.
         * 사용안함이면 null를 반환.
         */
        function Check_Use($info_value)
        {
            $info_value = preg_replace('/\s+/', "", $info_value);

            if($info_value == '사용안함')
                $info_value = '사용안함';

            return $info_value;
        }

        function proc($args)
        {
            $oModuleModel = getModel('module');
            $config = $oModuleModel->getModuleConfig('point');

            $PointModel = getModel("point");

            $level_icon = "./modules/point/icons/". $config->level_icon;
            Context::set("level_icon", $level_icon);

            //Option 부분을 설정.
            $rank_option = array();

            // 타이틀의 뷰 여부를 결정한다.
            $rank_option['title_view'] = $args->title_view;

            //타이틀 정렬 기준
            $rank_option['title_center'] = $this->Return_CssSorce("text-align", $args->title_range);

            // 타이틀 설정. ( 비어있으면 default 값이 들어간다. )
            $rank_option['widget_title'] = $this->Check_RightValue($args->widget_title, "RANKING");

            //위젯 타이틀 사이즈 (set)
            $Title_Size = $this->Divide_Value($args->widget_title_size);

            settype($Title_Size[0], 'int');
            settype($Title_Size[1], 'int');

            $Title_Size[0] = $this->Check_RightValue($Title_Size[0], 8);    // 값이 없으면 8 대입
            $Title_Size[1] = $this->Check_RightValue($Title_Size[1], 8);    // 값이 없으면 8 대입

            for($i=0; $i< 2; $i++)
                $Title_Size[i] = $this->Check_RightValue($Title_Size[i], 8); // 값이 없으면 8 대입

            $args->widget_title_size = $Title_Size[0].",".$Title_Size[1];

            $rank_option['size'] = 'padding : '.$Title_Size[0].'px '.$Title_Size[1].'px;';

            //위젯 타이틀 배경 색 ( Conf 설정)
            $args->widget_title_color = $this->Check_ColorValue($args->widget_title_color);

            $rank_option['color'] = "";

            if($args->widget_title_color != 기본값)
                $rank_option[color] = $this->Return_CssSorce("background-color", $args->widget_title_color);

            //위젯 타이틀 폰트 크기 (Conf 설정)
            settype($args->widget_font_size, 'int');
            $args->widget_font_size = $this->Check_RightValue($args->widget_font_size, 14);

            $rank_option['font_size'] = $this->Return_CssSorce("font-size", $args->widget_font_size, "px");

            //위젯 타이틀 폰트 색 (Conf 설정)
            $args->widget_font_color = $this->Check_ColorValue($args->widget_font_color);

            $rank_option['font_color'] = "";
            if($args->widget_font_color != 기본값)
                $rank_option['font_color'] = $this->Return_CssSorce("color", $args->widget_font_color);

            // 스킨 Conf 1
            $args->border_first_type = $this->Check_Use($args->border_first_type);

            if($args->border_first_type == "사용안함")
                $rank_option['skin1_style'] = "border : 0px none;";
            else
            {
                $Third_Skin = $this->Divide_Value($args->border_first_type);

                $Third_Skin[0] = $this->Check_ColorValue($Third_Skin[0], "#F2595E");
                settype($First_Skin[1], 'int');
                $Third_Skin[1] =  $this->Check_RightValue($Third_Skin[1], 1);

                $args->border_first_type = $Third_Skin[0].",".$Third_Skin[1];
                $rank_option['skin1_style'] = "border : ".$Third_Skin[1]."px solid ".$Third_Skin[0].";";
            }

            // 스킨 Conf 2
            $args->border_second_type = $this->Check_Use($args->border_second_type);

            if($args->border_second_type == "사용안함")
                $rank_option['skin2_style'] = "border-bottom : 0px none;";
            else
            {
                $First_Skin =  $this->Divide_Value($args->border_second_type);

                $First_Skin[0] = $this->Check_ColorValue($First_Skin[0], "#000000");
                settype($First_Skin[1], 'int');
                $First_Skin[1] =  $this->Check_RightValue($First_Skin[1], 2);

                $args->border_second_type = $First_Skin[0].",".$First_Skin[1];
                $rank_option['skin2_style'] = "border-bottom :".$First_Skin[1]."px solid ".$First_Skin[0].";";
            }

            // 세번쨰 스킨 Total 부분.
            $args->border_third_type_total = $this->Check_Use($args->border_third_type_total);

            if($args->border_third_type_total == "사용안함")
                $rank_option['skin3_style_total_border'] = "border : 0px none;";
            else
            {
                $Third_Skin = $this->Divide_Value($args->border_third_type_total);

                $Third_Skin[0] = $this->Check_ColorValue($Third_Skin[0], "#B8CEED");
                settype($First_Skin[1], 'int');
                $Third_Skin[1] =  $this->Check_RightValue($Third_Skin[1], 1);

                $args->border_third_type_total = $Third_Skin[0].",".$Third_Skin[1];
                $rank_option['skin3_style_total_border'] = "border : ".$Third_Skin[1]."px solid ".$Third_Skin[0].";";
            }

            // 세번쨰 스킨 밑 테두리 부분.
            $args->border_third_type_under = $this->Check_Use($args->border_third_type_under);

            if($args->border_third_type_under == "사용안함")
                $rank_option['skin3_style_title_border'] = "border-bottom : 0px none;";
            else
            {
                $Third_Skin = $this->Divide_Value($args->border_third_type_under);

                $Third_Skin[0] = $this->Check_ColorValue($Third_Skin[0], "#D6E2F2");
                settype($First_Skin[1], 'int');
                $Third_Skin[1] =  $this->Check_RightValue($Third_Skin[1], 1);

                $args->border_third_type_under = $Third_Skin[0].",".$Third_Skin[1];
                $rank_option['skin3_style_title_border'] = "border-bottom : ".$Third_Skin[1]."px solid ".$Third_Skin[0].";";
            }

            // 네번쨰 스킨 Total 부분.
            $args->border_fourth_type_total = $this->Check_Use($args->border_fourth_type_total);

            if($args->border_fourth_type_total == "사용안함")
                $rank_option['skin4_style_total_border'] = "border : 0px none;";
            else
            {
                $Third_Skin = $this->Divide_Value($args->border_fourth_type_total);

                $Third_Skin[0] = $this->Check_ColorValue($Third_Skin[0], "#e9e9e9");
                settype($First_Skin[1], 'int');
                $Third_Skin[1] =  $this->Check_RightValue($Third_Skin[1], 1);

                $args->border_fourth_type_total = $Third_Skin[0].",".$Third_Skin[1];
                $rank_option['skin4_style_total_border'] = "border : ".$Third_Skin[1]."px solid ".$Third_Skin[0].";";
            }

            // 네번쨰 스킨 밑 테두리 부분.
            $args->border_fourth_type_under = $this->Check_Use($args->border_fourth_type_under);

            if($args->border_fourth_type_under == "사용안함")
                $rank_option['skin4_style_title_border'] = "border-bottom : 0px none;";
            else
            {
                $Third_Skin = $this->Divide_Value($args->border_fourth_type_under);

                $Third_Skin[0] = $this->Check_ColorValue($Third_Skin[0], "#e9e9e9");
                settype($First_Skin[1], 'int');
                $Third_Skin[1] =  $this->Check_RightValue($Third_Skin[1], 1);

                $args->border_fourth_type_under = $Third_Skin[0].",".$Third_Skin[1];
                $rank_option['skin4_style_title_border'] = "border-bottom : ".$Third_Skin[1]."px solid ".$Third_Skin[0].";";
            }

            // 값 옆에 붙는 단어를 설정.
            $rank_option[value_nick] = $args->value_nick;

            // 랭킹 리스트 부분 넓이 설정. ( 비어있으면 default 값이 들어간다. )
            settype($args->order_width , 'int');
            $args->order_width = $this->Check_RightValue($args->order_width, 40);
            $rank_option[order_width] = $this->Return_CssSorce('width', $args->order_width, 'px');

            // 이미지
            $rank_option['image'] = $args->rank_image;
            $rank_option['use_level_icon'] = $args->use_level_icon;

            // 레벨 이미지의 사용 여부.
            $rank_option['use_level_icon'] = $args->use_level_icon;

            // 이미지에 따라 CSS 결정
            $rank_option['CSS_Title']="";
            if($rank_option['image'] == "crown")
                $rank_option['CSS_Title'] = "Ding_Member_CrownRanking";
            else
                $rank_option['CSS_Title'] = "Ding_Member_BoxRanking";

            //정렬 기준 값들의 넓이 ( 비어있으면 default 값이 들어간다. )
            settype($args->value_width, 'int');
            $args->value_width = $this->Check_RightValue($args->value_width, 30);
            $rank_option[value_width] = $this->Return_CssSorce('width', $args->value_width, 'px');

            //정렬 기준 이름의 넓이 ( 비어있으면 default 값이 들어간다. )
            settype($args->value_nick_width, 'int');
            $args->value_nick_width = $this->Check_RightValue($args->value_nick_width, 30);
            $rank_option[value_nick_width] = $this->Return_CssSorce('width', $args->value_nick_width, 'px');

            // 쿼리를 돌리는 데 필요한 데이터들.
            $site_module_info = Context::get('site_module_info');
            $site_srl = (int)$site_module_info->site_srl;


            //시간 설정. (소스 안)
            $rimit_date = abs($args->limit_date);
            if($rimit_date)
                $rimit_date = date('YmdHis',strtotime ('-'.$rimit_date.'hours'));
            else
                $rimit_date = 0;

             //그룹이 선택되지 않으면 모든 그룹을 추출함
            if(!$args->with_group) {
                $oMemberModel = &getModel('member');
                $groups = $oMemberModel->getGroups($site_srl);
                if(is_array($groups)) {
                    $args->with_group = implode(',',array_keys($groups));
                } else return;
            }

            $obj = new stdClass();
            $obj->with_group = $args->with_group;
            $obj->list_num = $list_count;

            // 전체 맴버들을 가져온다.
            $members = executeQueryArray('widgets.ding_member_ranking.getGroupMember', $obj);
            $members = $members->data;
            Context::set("members", $members);

            //랭킹을 나눠주는 기준.
            $list = new stdClass();
            Context::set("sort", $sort);

            $sort = $args->order_target;

            if($sort == "comment_num")
            {
                $list->module_srl = $args->module_srls;
                $list->now_date = $rimit_date;
                $list_outputs = executeQueryArray('widgets.ding_member_ranking.getRankComment', $list);
                Context::set("list_outputs", $list_outputs);
                $list_outputs = $list_outputs->data;
            }

            else
            {
                $list->module_srl = $args->module_srls;
                $list->now_date = $rimit_date;
                $list_outputs = executeQueryArray('widgets.ding_member_ranking.getRankDocument', $list);
                Context::set("list_outputs", $list_outputs);
                $list_outputs = $list_outputs->data;
            }

            //실질적인 랭킹을 담을 수 있도록 배열을 만든다.
            $rank_array = array();
            $real_count = 0;

            foreach($members as $key=>$member)
            {
                if($real_count <= $list_count)
                {
                    $rank_array[$key]['list_count'] = 0;
                    $rank_array[$key]['nick_name'] = $member->nick_name;
                    $rank_array[$key]['member_srl'] = $member->member_srl;

                    $member_point = $PointModel->getPoint($rank_array[$key]['member_srl']);
                    $rank_array[$key]['level'] = $PointModel->getLevel($member_point, $config->level_step);

                    if($sort != "point_num")
                    {
                        foreach($list_outputs as $list_output)
                        {
                            if($member->member_srl == $list_output->member_srl)
                            {
                                //게시판 수.
                                if($sort == "list_count" || $sort == "comment_num")
                                {
                                    $rank_array[$key]['list_count'] += 1;
                                }

                                //추천 수, 댓글 수
                                else
                                {
                                    $rank_array[$key]['list_count'] += $list_output->$sort;
                                }
                            }
                        }
                    }

                    else if($sort == "point_num")
                    {
                        $rank_array[$key]['list_count'] = $member_point;
                    }

                    else if($sort == "level_order")
                    {
                        $rank_array[$key]['list_count'] = $rank_array[$key]['level'];
                    }
                }
            }

            //리스트 수 (소스 안, 쿼리)
            $list_count = $args->list_count;
            if(!$list_count || $list_count > count($rank_array))
                $list_count = count($rank_array);


            rsort($rank_array);

            $rank_option['count'] = $list_count;

            Context::set("rank_array",$rank_array);

            Context::set("rank_option", $rank_option);

            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            $tpl_file = 'member';

            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }

    }
?>