<?php
    class ding_member_ranking extends WidgetHandler
    {
        function proc($args)
        {
            //Option 부분을 설정.
            $rank_option = array();

            // 타이틀 설정. ( 비어있으면 default 값이 들어간다. )
            $rank_option[widget_title] = $args->widget_title;
            if(! $rank_option[widget_title])
                $rank_option[widget_title] = 'RANKING';

            //위젯 타이틀 사이즈 (set)
            $args->widget_title_size = preg_replace('/\s+/', "", $args->widget_title_size);
            $Title_Size = explode(',', $args->widget_title_size);

            settype($Title_Size[0], 'int');
            settype($Title_Size[1], 'int');

            /*이 부분 함수화 Return으로 값을 넘겨 받을 수 있게*/
            if(!intval($Title_Size[0]))
                $Title_Size[0] = 8;
            if(!intval($Title_Size[1]))
                $Title_Size[1] = 8;

            $args->widget_title_size = $Title_Size[0].", ".$Title_Size[1];

            $rank_option['size'] = 'padding : '.$Title_Size[0].'px '.$Title_Size[1].'px;';

            // 값 옆에 붙는 단어를 설정.
            $rank_option[value_nick] = $args->value_nick;

            // 랭킹 리스트 부분 넓이 설정. ( 비어있으면 default 값이 들어간다. )
            if($args->order_width)
                $rank_option[order_width] = 'width:'.$args->order_width.'px';
            else
            {
                $args->order_width = 40;
                $rank_option[order_width] = 'width: 40px';
            }

            //타이틀 정렬 기준
            $rank_option[title_center] =  'text-align: '.$args->title_range.";";

            //정렬 기준 값들의 넓이 ( 비어있으면 default 값이 들어간다. )
            if($args->value_width)
                $rank_option[value_width] = 'width:'.$args->value_width.'px';
            else
            {
                $args->value_width = 30;
                $rank_option[value_width] = 'width: 30px';
            }

            if($args->list_height)
                $rank_option[line_height] = 'padding:'.$args->list_height.'px 0;';
            else
            {
                $args->value_width = 7;
                $rank_option[line_height] = 'padding: 7px 0;';
            }

            //정렬 기준 이름의 넓이 ( 비어있으면 default 값이 들어간다. )
            if($args->value_nick_width)
                $rank_option[value_nick_width] = 'width:'.$args->value_nick_width.'px';
            else
            {
                $args->value_nick_width = 30;
                $rank_option[value_nick_width] = 'width: 30px';
            }

            // 쿼리를 돌리는 데 필요한 데이터들.
            $site_module_info = Context::get('site_module_info');
            $site_srl = (int)$site_module_info->site_srl;

            //시간 설정. (소스 안)
            $rimit_date = abs($args->limit_date);
            if($rimit_date)
                $rimit_date = date('YmdHis',strtotime ('-'.$rimit_date.'hours'));
            else
                $rimit_date = 0;

             //그룹이 선택되지 않으면 모든 그룹을 추출함
            if(!$args->with_group) {
                $oMemberModel = &getModel('member');
                $groups = $oMemberModel->getGroups($site_srl);
                if(is_array($groups)) {
                    $args->with_group = implode(',',array_keys($groups));
                } else return;
            }

            $obj = new stdClass();
            $obj->with_group = $args->with_group;
            $obj->list_num = $list_count;

            // 전체 맴버들을 가져온다.
            $members = executeQueryArray('widgets.ding_member_ranking.getGroupMember', $obj);
            $members = $members->data;
            Context::set("members", $members);

            //랭킹을 나눠주는 기준.
            $list = new stdClass();
            Context::set("sort", $sort);

            $sort = $args->order_target;

            if($sort == "comment_num")
            {
                $list->module_srl = $args->module_srls;
                $list->now_date = $rimit_date;
                $list_outputs = executeQueryArray('widgets.ding_member_ranking.getRankComment', $list);
                Context::set("list_outputs", $list_outputs);
                $list_outputs = $list_outputs->data;
            }

            else
            {
                $list->module_srl = $args->module_srls;
                $list->now_date = $rimit_date;
                $list_outputs = executeQueryArray('widgets.ding_member_ranking.getRankDocument', $list);
                Context::set("list_outputs", $list_outputs);
                $list_outputs = $list_outputs->data;
            }

            //실질적인 랭킹을 담을 수 있도록 배열을 만든다.
            $rank_array = array();
            $real_count = 0;

            foreach($members as $key=>$member)
            {
                if($real_count <= $list_count)
                {
                    $rank_array[$key]['list_count'] = 0;
                    $rank_array[$key]['nick_name'] = $member->nick_name;

                    foreach($list_outputs as $list_output)
                    {
                        if($member->member_srl == $list_output->member_srl)
                        {
                            //게시판 수.
                            if($sort == "list_count" || $sort == "comment_num")
                            {
                                $rank_array[$key]['list_count'] += 1;
                            }

                            //추천 수, 댓글 수
                            else
                            {
                                $rank_array[$key]['list_count'] += $list_output->$sort;
                            }
                        }
                    }
                }
            }

            //리스트 수 (소스 안, 쿼리)
            $list_count = $args->list_count;
            if(!$list_count || $list_count > count($rank_array))
                $list_count = count($rank_array);


            rsort($rank_array);

            $rank_option['count'] = $list_count;

            Context::set("rank_array",$rank_array);

            Context::set("rank_option", $rank_option);

            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            $tpl_file = 'member';

            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }

    }
?>