<?php
    class ding_member_ranking extends WidgetHandler
    {
        function proc($args)
        {
            //Option 부분을 설정.
            $rank_option = array();

            // 타이틀 설정. ( 비어있으면 default 값이 들어간다. )
            $rank_option[widget_title] = $args->widget_title;
            if(! $rank_option[widget_title])
                $rank_option[widget_title] = 'RANKING';

            // 값 옆에 붙는 단어를 설정.
            $rank_option[value_nick] = $args->value_nick;

            // 랭킹 리스트 부분 넓이 설정. ( 비어있으면 default 값이 들어간다. )
            if($args->order_width)
                $rank_option[order_width] = 'width:'.$args->order_width.'px';
            else
            {
                $args->order_width = 25;
                $rank_option[order_width] = 'width: 25px';
            }

            //타이틀 정렬 기준
            $rank_option[title_center] =  'text-align: '.$args->title_range;


            //정렬 기준 값들의 넓이 ( 비어있으면 default 값이 들어간다. )
            if($args->value_width)
                $rank_option[value_width] = 'width:'.$args->value_width.'px';
            else
            {
                $args->value_width = 30;
                $rank_option[value_width] = 'width: 30px';
            }

            //정렬 기준 이름의 넓이 ( 비어있으면 default 값이 들어간다. )
            if($args->value_nick_width)
                $rank_option[value_nick_width] = 'width:'.$args->value_nick_width.'px';
            else
            {
                $args->value_nick_width = 30;
                $rank_option[value_nick_width] = 'width: 30px';
            }

            // 쿼리를 돌리는 데 필요한 데이터들.
            $site_module_info = Context::get('site_module_info');
            $site_srl = (int)$site_module_info->site_srl;

            //시간 설정. (소스 안)
            $rimit_date = abs($args->limit_date);
            if($rimit_date)
                $rimit_date = date('YmdHis',strtotime ('-'.$rimit_date.'hours'));
            else
                $rimit_date = 0;

            //리스트 수 (소스 안, 쿼리)
            $list_count = $args->list_count;
            if(!$list_count)
                $list_count = 10000000;

             //그룹이 선택되지 않으면 모든 그룹을 추출함
            if(!$args->with_group) {
                $oMemberModel = &getModel('member');
                $groups = $oMemberModel->getGroups($site_srl);
                if(is_array($groups)) {
                    $args->with_group = implode(',',array_keys($groups));
                } else return;
            }

            $obj = new stdClass();
            $obj->with_group = $args->with_group;
            $obj->list_num = $list_count;
            $obj->rimit_date = $rimit_date;

            // 전체 맴버들을 가져온다.
            $members = executeQueryArray('widgets.ding_member_ranking.getGroupMember', $obj);
            $members_array = $members->data;
            $members_count = count($members_array);

            Context::set("members_array",$members_array);

            switch ($args->order_target)
            {
                case "document_num":
                    $output = executeQueryArray('widgets.ding_member_ranking.getRankDocumentCount', $obj);
                    break;
                case "readed_num":
                    $output = executeQueryArray('widgets.ding_member_ranking.getRankReadedCount', $obj);
                    break;
                case "voted_num":
                    $output = executeQueryArray('widgets.ding_member_ranking.getRankVotedCount', $obj);
                    break;
                case "comment_num":
                    $output = executeQueryArray('widgets.ding_member_ranking.getRankCommentCount', $obj);
                    break;
                default:
                    break;
            }

            $output_array = $output->data;
            $output_count = count($output_array);   //$output_array로 출력된 값.

            for($i=0; $i < $members_count; $i++)
            {
                $count = 0;
                if($output_count < $list_count)
                {
                    for($o=0; $o <$members_count; $o++)
                    {
                        if($output_array[$o]->nick_name == $members_array[$i]->nick_name)
                            $count++;
                    }

                    if($count == 0)
                    {
                        $output_array[$output_count]= new stdClass();
                        $output_array[$output_count]->count = 0;
                        $output_array[$output_count]->nick_name = $members_array[$i]->nick_name;
                        $output_array[$output_count]->user_name = $members_array[$i]->user_name;
                        $output_array[$output_count]->member_srl = $members_array[$i]->member_srl;
                        $output_count+=1;
                    }
                }
            }

            Context::set("output_array", $output_array);

            //카운트 추가.
            $rank_option[count] =  count($output_array);

            Context::set("rank_option", $rank_option);

            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            $tpl_file = 'member';

            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }

    }
?>