
XE Session Shield 애드온
========================

XSS, CSRF, 세션 고정 공격에 방어하고, 특정 상황에서의 세션 탈취 가능성을 줄여 주는 애드온입니다.
@AJKJ 님의 [XSS Session Protector](http://www.xpressengine.com/index.php?mid=download&package_id=22753449) 애드온을 바탕으로
[SSL 선택적 사용시의 세션 보안](http://www.phpschool.com/link/tipntech/79296)을 강화하고,
CSRF 방어 기능을 추가하고, 정기적으로 세션 식별자를 교체해 주도록 개선했습니다.

XSS 및 세션 탈취 방어 기능은 `before_module_init` 시점에 실행되며, 작동 원리는 아래와 같습니다.

  - 세션 쿠키와 동일한 도메인, 경로, 유효기간을 갖는 쿠키 `xe_shield`을 생성하여 40자리의 랜덤 문자열을 넣습니다.
    - 이 쿠키는 `httpOnly` 속성을 가지므로, XSS 공격을 당하더라도 스크립트에 노출되지 않습니다.
    - 쿠키값을 세션에 저장해 두고, 이후 요청을 할 때마다 쿠키값과 세션에 저장된 값을 비교합니다.
    - 쿠키값이 없거나, 쿠키값과 세션에 저장된 값이 일치하지 않는 경우 세션이 탈취된 것으로 간주하고 강제 로그아웃 조치합니다.
    - 따라서 XSS 공격으로 세션을 탈취하더라도 공격자가 탈취한 세션을 사용할 수 없게 됩니다.
  - SSL 사용시에는 `secure` 속성을 갖는 `xe_shield_ssl` 쿠키를 별도로 생성하고, 또다른 40자리의 랜덤 문자열을 넣습니다.
    - 이 쿠키는 SSL이 적용된 페이지를 요청할 때만 전송되므로,
      SSL이 적용되지 않은 페이지를 방문하더라도 중간자 공격에 노출되지 않습니다.
    - 쿠키값을 세션에 저장해 두고, 이후 SSL이 적용된 페이지를 방문하면 쿠키값과 세션에 저장된 값을 비교합니다.
    - 쿠키값이 없거나, 쿠키값과 세션에 저장된 값이 일치하지 않는 경우 세션이 탈취된 것으로 간주하고 강제 로그아웃 조치합니다.
    - 따라서 중간자 공격으로 세션을 탈취하더라도 SSL이 적용되지 않은 페이지에서만 탈취한 세션을 사용할 수 있고,
      로그인과 관리 모듈 등 SSL이 적용된 중요한 페이지에서는 사용할 수 없게 됩니다.
  - 위에서 생성한 두 쿠키값은 10분 간격으로 교체하며, 로그인시에도 자동으로 교체하여 세션 고정 공격에 방어합니다.
  - 쿠키값을 교체한 후에도 2분간은 예전의 쿠키값을 허용하여, 쿠키값 교체에 즉시 반응하지 못하는 IE8 버그를 우회합니다.
  - 플래시 업로드와 같이, 세션을 정상적으로 사용할 수 없는 상황에서는 자동으로 애드온 실행을 중지합니다.

CSRF 공격 방어 기능은 `before_module_init` 및 `before_display_content` 시점에 실행되며, 작동 원리는 아래와 같습니다.

  - 랜덤으로 생성한 토큰을 웹 페이지의 모든 폼에 hidden 필드로 삽입합니다. (`GET`으로 요청하는 폼은 제외)
  - AJAX 요청 함수들(`exec_html`, `exec_json`, `exec_xml`)을 확장하여 모든 AJAX 요청에 토큰을 추가합니다.
  - `GET`이 아닌 요청을 받으면 세션에 저장된 토큰과 폼으로 제출된 토큰을 비교하여, 일치하지 않을 경우 오류를 발생시킵니다.
  - 플래시 업로드, 일회성 API 요청 등에서는 토큰을 비교하지 않습니다.

이 애드온 사용시 주의해야 할 점은 아래와 같습니다.

  - SSO, 가상사이트, 같은 도메인 아래에 XE를 2개 이상 설치한 경우의 호환성은 충분히 테스트되지 않았습니다.
  - XE 1.6 ~ 1.7.7.1은 세션 식별자를 주기적으로 교체해 주는 기능이 XE Core에 포함되어 있었으나,
    일부 IE8 사용자들의 로그인이 풀린다는 신고에 따라 XE 1.7.7.2에서 해당 기능이 제거되었습니다.
    이 애드온에서는 같은 문제가 생기지 않도록 여러 가지 조치를 하였으나,
    로그인이 풀리는 문제를 겪으셨던 분은 이 애드온 사용시에도 주의하시기 바랍니다.
  - XE Core와 마찬가지로 `$_SERVER['HTTPS']` 초전역변수를 통해 SSL 사용 여부를 판단하므로,
    일부 CDN이나 로드밸런서 사용시에는 SSL 사용 여부를 정확하게 판단하지 못할 수도 있습니다.
  - 다른 프로그램과 연동하는 경우 CSRF 토큰 일치 여부를 정확하게 판단하지 못할 수도 있습니다.
  - 세션 쉴드가 실행되기 전에 단 1바이트라도 화면에 출력하면 쿠키가 구워지지 않습니다.
    빈 줄, 기타 공백 문자, UTF-8 BOM 등에 주의해 주시기 바랍니다.

라이선스는 XE와 같은 LGPL v2.1입니다.
