<?php
	/**
	 * @class  moneyhistoryAdminView
   * @author KrteamENT (http://anizone.kr)
	 * @brief The admin view class of the moneyhistory module
	 */
	 
	class moneyhistoryAdminView extends moneyhistory
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
			$oMoneyhistoryModel = &getModel('moneyhistory');
			$this->module_config = $oMoneyhistoryModel->getModuleConfig();
			Context::set('module_config', $this->module_config);
			
			$this->setTemplatePath($this->module_path.'tpl');
		}

		/**
		 * @brief ?°?d
		 */
		function dispMoneyhistoryAdminSetting()
		{
		    $oModuleModel = &getModel('module');	
	
			    $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);
			
	$mskin_list = $oModuleModel->getSkins($this->module_path, "m.skins");
			Context::set('mskin_list', $mskin_list);
			
			$this->setTemplateFile('setting');
		}		

		/**
		 * @brief ?½º?¸® ¸??		 */
		function dispMoneyhistoryAdminList()
		{
			$oMemberModel = &getModel('member');
			$oModuleModel = &getModel('module');
			$member_config = $oModuleModel->getModuleConfig('member');
			
  if($member_config->identifier == 'user_id') $search_option = array('nick_name','user_id');
            else $search_option = array('nick_name','email');
            Context::set('search_option', $search_option);
			
			$args = new stdClass();
			$search_keyword = Context::get('search_keyword');
			$search_target = Context::get('search_target');			
            if($search_target && $search_keyword) {
				if($search_target == 'user_id' && $member_config->identifier == 'user_id') {
					$args->member_srl = $oMemberModel->getMemberSrlByUserID($search_keyword);
					if(!$args->member_srl) $args->member_srl = 0;
				}elseif($search_target == 'email') {
					$args->member_srl = $oMemberModel->getMemberSrlByEmailAddress($search_keyword);
					if(!$args->member_srl) $args->member_srl = 0;
				}elseif($search_target == 'nick_name') {
					$args->member_srl = $oMemberModel->getMemberSrlByNickName($search_keyword);
					if(!$args->member_srl) $args->member_srl = 0;	
				}
            }
			
			$args->htype = Context::get('htype');
		    $args->page = Context::get('page');
            $output = executeQuery('moneyhistory.getMoneyhistoryList',$args);
			if($output->data){
				foreach($output->data as $key=> $val){	
					$member_info = $oMemberModel->getMemberInfoByMemberSrl($val->member_srl);
					$val->nick_name = $member_info->nick_name;				
					$output->data[$key] = $val;	
				}
			}
			
            Context::set('total_count', $output->page_navigation->total_count);
            Context::set('total_page', $output->page_navigation->total_page);
            Context::set('page', $output->page);
            Context::set('moneyhistory_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);	
			
			$this->setTemplateFile('list');
		}
		
	}