<?php
	/**
	 * @class  moneyhistoryAdminController
     * @author KrteamENT (http://anizone.kr)
	 * @brief The admin controller class of the moneyhistory module
	 */
	
	class moneyhistoryAdminController extends moneyhistory 
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
		}

        /**
         * @brief ?°?d
         **/
        function procMoneyhistoryAdminSetting() 
		{
            $args = Context::getRequestVars();
			if($args->member_menu_name==Context::getLang('moneyhistory_list')){
				unset($args->member_menu_name);
			}elseif(!$args->member_menu_name){
				$args->member_menu_name ='';
			}
			
            $oModuleController = &getController('module');
            $oModuleController->insertModuleConfig('moneyhistory', $args);	
			
            $this->setMessage('success_updated');
			
			if(__ZBXE_VERSION__>='1.7'){
				$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispMoneyhistoryAdminSetting');
				$this->setRedirectUrl($returnUrl);
			}
        }
		
        /**
         * @brief ?½º?¸® ≫?
         **/
        function procMoneyhistoryAdminDeleteHistory() 
		{	
			$regdate = Context::get('date_srl');
			if(!$regdate) return new Object(-1, 'msg_invalid_request');
			
			$args = new stdClass();
		    $args->regdate = $regdate;
            $output = executeQuery('moneyhistory.deleteMoneyhistory', $args);
            if(!$output->toBool()) return $output;

            $this->setMessage('success_deleted');
			
			if(__ZBXE_VERSION__>='1.7'){
				$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispMoneyhistoryAdminList','page',Context::get('page'));
				$this->setRedirectUrl($returnUrl);
			}
        }	
		
	}