<?php
	/**
	 * @class  MoneyhistoryController
   * @author KrteamENT (http://anizone.kr)
	 * @brief Controller class of moneyhistory modules
	 */
	class moneyhistoryController extends moneyhistory
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
		}
		
 		/**
		 *@brief module Handler ?¸®°E		 **/		
        function triggerModuleHandler(&$obj) {
            if(!Context::get('is_logged')) return new Object();
			$oMoneyhistoryModel = &getModel('moneyhistory');
			$module_config = $oMoneyhistoryModel->getModuleConfig();
			
			//?¿??¿¡ ?°¡
			if($module_config->member_menu_name){			
				$oMemberController = &getController('member');
				$oMemberController->addMemberMenu('dispMoneyhistoryList', $module_config->member_menu_name);
			}
			
            return new Object();
        }
		
 		/**
		 *@brief ¸?????Ŀ
		 **/
        function triggerBeforeModuleObject(&$obj)
		{
			$oMoneyhistoryModel = &getModel('moneyhistory');
			$module_config = $oMoneyhistoryModel->getModuleConfig();			
			
			//½?ð￡ ?N? °¨¶ Before
			if($module_config->money_record_way == 'realtime'){
				$oMoneyhistoryModel->actionMoneyhistory($obj,'Before');
			}
			
			//¸??¤º¸ze
			if($module_config->money_record_way == 'trigger'){
				$GLOBALS['__module_info__'] = &$obj;
			}
			
			return new Object();
        }	
		
 		/**
		 *@brief ¸??????¸®Ŀ
		 **/
        function triggerAfterModuleObject(&$obj)
		{
			$oMoneyhistoryModel = &getModel('moneyhistory');
			$module_config = $oMoneyhistoryModel->getModuleConfig();
			
			//½?ð￡ ?N? °¨¶ After
			if($module_config->money_record_way == 'realtime'){
				$oMoneyhistoryModel->actionMoneyhistory($obj,'After');
			}
			
			return new Object();
        }
		
 		/**
		 *@brief ´??μ?®¸®Ŀ
		 **/
        function triggerDownloadFile(&$obj)
		{
			$logged_info = Context::get('logged_info');	
			if(!$logged_info) return new Object();
			
			$oMoneyhistoryModel = &getModel('moneyhistory');
			$module_config = $oMoneyhistoryModel->getModuleConfig();
			if($module_config->money_record_way != 'realtime') return new Object();
			
			//½?ð￡ ?N? °¨¶ (´??μ???®´ μ쿲?³¸®?)
			$obj->act = 'procFileDownload';
			$oMoneyhistoryModel = &getModel('moneyhistory');
			$oMoneyhistoryModel->recordMoneyhistory($obj,$logged_info->member_srl);
			
			return new Object();
        }
		
 		/**
		 *@brief ?N? μ°¨ ?¸®Ŀ (XE 1.7.4 L≫??¿? **/
        function triggerSetMoney(&$obj)
		{
			$oMoneyhistoryModel = &getModel('moneyhistory');
			$module_config = $oMoneyhistoryModel->getModuleConfig();
			if($module_config->money_record_way != 'trigger') return new Object();
			
			if($obj->current_money == $obj->set_money) return new Object();
			$module_info = $GLOBALS['__module_info__'];
			
			$history = new stdClass();
			if($obj->current_money > $obj->set_money){
				$history->htype = 'M';		
			}else{
				$history->htype = 'A';	
			}
			$history->money = abs($obj->current_money-$obj->set_money);
			$history->member_srl = $obj->member_srl;
			$history->content = $oMoneyhistoryModel->getMoneyhistoryContent($module_info,$history);
			$history->module_srl = $module_info->module_srl;
			$history->act = $module_info->act;		
			executeQuery('moneyhistory.insertMoneyhistory', $history);
			
			return new Object();
        }
		
 		/**
		 *@brief ?¿?? ?¸®°E		 **/
        function triggerDeleteMember($obj) {
		
			//?¿?φ® ?½º?¸® ≫?		
            $output = executeQuery('moneyhistory.deletePointhistory', $obj);		
            if(!$output->toBool()) return $output;
			
			return new Object();
		}
		
	}