<?php
	/**
	 * @class  moenyhistory
   * @author KrteamENT (http://anizone.kr)
	 * @brief The parent class of the Moneyhistory module
	 */
	
	define('__moneyhistory_Module_Version__', '0.1');
	
	class moneyhistory extends ModuleObject
	{
		var $triggers = array(
			array('moduleHandler.init', 'moneyhistory', 'controller', 'triggerModuleHandler', 'after'),
			array('moduleObject.proc', 'moneyhistory', 'controller', 'triggerBeforeModuleObject', 'before'),
			array('moduleObject.proc', 'moneyhistory', 'controller', 'triggerAfterModuleObject', 'after'),
			array('file.downloadFile', 'moneyhistory', 'controller', 'triggerDownloadFile', 'after'),
			array('money.setMoney', 'moneyhistory', 'controller', 'triggerSetMoney', 'after'),
			array('member.deleteMember', 'moneyhistory', 'controller', 'triggerDeleteMember', 'after')
		);
		
		/**
		 * @brief ¸??¼³?
		 */
		function moduleInstall()
		{
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
			
			return new Object();
		}

		/**
		 * @brief ¾???® u?
		 */
		function checkUpdate()
		{
            $oDB = &DB::getInstance();
            $oModuleModel = &getModel('module');
			
			//?¸®Ŀ ¼³?
			foreach($this->triggers as $trigger)
			{
				if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) return true;
			}
			
			//module_srl ?μ??¡ V0.1.3
			if(!$oDB->isColumnExists("moneyhistory", "module_srl")) return true;
			
			return false;
		}

		/**
		 * @brief ¾???®
		 */
		function moduleUpdate()
		{
            $oDB = &DB::getInstance();
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
			
			//?¸®Ŀ ¼³?
			foreach($this->triggers as $trigger)
			{
				if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]))
				{
					$oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
				}
			}
			
			//module_srl ?μ??¡ V0.1.3
			if(!$oDB->isColumnExists("moneyhistory", "module_srl")) $oDB->addColumn("moneyhistory", "module_srl", "number",11,0,true);
			
			return new Object(0, 'success_updated');
		}
	
		/**
		 * @brief ¸??|°E		 */
		function moduleUninstall()
		{
			$oDB = &DB::getInstance();		
			$oModuleModel = &getModel('module');
			$oModuleController = &getController('module');
			
			//?¸®Ŀ f°E			foreach($this->triggers as $trigger)
			{
				if($oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]))
				{
					$oModuleController->deleteTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
				}
			}
			
			return new Object();
		}
		
		/**
		 * @brief ĳ½?ŀ?g≫?? */
		function recompileCache()
		{
		}
	}