/**
 * Copyright (C) NAVER <http://www.navercorp.com>
 * @file layout.basic.js
 * @author NAVER (developers@xpressengine.com)
 *
 * Find and create module object by mif, act in Request Argument
 * Set module information
 *
 * @mainpage XpressEngine
 * @section intro introduction
 *
 * XE is an opensource and being developed in the opensource project.
 * For more information, please see the link below.
 * - Official website: http://www.xpressengine.com
 * - Offcial Repository: https://github.com/xpressengine/xe-core
 * 
 * "XpressEngine (XE)" is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU Lesser General Public 
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version. 
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 **/

jQuery(function($) {
    // 카테고리 박스에서 하위분류가 없을대 처리
    if($('.exam_top_category').length) {
        var $category = $('.exam_top_category');
        if(!$category.find('> ul > li.on > ul').length) {
            $category.removeClass('sub_type');
        }
    }
    // 객관식 문제에서 답 클릭시 입력과함께 표시
    $('.qanswer_list a.ans_check').click(function(event) {
        event.preventDefault();
        var chk_val = $(this).attr('data-value').split(',');

        var $answer = $('#answer'+chk_val[0]);
        if($answer.length < 1) return;

        $answer.val(chk_val[1]);
        $answer.parent().find('.marking').remove();
        $answer.parent().find('li').eq(chk_val[1]-1).append('<div class="marking"></div>');
    });
});


