<?php
require_once(_XE_PATH_.'modules/exam/exam.item.php');
require_once(_XE_PATH_.'modules/exam/exam.question.item.php');

/**
 * @class  exam
 * @author 러키군 (admin@barch.kr)
 * @brief high class of the module page
 */
class exam extends ModuleObject
{
	var $search_option = array('exam_title','user_name','nick_name'); /// 검색 옵션
	var $order_target = array('join_count', 'regdate', 'last_update'); // 정렬 옵션
	var $skin = "default"; ///< skin name
	var $list_count = 20; ///< the number of documents displayed in a page
	var $page_count = 10; ///< page number
	var $category_list = NULL; ///< category list

    // 모듈 트리거 목록
	private $triggers = array(
		array(
			'name' => 'menu.getModuleListInSitemap',
			'module' => 'exam',
			'type' => 'model',
			'func' => 'triggerModuleListInSitemap',
			'position' => 'after'
		),
	);

    /**
     * @brief 모듈 설치 시 호출.
	 */
	function moduleInstall()
	{
		// 트리거 추가
        $oModuleController = getController('module');
		foreach($this->triggers as $trigger)
		{
			$oModuleController->insertTrigger($trigger['name'],$trigger['module'],$trigger['type'],$trigger['func'],$trigger['position']);
		}

        // exam generated from the cache directory to use
		FileHandler::makeDir('./files/cache/exam');

		return new Object();
	}

	/**
	 * @brief  업데이트 체크를 위해 호출.
	 */
	function checkUpdate()
	{
		// 트리거 확인해서 추가안된 항목이 있으면 true 리턴
		$oModuleModel = getModel('module');
        foreach($this->triggers as $trigger)
		{
			$res = $oModuleModel->getTrigger($trigger['name'],$trigger['module'],$trigger['type'],$trigger['func'],$trigger['position']);
			if (!$res)
			{
				return true;
			}
		}
        return false;
	}

	/**
	 * @brief 모듈 업데이트 시 호출.
	 */
	function moduleUpdate()
	{
		$oModuleModel = getModel('module');
		$oModuleController = getController('module');

        // 트리거 확인 및 추가
		foreach($this->triggers as $trigger)
		{
			$res = $oModuleModel->getTrigger($trigger['name'],$trigger['module'],$trigger['type'],$trigger['func'],$trigger['position']);
			if (!$res)
			{
				$oModuleController->insertTrigger($trigger['name'],$trigger['module'],$trigger['type'],$trigger['func'],$trigger['position']);
			}
		}
        return new Object(0,'success_updated');
	}

	/**
	 * @brief 캐시파일 재생성시 호출됨.
	 */
	function recompileCache()
	{
	}

	/**
	 * @brief 쉬운 설치를 통한 모듈 삭제 시 호출된다.
	 */
	public function moduleUninstall()
	{
		// 트리거 제거
		$oModuleController = getController('module');
        foreach($this->triggers as $trigger)
		{
			$res = $oModuleModel->deleteTrigger($trigger['name'],$trigger['module'],$trigger['type'],$trigger['func'],$trigger['position']);
		}
		
		return new Object();
	}
	/**
	 * Exam Status List
	 * @return array
	 */
	function getStatusList()
	{
		$statusList = Context::getLang('statusList');
		return $statusList;
	}
	function getResultStatusList()
	{
		$statusList = Context::getLang('resultStatusList');
		return $statusList;
	}
	function getConfigStatus($key='',$key_return=false) {
		$list = $this->getStatusList();
		if($key && array_key_exists(strtolower($key), $list)) return ($key_return)? $key : $list[$key];
		else return ($key_return)? 'Y' : $list['Y'];
	}
	function getConfigPageType($key=0,$key_return=false) {
		$list = Context::getLang('pageTypeList');
		if(array_key_exists(strtolower($key), $list)) return ($key_return)? $key : $list[$key];
		else return ($key_return)? 0 : $list[0];
	}
	function getConfigResultType($key=0,$key_return=false) {
		$list = Context::getLang('resultTypeList');
		if(array_key_exists(strtolower($key), $list)) return ($key_return)? $key : $list[$key];
		else return ($key_return)? 0 : $list[0];
	}
}
/* End of file exam.class.php */
/* Location: ./modules/exam/exam.class.php */
