<?php
/**
 * @class  examAdminController
 * @author 러키군 (admin@barch.kr)
 * @brief  exam module admin controller class
 */
class examAdminController extends exam
{
	/**
	 * @brief initialization
	 **/
	function init()
	{
	}
    /**
	 * @brief 시험 설정 저장
	 **/
    public function procExamAdminInsertModule()
	{
		// igenerate module model/controller object
		$oModuleController = getController('module');
		$oModuleModel = getModel('module');

		// setup the board module infortmation
		$args = Context::getRequestVars();
		$args->module = 'exam';
		$args->mid = $args->exam_name;
		unset($args->exam_name);

		// setup other variables
		if(!in_array($args->order_target,$this->order_target)) $args->order_target = 'document_srl';
		if(!in_array($args->order_type, array('asc', 'desc'))) $args->order_type = 'asc';

		// if there is an existed module
		if($args->module_srl) {
			$args->hide_category = 'N';
			$module_info = $oModuleModel->getModuleInfoByModuleSrl($args->module_srl);
			if($module_info->module_srl != $args->module_srl) unset($args->module_srl);
		}

		// insert/update the board module based on module_srl
		if(!$args->module_srl) {
			$args->hide_category = 'N';
			$output = $oModuleController->insertModule($args);
			$msg_code = 'success_registed';
		} else {
			$args->hide_category = $module_info->hide_category;
			$output = $oModuleController->updateModule($args);
			$msg_code = 'success_updated';
		}

		if(!$output->toBool()) return $output;

		// setup list config
		$list = explode(',',Context::get('list'));
		if(count($list))
		{
			$list_arr = array();
			foreach($list as $val)
			{
				$val = trim($val);
				if(!$val) continue;
				$list_arr[] = $val;
			}
			$config = new StdClass();
			$config->list_config = $list_arr;
			$oModuleController = getController('module');
			$oModuleController->insertModulePartConfig('exam', $output->get('module_srl'), $config);
		}

		$this->setMessage($msg_code);
		if (Context::get('success_return_url')){
			changeValueInUrl('mid', $args->mid, $module_info->mid);
			$this->setRedirectUrl(Context::get('success_return_url'));
		}else{
			$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispExamAdminInsert', 'module_srl', $output->get('module_srl')));
		}
	}
    /**
	 * @brief 시험 모듈 삭제
	 **/
	public function procExamAdminDeleteModule()
	{
		$module_srl = Context::get('module_srl');
		if(!$module_srl) return new Object(-1, 'msg_invalid_request');

		$oModuleController = getController('module');
		$output = $oModuleController->deleteModule($module_srl);
		$output = $this->deleteModuleAfter($module_srl);

		// Call a trigger (after)

		// Call a trigger (after)
		if(!$output->toBool()) return $output;

		$obj = new StdClass();
		$obj->module_srl = $module_srl;
		$trigger_output = ModuleHandler::triggerCall('exam.deleteModule', 'after', $obj);
		if(!$trigger_output->toBool())
		{
			return $trigger_output;
		}

		$this->add('module','exam');
		$this->add('page',Context::get('page'));
		$this->setMessage('success_deleted');

		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispExamAdminList');
		$this->setRedirectUrl($returnUrl);
    }

    /**
	 * @brief 분류 설정 저장
	 **/
	public function procExamAdminSaveCategorySettings()
	{
		$module_srl = Context::get('module_srl');
		$mid = Context::get('mid');

		$oModuleModel = getModel('module');
		$module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
		if($module_info->mid != $mid)
		{
			return new Object(-1, 'msg_invalid_request');
		}

		$module_info->hide_category = Context::get('hide_category') == 'Y' ? 'Y' : 'N';
		$oModuleController = getController('module');
		$output = $oModuleController->updateModule($module_info);
		if(!$output->toBool())
		{
			return $output;
		}

		$this->setMessage('success_updated');
		if (Context::get('success_return_url'))
		{
			$this->setRedirectUrl(Context::get('success_return_url'));
		}
		else
		{
			$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispExamAdminCategoryList', 'module_srl', $output->get('module_srl')));
		}
	}
    /**
	 * @brief 시험 모듈 삭제처리하는 함수
	 **/
	public function deleteModuleAfter($module_srl)
	{
		if(!$module_srl) return new Object(-1, 'msg_invalid_request');

		$args = new StdClass();
		$args->module_srl = $module_srl;
		$output = executeQuery('exam.deleteExamByModuleSrl', $args);
		if(!$output->toBool()) return $output;
		$output = executeQuery('exam.deleteExamQuestionByModuleSrl', $args);
		if(!$output->toBool()) return $output;
		$output = executeQuery('exam.deleteExamResultByModuleSrl', $args);

		return $output;
	}
}
/* End of file exam.admin.controller.php */
/* Location: ./modules/exam/exam.admin.controller.php */
