<?php
	/**
	 * @class  smithAdminController
	 * @author sejin7940 (sejin7940@nate.com)
	 * @brief  smith 모듈의 AdminController class
	 **/

	class smithAdminController extends smith {

		/**
		 * @brief Initialization
		 **/
		function init() {
			
		}


        /**
         * @brief 관리자 - 설정 저장
         **/
        function procSmithAdminConfig() {
            $config = Context::getRequestVars();
            $oModuleController = &getController('module');
            $oModuleController->insertModuleConfig('smith', $config);

            $this->setMessage('success_saved');

			if(!in_array(Context::getRequestMethod(),array('XMLRPC','JSON'))) 
			{
				$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', Context::get('module'), 'act', 'dispSmithAdminConfig','module_srl',Context::get('module_srl'));
				$this->setRedirectUrl($returnUrl);
			}

        }



		// 사이트 복사 기능
		function procSmithAdminCopy() {

			$oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('smith');		
			if(!$config->api_url){
				$config->api_url="http://seobaek.cafe24.com/beezbuilder_api.php";
			}

            $args = Context::getRequestVars();
			$result = $this->curl_post($config->api_url, (array)$args);
			//print_r($result);exit;
			$this->setMessage($result);
			
			if(!in_array(Context::getRequestMethod(),array('XMLRPC','JSON'))) 
			{
				$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', Context::get('module'), 'act', 'dispSmithAdminCopy','module_srl',Context::get('module_srl'));
				$this->setRedirectUrl($returnUrl);
			}

		}






		// 사이트 생성 기능
		function procSmithAdminMake() {

			$oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('smith');		
			if(!$config->api_url){
				$config->api_url="http://seobaek.cafe24.com/beezbuilder_api.php";
			}
            $args = Context::getRequestVars();
			$result = $this->curl_post($config->api_url, (array)$args);
			//print_r($result);exit;
            $this->setMessage($result);

			if(!in_array(Context::getRequestMethod(),array('XMLRPC','JSON'))) 
			{
				$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', Context::get('module'), 'act', 'dispSmithAdminConfig','module_srl',Context::get('module_srl'));
				$this->setRedirectUrl($returnUrl);
			}
		}



		// post request를 수행할수 있는 curl함수
		function curl_post($url, $post) {

			foreach($post as $k=>$v){
				$post_encrypt[$k] = $this->encrypt($v,"xc2014","beez");
			}
			//print_r($post_encrypt);
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl, CURLOPT_POST, 1);
			curl_setopt($curl, CURLOPT_POSTFIELDS, $post_encrypt);
			curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			$data = curl_exec($curl);
			curl_close($curl);
			return $data;
		}
 



		 function encrypt($decrypted, $password, $salt) {
			// Build a 256-bit $key which is a SHA256 hash of $salt and $password.
			$key = hash('SHA256', $salt . $password, true);
			// Build $iv and $iv_base64.  We use a block size of 128 bits (AES compliant) and CBC mode.  (Note: ECB mode is inadequate as IV is not used.)
			srand();
			$iv = mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC),MCRYPT_RAND);
			if (strlen($iv_base64 = rtrim(base64_encode($iv), '=')) != 22) return false;
			// Encrypt $decrypted and an MD5 of $decrypted using $key.  MD5 is fine to use here because it's just to verify successful decryption.
			$encrypted = base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $decrypted .md5($decrypted), MCRYPT_MODE_CBC, $iv));
			// We're done!
			return $iv_base64 . $encrypted;
		}



	}
?>