<?php
// PHP용 GCM 푸시 라이브러리
require_once("Notify.php");

class apporixController extends apporix {
	function init(){
	}
	
	// 현재 접속중인 디바이스의 ID를 세션에 저장합니다.
	function setCurrentDevice($device_id){
		$_SESSION["device_id"] = $device_id;
	}

	// 하나의 디바이스에 푸시알림을 전송합니다.
	function notification($device_id, $title, $message, $options){
		$oPhoneModel = &getModel("apporix");
		$api_gcm = $oPhoneModel->getServerGCMKey();
		$oGCM = new GCMPushMessage($api_gcm);

		$options["title"] = $title;

		$oGCM->setDevices(array($device_id));
		$oGCM->send($message, $options);
	}

	// 모든 디바이스에 푸시알림을 전송합니다.
	function notificationAll($title, $message, $options){
		$oPhoneModel = &getModel("apporix");
		$api_gcm = $oPhoneModel->getServerGCMKey();
		$oGCM = new GCMPushMessage($api_gcm);

		$options["title"] = $title;

		$oGCM->setDevices($oPhoneModel->getAllDevice());
		$oGCM->send($message, $options);
	}
	
	// 게시글이 등록되었을 때 실행되는 트리거입니다.
	function triggerAfterInsertDocument(&$obj){
		$oPhoneModel = &getModel("apporix");
		$moduled = $oPhoneModel->getServerSetting("no_module").",...";
		$moduledArr = explode(",", str_replace(" ", "", urldecode($moduled)));

		$oModModel = &getModel("module");

		foreach($moduledArr as $val){
			$info = $oModModel->getModuleInfoByMid($val);
			if($info->module_srl == $obj->module_srl)
				return;
		}

		if($oModModel->getModuleInfoByDocumentSrl($obj->document_srl)->module == "page")
			return;

		$title = $obj->title;
		$nickname = $obj->nick_name;
		$document_srl = $obj->document_srl;

		$text = $oPhoneModel->getServerSetting("lang_new_document");
		if($text == "") $text = "새로운 게시글이 등록되었습니다.";

		$this->notificationAll($text, $title." by. ".$nickname, array("srl" => $document_srl, "type" => "document"));
	}
	
	// 댓글이 등록되었을 때 실행되는 트리거입니다.
	function triggerAfterInsertComment(&$obj){
		$oPhoneModel = &getModel("apporix");

		$oDocumentModel = &getModel("document");
		$doc_info = $oDocumentModel->getDocument($obj->document_srl);

		$device1 = $oPhoneModel->getDevice($doc_info->get("member_srl"));
		
		$oCommentModel = &getModel("comment");
		$parent_comment_info = $oCommentModel->getComment($obj->parent_srl);

		$device2 = $oPhoneModel->getDevice($parent_comment_info->get("member_srl"));
		
		$content = strip_tags($obj->content);
		$nickname = $obj->nick_name;
		$document_srl = $obj->document_srl;

		$text = $oPhoneModel->getServerSetting("lang_new_comment");
		if($text == "") $text = "새로운 댓글이 등록되었습니다.";

		$this->notification($device1, $text, $content." by. ".$nickname, array("srl" => $document_srl, 'type' => "comment"));
		$this->notification($device2, $text, $content." by. ".$nickname, array("srl" => $document_srl, 'type' => "comment"));
	}
	
	// 기기를 등록합니다.
	function addDevice($obj){
		$args = new stdClass;
		$args->device_id = $obj->device_id;

		$r = executeQueryArray("apporix.getDeviceByID", $args);
		if(isset($r->data[0]) && isset($obj->member_srl) == false)
			return;

		$args->member_srl = $obj->member_srl;
		$r = executeQueryArray("apporix.getDevice", $args);
		if(isset($r->data[0]))
			return;

		$args = new stdClass;
		$args->member_srl = $obj->member_srl;
		$args->device_id = $obj->device_id;

		executeQuery("apporix.insertDevice", $args);
	}
	
	// 기기를 등록하기 위해 필요한 장치입니다.
	function procApporixAddUser(){
		$obj = Context::getRequestVars();
		$this->setCurrentDevice($obj->device_id);

		$this->addDevice($obj);
	}

	function triggerAfterSendMessage(&$obj){
		$oPhoneModel = &getModel("apporix");
		$device = $oPhoneModel->getDevice($obj->receiver_srl);

		$text = $oPhoneModel->getServerSetting("lang_message");
		if($text == "") $text = "쪽지가 도착하였습니다.";

		$oMembModel = &getModel("member");
		$sender_name = $oMembModel->getMemberInfoByMemberSrl($obj->sender_srl)->nick_name;

		$this->notification($device, $text, $obj->title." by. ".$sender_name, array("srl" => "", "type"=> "message"));
	}
}
