<?php
class apporixModel extends apporix {
	function init(){
	}
	
	// 현재 접속중인 디바이스 ID를 반환합니다.
	function getCurrentDevice(){
		return $_SESSION["device_id"];
	}
	
	// 현재 디바이스의 어플리케이션 설정값을 반환합니다.
	function getCurrentDeviceSetting($key){
		$curr_device = $this->getCurrentDevice();

		$output = $this->getDeviceSetting($curr_device, $key);
		return $output;
	}
	
	// 현재 디바이스의 소유자를 반환합니다.
	function getCurrentDeviceOwner($device_id){
		$curr_device = $this->getCurrentDevice();

		$output = $this->getDeviceOwner($device_id);
		return $output;
	}

	// 특정 디바이스의 어플리케이션 설정값을 반환합니다.
	function getDeviceSetting($device_id, $key){
		$args = new stdClass();
		$args->device_id = $device_id;
		$args->setting_key = $key;

		$output = executeQueryArray("apporix.getDeviceSetting", $args);
		return $output->data[0]->value;
	}
	
	// 특정 디바이스의 소유자를 반환합니다.
	function getDeviceOwner($device_id){
		$output = $this->getDeviceSetting($device_id, "member_srl");
		return $output;
	}
	
	// 현재 적용되어 있는 GCM 키를 반환합니다.
	function getServerGCMKey(){
		return $this->getServerSetting("api_c2dm");
	}
	
	// 현재 적용되어 있는 설정값을 반환합니다.
	function getServerSetting($key){
		$args = new stdClass();
		$args->type = $key;

		$output = executeQueryArray("apporix.getServerSetting", $args);
		return $output->data[0]->value;
	}
	
	// 등록된 모든 디바이스를 반환합니다.
	function getAllDevice(){
		$output = executeQueryArray("apporix.getAllDevice");
		$devices = array();

		foreach($output->data as $data){
			array_push($devices, $data->device_id);
		}
		
		return $devices;
	}

	function getAllUserDevice(){
		$output = executeQueryArray("apporix.getAllUserDevice");
		$devices = array();

		foreach($output->data as $data){
			if($data->member_srl != 0)
				array_push($devices, $data->device_id);
		}
		
		return $devices;
	}

	// 특정 디바이스를 반환합니다.
	function getDevice($member_srl){
		$args = new stdClass();
		$args->member_srl = $member_srl;

		$output = executeQueryArray("apporix.getDevice", $args);
		return $output->data[0]->device_id;
	}
}