<?php
class pado_board_rankingWidget extends WidgetHandler{

    /*
     * 올바른 값이 Conf에 들어왔는지 확인한다.
     * 올바른 값이 들어오지 않았으면 $basic_value가 들어온다.
     * $info_value = Conf의 값, $basic_value = 기본적인 값
    */
    function Check_RightValue($info_value, $basic_value)
    {
        if(!$info_value)
            $info_value = $basic_value;

        return $info_value;
    }
    /*
     * CSS_Sorce로 변경시켜준다.
     * css_type = CSS의 종류(height, font 등)
     * css_value = CSS의 값(red, 25 등)
     * css_unit = CSS의 단위 값(px em 등)
     */
    function Return_CssSorce($css_type, $css_value, $css_unit=null)
    {
        return $css_type." : ".$css_value.$css_unit.";";
    }

    /*
     * Conf로 받은 값을 ,을 기준으로 나눠준다.
     * $info_value = Conf의 값. 배열의 값으로 반환.
     */
    function Divide_Value($info_value)
    {
        // 값을 반환시키기 위한 배열.
        $return_array = array();
        $info_value = preg_replace('/\s+/', "", $info_value);

        $return_array = explode(',', $info_value);
        return $return_array;
    }

    /*
     * 올바른 색깔 값이 들어왔는지 확인한다.
     * 틀렸을 때 $basic_color가 null 이면 기본값을 대입.
     * null이 아니면 $basic_color를 대입한다.
     */
    function Check_ColorValue($info_value, $basic_color=null)
    {
        $info_value = preg_replace('/\s+/', "", $info_value);

        if($info_value[0] != '#' && !$basic_color)
            $info_value = 기본값;
        else if($info_value[0] != '#' && $basic_color)
            $info_value = $basic_color;

        return $info_value;
    }

    /*
     * 사용할 여부를 체크한다.
     * 사용안함이면 null를 반환.
     */
    function Check_Use($info_value)
    {
        $info_value = preg_replace('/\s+/', "", $info_value);

        if($info_value == '사용안함')
            $info_value = '사용안함';

        return $info_value;
    }

    function proc($args)
    {
        $oModuleModel = getModel('module');
        $config = $oModuleModel->getModuleConfig('point');

        $PointModel = getModel("point");

        $level_icon = "./modules/point/icons/". $config->level_icon;
        Context::set("level_icon", $level_icon);

        $oDocumentModel = &getModel('document');

        //타이틀 설정과 연관된 정보들을 담는 배열. (set)
        $Set_array = array();

        if($args->title_view == "view")
        {
            //제목을 지정해준다. (set) $args->title_name가 빈 칸이면 RANKING이 대입.
            $Set_array['name'] = $this->Check_RightValue($args->title_name, 'RANKING');

            //정렬 방식 (set) 인라인 스타일을 사용할 수 있도록 값 설정.
            $Set_array['line_up'] =$this->Return_CssSorce("text-align", $args->line_up);

            //위젯 타이틀 사이즈 (set)
            $Title_Size = $this->Divide_Value($args->widget_title_size);    //Conf의 값을 두개로 나눠준다.

            settype($Title_Size[0], 'int'); // int형 인지 체크.
            settype($Title_Size[1], 'int'); // int형 인지 체크.

            $Title_Size[0] = $this->Check_RightValue($Title_Size[0], 8);    // 값이 없으면 8 대입
            $Title_Size[1] = $this->Check_RightValue($Title_Size[1], 8);    // 값이 없으면 8 대입

            $args->widget_title_size = $Title_Size[0].",".$Title_Size[1];

            $Set_array['size'] = 'padding : '.$Title_Size[0].'px '.$Title_Size[1].'px;';

            //위젯 타이틀 색깔 (set)
            $args->widget_title_color = $this->Check_ColorValue($args->widget_title_color);

            $Set_array[color] = ""; // 기본값일 떄 빈 값을 넣어주기 위해서.

            if($args->widget_title_color != 기본값)
                $Set_array[color] = $this->Return_CssSorce("background-color", $args->widget_title_color);

            //위젯 타이틀 폰트 크기 (set)
            settype($args->widget_font_size, 'int'); // int형 인지 체크.
            $args->widget_font_size = $this->Check_RightValue($args->widget_font_size, 14); // 값이 빈칸이면 14로 설정

            $Set_array['font_size'] = $this->Return_CssSorce("font-size", $args->widget_font_size, "px");

            //위젯 타이틀 폰트 색 (set)
            $args->widget_font_color = $this->Check_ColorValue($args->widget_font_color);

            $Set_array['font_color'] = "";
            if($args->widget_font_color != 기본값)
                $Set_array['font_color'] = $this->Return_CssSorce("color", $args->widget_font_color);

            /* 스킨 별 기본 값. */

            // 스킨 값 ( 1 )
            $args->border_one_type = $this->Check_Use($args->border_one_type);

            if($args->border_one_type == "사용안함")
                $Set_array['skin1_style'] = "border-bottom : 0px none;";

            else
            {
                $First_Skin =  $this->Divide_Value($args->border_one_type);

                $First_Skin[0] = $this->Check_ColorValue($First_Skin[0], "#000000");
                settype($First_Skin[1], 'int');
                $First_Skin[1] =  $this->Check_RightValue($First_Skin[1], 2);

                $args->border_one_type = $First_Skin[0].",".$First_Skin[1];
                $Set_array['skin1_style'] = "border-bottom :".$First_Skin[1]."px solid ".$First_Skin[0].";";
            }

            // 두번쨰 스킨 Total 부분.
            $args->border_two_type_total = $this->Check_Use($args->border_two_type_total);

            if($args->border_two_type_total == "사용안함")
                $Set_array['skin2_style_total_border'] = "border : 0px none;";
            else
            {
                $Third_Skin = $this->Divide_Value($args->border_two_type_total);

                $Third_Skin[0] = $this->Check_ColorValue($Third_Skin[0], "#B8CEED");
                settype($First_Skin[1], 'int');
                $Third_Skin[1] =  $this->Check_RightValue($Third_Skin[1], 1);

                $args->border_two_type_total = $Third_Skin[0].",".$Third_Skin[1];
                $Set_array['skin2_style_total_border'] = "border : ".$Third_Skin[1]."px solid ".$Third_Skin[0].";";
            }

            // 두번쨰 스킨 밑 테두리 부분.
            $args->border_two_type_under = $this->Check_Use($args->border_two_type_under);

            if($args->border_two_type_under == "사용안함")
                $Set_array['skin2_style_title_border'] = "border-bottom : 0px none;";
            else
            {
                $Third_Skin = $this->Divide_Value($args->border_two_type_under);

                $Third_Skin[0] = $this->Check_ColorValue($Third_Skin[0], "#D6E2F2");
                settype($First_Skin[1], 'int');
                $Third_Skin[1] =  $this->Check_RightValue($Third_Skin[1], 1);

                $args->border_two_type_under = $Third_Skin[0].",".$Third_Skin[1];
                $Set_array['skin2_style_title_border'] = "border-bottom : ".$Third_Skin[1]."px solid ".$Third_Skin[0].";";
            }

            // 스킨 값(3)
            $args->border_three_type = $this->Check_Use($args->border_three_type);

            if($args->border_three_type == "사용안함")
                $Set_array[skin3_style] = "border : 0px none;";
            else
            {
                $Third_Skin = $this->Divide_Value($args->border_three_type);

                $Third_Skin[0] = $this->Check_ColorValue($Third_Skin[0], "#F2595E");
                settype($First_Skin[1], 'int');
                $Third_Skin[1] =  $this->Check_RightValue($Third_Skin[1], 1);

                $args->border_three_type = $Third_Skin[0].",".$Third_Skin[1];
                $Set_array['skin3_style'] = "border : ".$Third_Skin[1]."px solid ".$Third_Skin[0].";";
            }

            //제목 출력 (set)
            $Set_array[view] = $args->title_view;
        }

        else
        {
            // 두번쨰 스킨 Total 부분.
            $args->border_two_type_total = $this->Check_Use($args->border_two_type_total);

            if($args->border_two_type_total == "사용안함")
                $Set_array['skin2_style_total_border'] = "border : 0px none;";
            else
            {
                $Third_Skin = $this->Divide_Value($args->border_two_type_total);

                $Third_Skin[0] = $this->Check_ColorValue($Third_Skin[0], "#B8CEED");
                settype($First_Skin[1], 'int');
                $Third_Skin[1] =  $this->Check_RightValue($Third_Skin[1], 1);

                $args->border_two_type_total = $Third_Skin[0].",".$Third_Skin[1];
                $Set_array['skin2_style_total_border'] = "border : ".$Third_Skin[1]."px solid ".$Third_Skin[0].";";
            }
        }

        //랭킹 이미지
        $Set_array[image] = $args->rank_image;
        $Set_array['use_level_icon'] = $args->use_level_icon;

        $Set_array['CSS_Title'] = "";
        if($Set_array[image] == "crown")
            $Set_array['CSS_Title'] = "Ding_ListRanking_Crown";
        else
            $Set_array['CSS_Title'] = "Ding_ListRanking_Box";;

        //랭킹 부분 넓이. (set)
        settype($args->order_width, 'int');
        $args->order_width = $this->Check_RightValue($args->order_width, 35);
        $Set_array['order_width'] = $this->Return_CssSorce("width", $args->order_width, "px");


        //닉네임 부분 넓이 (set)
        settype($args->nick_width, 'int');
        $args->nick_width = $this->Check_RightValue($args->nick_width, 75);
        $Set_array['nick_width'] = $this->Return_CssSorce("width", $args->nick_width, "px");

        //닉네임을 클릭하면 발동할 이벤트를 설정.
        $Set_array[nick_event] = $args->nick_event;

        //시간 설정. (소스 안)
        $rimit_date = abs($args->limit_date);
        if($rimit_date)
            $now_date = date('YmdHis',strtotime ('-'.$rimit_date.'hours'));
        else
            $now_date = 0;

        //시작 카운터. (소스안, 밖)
        if($args->start_count && $args->start_count != 0)
            $start_count = abs($args->start_count) - 1;
        else
            $start_count =0;

        //짤라 줄 타이틀(게시판) 수
        settype($args->font_content_num, 'int');
        $args->font_content_num = $this->Check_RightValue($args->font_content_num, 0);
        $font_length = $args->font_content_num;

        //짤라 줄 닉네임 수
        settype($args->font_nickname_num, 'int');
        $args->font_nickname_num = $this->Check_RightValue($args->font_nickname_num, 0);
        $nickname_length =  $args->font_nickname_num;

        //쿼리
        $obj = new stdClass();
        $obj->module_srl = $args->module_srls; // 모듈들의 정보.
        $obj->order_target = $args->order_target;   // 정렬 방법
        $obj->now_date = $now_date;                //시간.(내가 쓸 시간)

        $output = executeQueryArray('widgets.pado_board_rankingWidget.getRankDocument', $obj);

        //출력개수
        if($args->list_num) {$list_count = $args->list_num+$start_count;}
        else $list_count = count($output->data);

        $data_array = $output->data;
        $list_array = array();             //넘겨줄 배열.

        $list_num= 0;
        // 내용있음
        for($i=0; $i<$list_count; $i++ )
        {
            if($data_array[$i])
            {
                $list_array[$list_num][title] = cut_str($data_array[$i]->title, $font_length);
                $list_array[$list_num][nick] = cut_str($data_array[$i]->nick_name, $nickname_length);
                $list_array[$list_num][document_srl] = $data_array[$i]->document_srl;
                $list_array[$list_num][member_srl] = "member_".$output->data[$i]->member_srl;
                $list_array[$list_num][mid]= $data_array[$i]->mid;

                $member_point = $PointModel->getPoint($output->data[$i]->member_srl);
                $list_array[$list_num][level] = $PointModel->getLevel($member_point, $config->level_step);

                $list_num++;
            }

            else if(!$data_array[$i] && $args->view_empty == 'view')
            {
                $list_array[$list_num][title] = cut_str("빈 게시판 입니다", $font_length);
                $list_array[$list_num][nick] = cut_str("빈 회원", $nickname_length);
                $list_array[$list_num][document_srl]= "";
                $list_array[$list_num][member_srl] = "";
                $list_array[$list_num][point] = 0;
                $list_array[$list_num][level] = 0;
                $list_num++;
            }
        }

        $widget_info = new stdClass();

        $widget_info->Set_array = $Set_array;               //설정 값
        $widget_info->list_array = $list_array;             //리스트 배열.
        if($args->view_empty == 'view')
            $widget_info->loop_count = $list_count;         //리스트 출력 수.
        else
            $widget_info->loop_count = count($list_array);  //배열 수.
        $widget_info->start_count = $start_count;           //카운팅 시작하는 수.

        Context::set('widget_info', $widget_info);

        $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
        Context::set("tpl_path", $args->skin);
        Context::set('colorset', $args->colorset);

        $tpl_file = 'pado_board_rankingWidget';

        $oTemplate = &TemplateHandler::getInstance();
        return $oTemplate->compile($tpl_path, $tpl_file);
    }
}
?>