<?php
class pado_board_rankingWidget extends WidgetHandler{
    function proc($args)
    {
        $oDocumentModel = &getModel('document');

        //시간 설정.
        $rimit_date = abs($args->limit_date);
        if($rimit_date)
            $now_date = date("YmdHis",strtotime ("-".$rimit_date." hours"));
        else
            $now_date = 0;

        //시작 카운터.
        if($args->start_count && $args->start_count != 0)
            $start_count = abs($args->start_count) - 1;
        else
            $start_count =0;

        //랭킹 부분 넓이.
        if(!$args->order_width) $args->order_width = 50;
        $order_width = "width:".$args->order_width."px";

        //닉네임 부분 넓이
        if(!$args->nick_width) $args->nick_width = 45;
        $nick_width = "width:".$args->nick_width."px";

        //제목을 지정해준다.
        if( $args->title_name )
            $title_name = $args->title_name;
        else
            $title_name = "제목을 지정해주세요.";

        //짤라 줄 타이틀(게시판) 수
        if( $args->font_content_num )
            $font_length = $args->font_content_num;
        else
            $font_length = 0;

        //짤라 줄 닉네임 수
        if($args->font_nickname_num)
            $nickname_length = $args->font_nickname_num;
        else
            $nickname_length =0;

        //쿼리
        $obj = new stdClass();
        $obj->module_srl = $args->module_srls; // 모듈들의 정보.
        $obj->order_target = $args->order_target;   // 정렬 방법

        $output = executeQueryArray('widgets.pado_board_rankingWidget.getRankDocument', $obj);

        //출력개수
        if($args->list_num) {$list_count = $args->list_num;}
        else $list_count = count($output->data);

        $loop_num = count($output->data);   //내용있는 게시물의 수.
        $data_array = $output->data;
        $list_array = array();             //넘겨줄 배열.

        if($loop_num)
        {
            $q= 0;
            // 내용있음
            for($i=0; $i<$list_count; $i++ )
            {
                if($data_array[$i]->regdate >= $now_date && $data_array[$i])
                {
                    $list_array[$q]['title'] = cut_str($data_array[$i]->title, $font_length);
                    $list_array[$q]['nick'] = cut_str($data_array[$i]->nick_name, $nickname_length);
                    $list_array[$q]['document_srl'] = $data_array[$i]->document_srl;
                    $list_array[$q]['member_srl'] = "member_".$output->data[$i]->member_srl;
                    $list_array[$q]['mid']= $data_array[$i]->mid;
                    $q++;
                }
            }
            //내용 없음
            if($args->view_empty == 'view')
            {
                $short_count = $list_count + $start_count - count($list_array);
                for($i=0; $i<$short_count; $i++)
                {
                    $list_array[$q]['title'] = cut_str("빈 게시판 입니다", $font_length);
                    $list_array[$q]['nick'] = cut_str("빈 회원", $nickname_length);
                    $list_array[$q]['document_srl']= "";
                    $list_array[$q]['member_srl'] = "";
                    $q++;
                }
            }
        }

        Context::set("exsd",$output->data[0]);
        $widget_info = new stdClass();

        $widget_info->title_name = $title_name;         //제목
        $widget_info->title_view = $args->title_view;   //타이틀 노출.
        $widget_info->order_width = $order_width;       //순위 넓이
        $widget_info->nick_width = $nick_width;         //닉네임 넓이
        $widget_info->list_array = $list_array;         //리스트 배열.
        if($args->view_empty == 'view')
            $widget_info->loop_count = $list_count + $start_count;   //리스트 출력 수.
        else
            $widget_info->loop_count = count($list_array);
        $widget_info->start_count = $start_count;   //카운팅 시작하는 수.
        $widget_info->nick_event = $args->nick_event;   // 닉네임 액션을 설정.

        Context::set('widget_info', $widget_info);  //foreach문으로 돌려주는 용도.

        $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
        Context::set('colorset', $args->colorset);

        $tpl_file = 'pado_board_rankingWidget';

        $oTemplate = &TemplateHandler::getInstance();
        return $oTemplate->compile($tpl_path, $tpl_file);
    }
}
?>