<?php
class bulkmsgController extends bulkmsg
{
	/**
	 * Initialization
	 * @return void
	 */
	function init()
	{
	}
	
	function triggerModuleHandlerInit(&$module_info){
		$oMemberModel = &getModel('member');
		if(!$oMemberModel->isLogged()) return new Object();
		
		//수신하지 못한 쪽지가 있으면 해당 쪽지를 내 쪽지함으로 당겨와준다.
		$logged_info = Context::get('logged_info');
		$args->member_srl = $logged_info->member_srl;
		$output = executeQueryArray("bulkmsg.getUserNotReceivedMessages",$args);
		
		if($output->data){
			$oDocumentModel = &getModel('document');
			foreach($output->data as $data){
				unset($is_receive);
				//수신대상인지 먼저 확인하고
				if($data->target_type == "A"){
					$is_receive = true;
				}else if($data->target_type == "G"){
					$group_list = explode(",",$data->target_data);
					foreach($group_list as $group_srl){
						if(array_key_exists($group_srl, $logged_info->group_list)) $is_receive = true;
					}
				}else if($data->target_type == "I"){
					$ids = explode(",",$data->target_data);
					if(in_array($logged_info->user_id, $ids)) $is_receive = true;
				}
				
				//수신대상이면 원본 문서를 구해서 쪽지를 발송
				if($is_receive){
					$oDocument = $oDocumentModel->getDocument($data->document_srl);
					$oCommunicationController = &getController('communication');
					$output = $oCommunicationController->sendMessage($oDocument->get('member_srl'), $logged_info->member_srl, $oDocument->getTitleText(), $oDocument->getContent());
				}
				//수신대상이 아니어도 다음쿼리때 조회되지 않도록 수신목록에 추가한다.
				$args->document_srl = $data->document_srl;
				$output = executeQueryArray("bulkmsg.insertUserReceivedMessages",$args);
			}
		}
		//쪽지를 반드시 읽도록 설정되어있으면 쪽지함에서 못벗어나게 만들어줌.
		
		return new Object();
	}
}
