<?php
class bulkmsg extends ModuleObject
{
	/**
	 * @brief install the module
	 **/
	function moduleInstall()
	{
		return new Object();
	}

	/**
	 * @brief chgeck module method
	 **/
	function checkUpdate()
	{
		$oModuleModel = &getModel('module');
		//check module installed
		if(!$oModuleModel->isIDExists($this->module)) return true;
		
		//check triggers
		if(!$oModuleModel->getTrigger('moduleHandler.init', 'bulkmsg', 'controller', 'triggerModuleHandlerInit', 'after'))   return true;
		return false;
	}

	/**
	 * @brief update module
	 **/
	function moduleUpdate()
	{
		// create object
		$oModuleController = &getController('module');
		$oModuleModel = &getModel('module');

		// check module installed
		if(!$oModuleModel->isIDExists($this->module)) {
			// install module
			$site_module_info = Context::get('site_module_info');
			$args->site_srl = $site_module_info->site_srl;
			$args->mid = $this->module;
			$args->module = $this->module;
			$args->browser_title = $this->module;
			
			$output = $oModuleController->insertModule($args);

			// set Editor
			$module_srl = $output->get('module_srl');
			Context::set('target_module_srl', $module_srl);
			Context::set('editor_height', '200');
			Context::set('enable_autosave', 'N');

			$oEditorController = &getController('editor');
			$oEditorController->procEditorInsertModuleConfig();
		}

		// add trigger
		if(!$oModuleModel->getTrigger('moduleHandler.init', 'bulkmsg', 'controller', 'triggerModuleHandlerInit', 'after'))
			$oModuleController->insertTrigger('moduleHandler.init', 'bulkmsg', 'controller', 'triggerModuleHandlerInit', 'after');
		
		return new Object(0, 'success_updated');
	}

	function moduleUninstall()
	{
		return new Object();
	}
}
