<?php
class bulkmsgAdminView extends bulkmsg
{
	/**
	 * Initialization
	 * @return void
	 */
	function init()
	{
		// setup template path (board admin panel templates is resided in the tpl folder)
		$template_path = sprintf("%stpl/",$this->module_path);
		$this->setTemplatePath($template_path);
	}
	
	function dispBulkmsgAdminInsert(){
		$oModuleModel = &getModel('module');
		$oPopupAdminModel = &getAdminModel('popup');
		
		$site_module_info = Context::get('site_module_info');
		Context::set('site_srl',$site_module_info->site_srl);
		
		$oMemberModel = &getModel('member');
		$group_list = $oMemberModel->getGroups();
		Context::set('group_list', $group_list);
		
		// set document Object
		$output = $oModuleModel->getModuleSrlByMid($this->module);
		$document_srl = Context::get('document_srl');
		$oDocumentModel = &getModel('document');
		$oDocument = $oDocumentModel->getDocument($document_srl, true);
		$oDocument->add('module_srl', array_pop($output));
		
		//added Bulk Info
		if($oDocument->isExists()){
			$args->document_srl = $document_srl;
			$output = executeQuery("bulkmsg.getBulkMessage",$args);
			foreach($output->data as $key => $val) $oDocument->add($key,$val);
		}
		
		Context::set('oDocument', $oDocument);

		// 템플릿 파일 지정
		$this->setTemplateFile('insert_message');
	}
	
	function dispBulkmsgAdminIndex(){
		$oModuleModel = &getModel('module');
		$oPopupAdminModel = &getAdminModel('popup');

		// 페이지 옵션
		$args->page = Context::get('page');
		$args->list_count = 20; 
		$args->page_count = 10;
		$args->order_type = 'asc';
		$output = executeQueryArray("bulkmsg.getBulkMessageList",$args);
		// setTemplate
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		Context::set('page_navigation', $output->page_navigation);
		Context::set('message_list', $output->data);

		$this->setTemplateFile("index");
	}
}
