<?php
class bulkmsgAdminController extends bulkmsg
{
	/**
	 * Initialization
	 * @return void
	 */
	function init()
	{
	}
	
	function procBulkmsgAdminUpdateMessage(){
		$args = Context::gets('document_srl','value');
		if(!$args->document_srl) return new Object(-1,"msg_invalid_request");
		
		$args->is_stop = $args->value;
		
		//update Bulkmsg
		$output = executeQuery("bulkmsg.updateBulkMessage",$args);
		if(!$output->toBool()) return $output;
		
		$this->setMessage('success_updated');
	}
	
	function procBulkmsgAdminDeleteMessage(){		
		$args->document_srl = Context::get('document_srl');
		if(!$args->document_srl) return new Object(-1,"msg_invalid_request");
		
		// begin transaction
		$oDB = &DB::getInstance();
		$oDB->begin();
		
		$output = executeQuery("bulkmsg.deleteBulkMessage",$args);
		if(!$output->toBool()) return $output;
		
		$oDocumentController = &getController('document');
		$deleted_output = $oDocumentController->deleteDocument($args->document_srl);
		if(!$deleted_output->toBool()){
			$oDB->rollback();
			return $output;
		}
		
		$oDB->commit();
		$this->setMessage('success_deleted');
	}
	
	function procBulkmsgAdminInsert(){
		$args = Context::gets('title','content','document_srl','target_type','module');
		
		$args->site_srl = Context::get('site_module_info')->site_srl;
		
		//setVariables
		if($args->target_type == "G") $args->target_data = join(",",Context::get('receiver_groups'));
		else if($args->target_type == "I") $args->target_data = Context::get('receiver_ids');
		
		$oDocumentController = &getController('document');
		//update document
		if($args->document_srl){
			//check Document
			$oDocumentModel = &getModel('document');
			$oDocument = $oDocumentModel->getDocument($args->document_srl, $this->grant->manager);
			$output = $oDocumentController->updateDocument($oDocument, $args);
			if(!$output->toBool()) return $output;
	
			//update Bulkmsg
			$output = executeQuery("bulkmsg.updateBulkMessage",$args);
			if(!$output->toBool()) return $output;
			
			$msg_code = 'success_updated';
		//insert document
		}else{
			$output = $oDocumentController->insertDocument($args);
			if(!$output->toBool()) return $output;
			$args->document_srl = $output->get('document_srl');
			
			//insert Bulkmsg
			$output = executeQuery("bulkmsg.insertBulkmessage",$args);
			if(!$output->toBool()){
				$oDocumentController->deleteDocument($args->document_srl);
				return $output;
			}
			
			$msg_code = 'success_registed';
		}
        
		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispBulkmsgAdminIndex');
		$this->setMessage($msg_code);
        $this->setRedirectUrl($returnUrl);
	}
}
